/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.gjex.core.filter.grpc;

import com.flipkart.gjex.core.context.AccessLogContext;
import com.flipkart.gjex.core.filter.RequestParams;
import com.flipkart.gjex.core.filter.grpc.GrpcFilter;
import com.flipkart.gjex.core.filter.grpc.GrpcFilterConfig;
import com.flipkart.gjex.core.logging.Logging;
import com.google.protobuf.GeneratedMessageV3;
import io.grpc.Metadata;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.inject.Named;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;

@Named(value="AccessLogGrpcFilter")
public class AccessLogGrpcFilter<R extends GeneratedMessageV3, S extends GeneratedMessageV3>
extends GrpcFilter<R, S>
implements Logging {
    protected long startTime;
    protected AccessLogContext.AccessLogContextBuilder accessLogContextBuilder = AccessLogContext.builder();
    protected static String format;
    private static final Logger logger;

    public AccessLogGrpcFilter() {
        this.startTime = System.currentTimeMillis();
        this.accessLogContextBuilder.requestTime(this.startTime);
    }

    public static void setFormat(String format) {
        AccessLogGrpcFilter.format = format;
    }

    @Override
    public void doProcessRequest(R req, RequestParams<Metadata> requestParamsInput) {
        this.accessLogContextBuilder.clientIp(requestParamsInput.getClientIp()).resourcePath(requestParamsInput.getResourcePath()).method(requestParamsInput.getMethod());
        Map<String, String> headers = requestParamsInput.getMetadata().keys().stream().collect(Collectors.toMap(String::toLowerCase, key -> (String)Optional.ofNullable(((Metadata)requestParamsInput.getMetadata()).get(Metadata.Key.of((String)key, (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER))).orElse("")));
        this.accessLogContextBuilder.headers(headers);
    }

    @Override
    public void doProcessResponseHeaders(Metadata responseHeaders) {
    }

    @Override
    public void doProcessResponse(S response) {
        this.accessLogContextBuilder.contentLength(response.getSerializedSize()).responseTime(System.currentTimeMillis() - this.startTime).responseStatus(Status.Code.OK.value()).build();
        logger.info(this.accessLogContextBuilder.build().format(format));
    }

    @Override
    public void doHandleException(Exception e) {
        if (e instanceof StatusRuntimeException) {
            this.accessLogContextBuilder.responseStatus(((StatusRuntimeException)e).getStatus().getCode().value());
        } else {
            this.accessLogContextBuilder.responseStatus(Status.Code.INTERNAL.value());
        }
        this.accessLogContextBuilder.contentLength(0).responseTime(System.currentTimeMillis() - this.startTime).build();
        logger.info(this.accessLogContextBuilder.build().format(format));
    }

    @Override
    public GrpcFilter configure(GrpcFilterConfig grpcFilterConfig) {
        if (grpcFilterConfig.isEnableAccessLogs()) {
            AccessLogGrpcFilter<R, S> accessLogGrpcFilter = new AccessLogGrpcFilter<R, S>();
            if (StringUtils.isNotBlank((String)grpcFilterConfig.getAccessLogFormat())) {
                AccessLogGrpcFilter.setFormat(grpcFilterConfig.getAccessLogFormat());
            }
            return accessLogGrpcFilter;
        }
        return null;
    }

    @Override
    public GrpcFilter<R, S> getInstance() {
        return new AccessLogGrpcFilter<R, S>();
    }

    static {
        logger = Logging.loggerWithName("ACCESS-LOG");
    }
}

