/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.gjex.core.setup;

import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.jmx.JmxReporter;
import com.codahale.metrics.jvm.BufferPoolMetricSet;
import com.codahale.metrics.jvm.GarbageCollectorMetricSet;
import com.codahale.metrics.jvm.MemoryUsageGaugeSet;
import com.codahale.metrics.jvm.ThreadStatesGaugeSet;
import io.prometheus.metrics.instrumentation.dropwizard.DropwizardExports;
import io.prometheus.metrics.model.registry.MultiCollector;
import io.prometheus.metrics.model.registry.PrometheusRegistry;
import java.lang.management.ManagementFactory;

public class AppMetricsRegistry {
    private final MetricRegistry metricRegistry;
    private final PrometheusRegistry prometheusRegistry;

    public AppMetricsRegistry(MetricRegistry metricRegistry, PrometheusRegistry prometheusRegistry) {
        this.metricRegistry = metricRegistry;
        this.prometheusRegistry = prometheusRegistry;
        this.registerJVMMetrics();
        this.registerPrometheusDropwizardExports();
        JmxReporter.forRegistry((MetricRegistry)metricRegistry).build().start();
    }

    public AppMetricsRegistry(MetricRegistry metricRegistry) {
        this(metricRegistry, PrometheusRegistry.defaultRegistry);
    }

    public MetricRegistry getMetricRegistry() {
        return this.metricRegistry;
    }

    public PrometheusRegistry getPrometheusRegistry() {
        return this.prometheusRegistry;
    }

    private void registerPrometheusDropwizardExports() {
        this.prometheusRegistry.register((MultiCollector)new DropwizardExports(this.metricRegistry, MetricFilter.ALL));
    }

    private void registerJVMMetrics() {
        this.metricRegistry.register("jvm.buffers", (Metric)new BufferPoolMetricSet(ManagementFactory.getPlatformMBeanServer()));
        this.metricRegistry.register("jvm.gc", (Metric)new GarbageCollectorMetricSet());
        this.metricRegistry.register("jvm.memory", (Metric)new MemoryUsageGaugeSet());
        this.metricRegistry.register("jvm.threads", (Metric)new ThreadStatesGaugeSet());
    }
}

