/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.gjex.grpc.interceptor;

import com.flipkart.gjex.core.filter.Filter;
import com.flipkart.gjex.core.filter.MethodFilters;
import com.flipkart.gjex.core.logging.Logging;
import com.flipkart.gjex.core.util.Pair;
import com.flipkart.gjex.grpc.utils.AnnotationUtils;
import com.google.protobuf.GeneratedMessageV3;
import io.grpc.BindableService;
import io.grpc.ForwardingServerCall;
import io.grpc.ForwardingServerCallListener;
import io.grpc.Metadata;
import io.grpc.ServerCall;
import io.grpc.ServerCallHandler;
import io.grpc.ServerInterceptor;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.validation.ConstraintViolationException;

@Singleton
@Named(value="FilterInterceptor")
public class FilterInterceptor
implements ServerInterceptor,
Logging {
    private Map<String, List<Filter>> filtersMap = new HashMap<String, List<Filter>>();

    public void registerFilters(List<Filter> filters, List<BindableService> services) {
        Map classToInstanceMap = filters.stream().collect(Collectors.toMap(Object::getClass, Function.identity()));
        services.forEach(service -> {
            List<Pair<?, Method>> annotatedMethods = AnnotationUtils.getAnnotatedMethods(service.getClass(), MethodFilters.class);
            if (annotatedMethods != null) {
                annotatedMethods.forEach(pair -> {
                    LinkedList filtersForMethod = new LinkedList();
                    Arrays.asList(((Method)pair.getValue()).getAnnotation(MethodFilters.class).value()).forEach(filterClass -> {
                        if (!classToInstanceMap.containsKey(filterClass)) {
                            throw new RuntimeException("Filter instance not bound for Filter class :" + filterClass.getName());
                        }
                        filtersForMethod.add(classToInstanceMap.get(filterClass));
                    });
                    this.filtersMap.put((service.bindService().getServiceDescriptor().getName() + "/" + ((Method)pair.getValue()).getName()).toLowerCase(), filtersForMethod);
                });
            }
        });
    }

    public <ReqT, RespT> ServerCall.Listener<ReqT> interceptCall(final ServerCall<ReqT, RespT> call, final Metadata headers, ServerCallHandler<ReqT, RespT> next) {
        final List<Filter> filters = this.filtersMap.get(call.getMethodDescriptor().getFullMethodName().toLowerCase());
        for (Filter filter : filters) {
            try {
                filter.doFilterRequest(headers);
            }
            catch (StatusRuntimeException se) {
                call.close(se.getStatus(), se.getTrailers());
                return new ServerCall.Listener<ReqT>(){};
            }
        }
        ServerCall.Listener listener = next.startCall((ServerCall)new ForwardingServerCall.SimpleForwardingServerCall<ReqT, RespT>(call){

            public void sendMessage(RespT response) {
                filters.forEach(filter -> filter.doProcessResponse((GeneratedMessageV3)response));
                super.sendMessage(response);
            }

            public void sendHeaders(Metadata responseHeaders) {
                filters.forEach(filter -> filter.doProcessResponseHeaders(responseHeaders));
                super.sendHeaders(headers);
            }
        }, headers);
        return new ForwardingServerCallListener.SimpleForwardingServerCallListener<ReqT>(listener){

            public void onHalfClose() {
                try {
                    super.onHalfClose();
                }
                catch (RuntimeException ex) {
                    FilterInterceptor.this.handleException(call, ex);
                }
            }

            public void onMessage(ReqT request) {
                filters.forEach(filter -> filter.doProcessRequest((GeneratedMessageV3)request));
                super.onMessage(request);
            }
        };
    }

    private <ReqT, RespT> void handleException(ServerCall<ReqT, RespT> call, Exception e) {
        this.error("Closing gRPC call due to RuntimeException.", e);
        Status returnStatus = Status.INTERNAL;
        if (ConstraintViolationException.class.isAssignableFrom(e.getClass())) {
            returnStatus = Status.INVALID_ARGUMENT;
        }
        call.close(returnStatus.withDescription(e.getMessage()), new Metadata());
    }
}

