/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.gjex.grpc.interceptor;

import com.flipkart.gjex.core.logging.Logging;
import com.flipkart.gjex.core.tracing.ConfigurableTracingSampler;
import com.flipkart.gjex.core.tracing.GJEXContextKey;
import com.flipkart.gjex.core.tracing.Traced;
import com.flipkart.gjex.core.tracing.TracingSampler;
import com.flipkart.gjex.core.util.Pair;
import com.flipkart.gjex.grpc.utils.AnnotationUtils;
import io.grpc.BindableService;
import io.grpc.Context;
import io.grpc.Contexts;
import io.grpc.ForwardingServerCall;
import io.grpc.ForwardingServerCallListener;
import io.grpc.Metadata;
import io.grpc.ServerCall;
import io.grpc.ServerCallHandler;
import io.grpc.ServerInterceptor;
import io.opentracing.Span;
import io.opentracing.SpanContext;
import io.opentracing.Tracer;
import io.opentracing.propagation.Format;
import io.opentracing.propagation.TextMapExtractAdapter;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;

@Singleton
@Named(value="TracingInterceptor")
public class TracingInterceptor
implements ServerInterceptor,
Logging {
    private Map<String, TracingSampler> samplerMap = new HashMap<String, TracingSampler>();
    @Inject
    @Named(value="Tracer")
    Tracer tracer;

    public void registerTracingSamplers(List<TracingSampler> samplers, List<BindableService> services) {
        Map classToInstanceMap = samplers.stream().collect(Collectors.toMap(Object::getClass, Function.identity()));
        services.forEach(service -> {
            List<Pair<?, Method>> annotatedMethods = AnnotationUtils.getAnnotatedMethods(service.getClass(), Traced.class);
            if (annotatedMethods != null) {
                annotatedMethods.forEach(pair -> Arrays.asList(((Method)pair.getValue()).getAnnotation(Traced.class).withTracingSampler()).forEach(samplerClass -> {
                    String samplerComponentName = (service.bindService().getServiceDescriptor().getName() + "/" + ((Method)pair.getValue()).getName()).toLowerCase();
                    if (samplerClass == null) {
                        this.samplerMap.put(samplerComponentName, (TracingSampler)new ConfigurableTracingSampler());
                    } else {
                        if (!classToInstanceMap.containsKey(samplerClass)) {
                            throw new RuntimeException("TracingSampler instance not bound for TracingSampler class :" + samplerClass.getName());
                        }
                        this.samplerMap.put(samplerComponentName, (TracingSampler)classToInstanceMap.get(samplerClass));
                    }
                }));
            }
        });
    }

    public <ReqT, RespT> ServerCall.Listener<ReqT> interceptCall(ServerCall<ReqT, RespT> call, Metadata headers, ServerCallHandler<ReqT, RespT> next) {
        TracingSampler tracingSampler = this.samplerMap.get(call.getMethodDescriptor().getFullMethodName().toLowerCase());
        if (tracingSampler != null) {
            HashMap<String, String> headerMap = new HashMap<String, String>();
            for (String key : headers.keys()) {
                if (key.endsWith("-bin")) continue;
                String value = (String)headers.get(Metadata.Key.of((String)key, (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER));
                headerMap.put(key, value);
            }
            Span span = this.getSpanFromHeaders(call, headerMap);
            Context ctxWithSpan = Context.current().withValues(GJEXContextKey.getKeyRoot(), (Object)span, GJEXContextKey.getKey(), (Object)span, GJEXContextKey.getSpanContextKey(), (Object)span.context(), GJEXContextKey.getTracingSamplerKey(), (Object)tracingSampler);
            ServerCall.Listener listenerWithContext = Contexts.interceptCall((Context)ctxWithSpan, call, (Metadata)headers, next);
            return new ForwardingServerCallListener.SimpleForwardingServerCallListener<ReqT>(listenerWithContext){};
        }
        return new ForwardingServerCallListener.SimpleForwardingServerCallListener<ReqT>(next.startCall((ServerCall)new ForwardingServerCall.SimpleForwardingServerCall<ReqT, RespT>(call){}, headers)){};
    }

    private <ReqT, RespT> Span getSpanFromHeaders(ServerCall<ReqT, RespT> call, Map<String, String> headers) {
        String methodInvoked = call.getMethodDescriptor().getFullMethodName();
        Span span = null;
        try {
            SpanContext parentSpanCtx = this.tracer.extract(Format.Builtin.HTTP_HEADERS, (Object)new TextMapExtractAdapter(headers));
            span = this.tracer.buildSpan(methodInvoked).asChildOf(parentSpanCtx).start();
        }
        catch (IllegalArgumentException iae) {
            span = this.tracer.buildSpan(methodInvoked).withTag("Error", "Extract failed and an IllegalArgumentException was thrown").start();
        }
        return span;
    }
}

