/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.gjex.guice.module;

import brave.Tracing;
import brave.opentracing.BraveTracer;
import com.flipkart.gjex.core.logging.Logging;
import com.flipkart.gjex.core.task.FutureDecorator;
import com.flipkart.gjex.core.task.TaskException;
import com.flipkart.gjex.core.tracing.GJEXContextKey;
import com.flipkart.gjex.core.tracing.Traced;
import com.flipkart.gjex.core.tracing.TracingSampler;
import com.google.common.collect.ImmutableMap;
import com.google.inject.AbstractModule;
import com.google.inject.Provides;
import com.google.inject.matcher.AbstractMatcher;
import com.google.inject.matcher.Matcher;
import com.google.inject.matcher.Matchers;
import io.grpc.BindableService;
import io.grpc.Context;
import io.opentracing.Scope;
import io.opentracing.Span;
import io.opentracing.Tracer;
import io.opentracing.tag.Tags;
import io.reactivex.functions.BiConsumer;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.Callable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import zipkin2.reporter.AsyncReporter;
import zipkin2.reporter.Reporter;
import zipkin2.reporter.Sender;
import zipkin2.reporter.okhttp3.OkHttpSender;

public class TracingModule<T>
extends AbstractModule
implements Logging {
    protected void configure() {
        TracedMethodInterceptor methodInterceptor = new TracedMethodInterceptor();
        this.requestInjection(methodInterceptor);
        this.bindInterceptor(Matchers.any(), (Matcher)new TracedMethodMatcher(), new MethodInterceptor[]{methodInterceptor});
    }

    @Named(value="Tracer")
    @Provides
    @Singleton
    Tracer getTracer(@Named(value="Tracing.collector.endpoint") String endpoint) {
        AsyncReporter spanReporter = AsyncReporter.create((Sender)OkHttpSender.create((String)endpoint));
        Tracing tracing = Tracing.newBuilder().localServiceName("GJEX").spanReporter((Reporter)spanReporter).build();
        return BraveTracer.create((Tracing)tracing);
    }

    private void closeScopes(Scope scope, Scope parentScope) {
        if (scope != null) {
            scope.close();
        }
        if (parentScope != null && parentScope.span() == GJEXContextKey.activeRootSpan()) {
            parentScope.close();
        }
    }

    private void logErrorToSpan(Span methodInvocationSpan, Exception ex) {
        if (methodInvocationSpan != null) {
            Tags.ERROR.set(methodInvocationSpan, Boolean.valueOf(true));
            methodInvocationSpan.log((Map)ImmutableMap.of((Object)"event", (Object)"error", (Object)"error.object", (Object)ex, (Object)"message", (Object)ex.getMessage()));
        }
    }

    class MethodCallable
    implements Callable<Object> {
        MethodInvocation invocation;

        MethodCallable(MethodInvocation invocation) {
            this.invocation = invocation;
        }

        @Override
        public Object call() throws Exception {
            try {
                return this.invocation.proceed();
            }
            catch (Throwable e) {
                if (Exception.class.isAssignableFrom(e.getClass())) {
                    throw (Exception)e;
                }
                throw new RuntimeException(e);
            }
        }
    }

    class TracedMethodMatcher
    extends AbstractMatcher<Method> {
        TracedMethodMatcher() {
        }

        public boolean matches(Method method) {
            boolean matches = false;
            for (Annotation ann : method.getAnnotations()) {
                Class<? extends Annotation> annotationType = ann.annotationType();
                if (!Traced.class.equals(annotationType)) continue;
                matches = true;
                break;
            }
            return matches;
        }
    }

    class AsyncScopeCloserConsumer
    implements BiConsumer<T, Throwable> {
        Scope scope;
        Scope parentScope;

        AsyncScopeCloserConsumer(Scope scope, Scope parentScope) {
            this.scope = scope;
            this.parentScope = parentScope;
        }

        public void accept(T t, Throwable u) {
            TracingModule.this.closeScopes(this.scope, this.parentScope);
        }
    }

    class TracedMethodInterceptor
    implements MethodInterceptor {
        @Inject
        @Named(value="Tracer")
        Tracer tracer;

        TracedMethodInterceptor() {
        }

        public Object invoke(MethodInvocation invocation) throws Throwable {
            Scope parentScope = null;
            Scope scope = null;
            Span methodInvocationSpan = null;
            Callable<Object> methodCallable = new MethodCallable(invocation);
            if (GJEXContextKey.activeSpan() != null) {
                String methodInvoked = (invocation.getMethod().getDeclaringClass().getSimpleName() + "." + invocation.getMethod().getName()).toLowerCase();
                if (!BindableService.class.isAssignableFrom(invocation.getMethod().getDeclaringClass()) && invocation.getMethod().getAnnotation(Traced.class).withTracingSampler() != TracingSampler.class) {
                    TracingModule.this.warn("TracingSampler declarations are interpreted only for sub-types of gRPC BindableService. TracingSampler declared for : " + methodInvoked + " will not be interpreted/honored");
                }
                TracingSampler tracingSampler = GJEXContextKey.activeTracingSampler();
                tracingSampler.initializeSamplerFor(methodInvoked, invocation.getMethod().getAnnotation(Traced.class).withSamplingRate());
                if (tracingSampler.isSampled(methodInvoked)) {
                    if (this.tracer.scopeManager().active() == null || this.tracer.scopeManager().active().span() != GJEXContextKey.activeSpan()) {
                        parentScope = this.tracer.scopeManager().activate(GJEXContextKey.activeSpan(), true);
                    }
                    methodInvocationSpan = this.tracer.buildSpan(methodInvoked).asChildOf(GJEXContextKey.activeSpan()).start();
                    scope = this.tracer.scopeManager().activate(methodInvocationSpan, true);
                }
                methodCallable = Context.current().withValue(GJEXContextKey.getKey(), methodInvocationSpan).wrap((Callable)methodCallable);
            }
            Object result = null;
            try {
                result = methodCallable.call();
                if (result != null && FutureDecorator.class.isAssignableFrom(result.getClass())) {
                    ((FutureDecorator)result).whenComplete((BiConsumer)new AsyncScopeCloserConsumer(scope, parentScope));
                    return result;
                }
            }
            catch (Exception ex) {
                TaskException tex = null;
                if (TaskException.class.isAssignableFrom(ex.getClass())) {
                    tex = (TaskException)ex;
                    if (tex.isTraced()) {
                        TracingModule.this.logErrorToSpan(methodInvocationSpan, ex);
                        tex.setTraced(false);
                    }
                } else {
                    TracingModule.this.logErrorToSpan(methodInvocationSpan, ex);
                    tex = new TaskException((Throwable)ex, false);
                }
                TracingModule.this.closeScopes(scope, parentScope);
                throw tex;
            }
            TracingModule.this.closeScopes(scope, parentScope);
            return result;
        }
    }
}

