/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.gjex.guice.module;

import com.flipkart.gjex.core.config.FileLocator;
import com.flipkart.gjex.core.config.YamlConfiguration;
import com.google.inject.AbstractModule;
import com.google.inject.binder.LinkedBindingBuilder;
import com.google.inject.name.Names;
import java.io.File;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.net.URL;
import java.util.Iterator;
import java.util.LinkedList;

public class ConfigModule
extends AbstractModule {
    private static final YamlConfiguration GLOBAL_CONFIG = new YamlConfiguration();
    private final YamlConfiguration[] yamlConfigurations;

    public ConfigModule() {
        try {
            URL configUrl = null;
            String configFile = System.getProperty("gjex.configurationFile");
            configUrl = configFile != null ? new File(configFile).toURI().toURL() : ((Object)((Object)this)).getClass().getClassLoader().getResource("packaged/configuration.yml");
            this.yamlConfigurations = new YamlConfiguration[]{new YamlConfiguration(configUrl)};
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public ConfigModule(String configFileName) {
        LinkedList<YamlConfiguration> yamlConfigurationsList = new LinkedList<YamlConfiguration>();
        try {
            for (File configFile : FileLocator.findFiles((String)configFileName)) {
                yamlConfigurationsList.add(new YamlConfiguration(configFile.toURI().toURL()));
            }
            this.yamlConfigurations = yamlConfigurationsList.toArray(new YamlConfiguration[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static YamlConfiguration getGlobalConfig() {
        return GLOBAL_CONFIG;
    }

    protected void configure() {
        this.bindConfigProperties();
        GLOBAL_CONFIG.addAll(this.yamlConfigurations);
    }

    private void bindConfigProperties() {
        for (YamlConfiguration yamlConfiguration : this.yamlConfigurations) {
            Iterator propertyKeys = yamlConfiguration.getKeys();
            while (propertyKeys.hasNext()) {
                String propertyKey = (String)propertyKeys.next();
                Object propertyValue = yamlConfiguration.getProperty(propertyKey);
                LinkedBindingBuilder annotatedWith = this.bind(propertyValue.getClass()).annotatedWith((Annotation)Names.named((String)propertyKey));
                annotatedWith.toInstance(propertyValue);
            }
        }
    }
}

