/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.gjex.web;

import com.fasterxml.jackson.jaxrs.json.JacksonJaxbJsonProvider;
import com.flipkart.gjex.core.logging.Logging;
import com.flipkart.gjex.core.web.ResourceException;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.servlet.Servlet;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.glassfish.jersey.server.ResourceConfig;
import org.glassfish.jersey.servlet.ServletContainer;

@Singleton
public class ResourceRegistrar
implements Logging {
    private final ServletContextHandler context;
    private final JacksonJaxbJsonProvider jaxbProvider;

    @Inject
    public ResourceRegistrar(@Named(value="ApiServletContext") ServletContextHandler context, @Named(value="JSONMarshallingProvider") JacksonJaxbJsonProvider jaxbProvider) {
        this.context = context;
        this.jaxbProvider = jaxbProvider;
    }

    public void registerResources(List<ResourceConfig> resourceConfigs) throws Exception {
        ResourceConfig uniqueResourceConfig = null;
        for (ResourceConfig resourceConfig : resourceConfigs) {
            if (resourceConfig.getApplicationName() != null && resourceConfig.getApplicationName().equalsIgnoreCase("@@GJEXCoreApplication@@")) continue;
            if (uniqueResourceConfig == null) {
                uniqueResourceConfig = resourceConfig;
                continue;
            }
            throw new ResourceException("Multiple ResourceConfig instances configured for this GJEX application. Only one may be configured.");
        }
        uniqueResourceConfig.register((Object)this.jaxbProvider);
        ServletHolder servlet = new ServletHolder((Servlet)new ServletContainer(uniqueResourceConfig));
        this.context.addServlet(servlet, "/*");
    }
}

