/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.gjex.grpc.service;

import com.flipkart.gjex.core.logging.Logging;
import com.flipkart.gjex.core.service.AbstractService;
import com.flipkart.gjex.web.ResourceRegistrar;
import java.util.LinkedList;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.eclipse.jetty.server.Server;
import org.glassfish.jersey.server.ResourceConfig;

@Singleton
@Named(value="APIServer")
public class ApiServer
extends AbstractService
implements Logging {
    private final Server apiServer;
    private final ResourceRegistrar resourceRegistrar;
    private List<ResourceConfig> resourceConfigs = new LinkedList<ResourceConfig>();

    @Inject
    public ApiServer(@Named(value="APIJettyServer") Server apiServer, ResourceRegistrar resourceRegistrar) {
        this.apiServer = apiServer;
        this.resourceRegistrar = resourceRegistrar;
    }

    public void registerResources(List<ResourceConfig> resourceConfigs) {
        this.resourceConfigs.addAll(resourceConfigs);
    }

    public void doStart() throws Exception {
        this.resourceRegistrar.registerResources(this.resourceConfigs);
        this.apiServer.start();
        this.info("API Server started and listening on port : " + this.apiServer.getURI().getPort());
    }

    public void doStop() {
        try {
            this.apiServer.stop();
        }
        catch (Exception e) {
            this.error("Error stopping API server : " + e.getMessage(), e);
        }
    }
}

