/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.gjex.grpc.service;

import com.flipkart.gjex.core.filter.http.AccessLogHttpFilter;
import com.flipkart.gjex.core.filter.http.HttpFilterConfig;
import com.flipkart.gjex.core.filter.http.HttpFilterParams;
import com.flipkart.gjex.core.logging.Logging;
import com.flipkart.gjex.core.service.AbstractService;
import com.flipkart.gjex.web.ResourceRegistrar;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.servlet.FilterHolder;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.glassfish.jersey.server.ResourceConfig;

@Singleton
@Named(value="APIServer")
public class ApiServer
extends AbstractService
implements Logging {
    private final Server apiServer;
    private final ResourceRegistrar resourceRegistrar;
    private final ServletContextHandler context;
    private List<ResourceConfig> resourceConfigs = new ArrayList<ResourceConfig>();

    @Inject
    public ApiServer(@Named(value="APIJettyServer") Server apiServer, @Named(value="ApiServletContext") ServletContextHandler context, ResourceRegistrar resourceRegistrar) {
        this.apiServer = apiServer;
        this.context = context;
        this.resourceRegistrar = resourceRegistrar;
    }

    public void registerResources(List<ResourceConfig> resourceConfigs) {
        this.resourceConfigs.addAll(resourceConfigs);
    }

    public void registerFilters(List<HttpFilterParams> httpFilterParamsList, HttpFilterConfig httpFilterConfig) {
        this.applyHttpFilterConfig(httpFilterConfig);
        for (HttpFilterParams httpFilterParams : httpFilterParamsList) {
            this.context.addFilter(new FilterHolder(httpFilterParams.getFilter()), httpFilterParams.getPathSpec(), EnumSet.of(DispatcherType.REQUEST));
        }
    }

    public void doStart() throws Exception {
        this.resourceRegistrar.registerResources(this.resourceConfigs);
        this.apiServer.start();
        this.info("API Server started and listening on port : " + this.apiServer.getURI().getPort());
    }

    public void doStop() {
        try {
            this.apiServer.stop();
        }
        catch (Exception e) {
            this.error("Error stopping API server : " + e.getMessage(), e);
        }
    }

    private void applyHttpFilterConfig(HttpFilterConfig httpFilterConfig) {
        if (httpFilterConfig.isEnableAccessLogs()) {
            this.context.addFilter(new FilterHolder((Filter)new AccessLogHttpFilter()), "/*", EnumSet.of(DispatcherType.REQUEST));
        }
    }
}

