/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.gjex.grpc.interceptor;

import com.flipkart.gjex.core.tracing.ActiveSpanSource;
import com.flipkart.gjex.core.tracing.OperationNameConstructor;
import com.google.common.collect.ImmutableMap;
import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.ClientInterceptor;
import io.grpc.ClientInterceptors;
import io.grpc.ForwardingClientCall;
import io.grpc.ForwardingClientCallListener;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import io.grpc.Status;
import io.opentracing.Span;
import io.opentracing.Tracer;
import io.opentracing.propagation.Format;
import io.opentracing.propagation.TextMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;

public class ClientTracingInterceptor
implements ClientInterceptor {
    private final Tracer tracer;
    private final OperationNameConstructor operationNameConstructor;
    private final ActiveSpanSource activeSpanSource;

    public ClientTracingInterceptor(Tracer tracer) {
        this.tracer = tracer;
        this.operationNameConstructor = OperationNameConstructor.DEFAULT;
        this.activeSpanSource = ActiveSpanSource.GRPC_CONTEXT;
    }

    public Channel intercept(Channel channel) {
        return ClientInterceptors.intercept((Channel)channel, (ClientInterceptor[])new ClientInterceptor[]{this});
    }

    public <ReqT, RespT> ClientCall<ReqT, RespT> interceptCall(MethodDescriptor<ReqT, RespT> method, CallOptions callOptions, Channel next) {
        Span activeSpan = this.activeSpanSource.getActiveSpan();
        if (activeSpan != null) {
            String operationName = this.operationNameConstructor.constructOperationName(method);
            final Span span = this.createSpanFromParent(activeSpan, operationName);
            if (callOptions.getDeadline() == null) {
                span.setTag("grpc.deadline_millis", "null");
            } else {
                span.setTag("grpc.deadline_millis", (Number)callOptions.getDeadline().timeRemaining(TimeUnit.MILLISECONDS));
            }
            return new ForwardingClientCall.SimpleForwardingClientCall<ReqT, RespT>(next.newCall(method, callOptions)){

                public void start(ClientCall.Listener<RespT> responseListener, final Metadata headers) {
                    ClientTracingInterceptor.this.tracer.inject(span.context(), Format.Builtin.HTTP_HEADERS, (Object)new TextMap(){

                        public void put(String key, String value) {
                            Metadata.Key headerKey = Metadata.Key.of((String)key, (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER);
                            headers.put(headerKey, (Object)value);
                        }

                        public Iterator<Map.Entry<String, String>> iterator() {
                            throw new UnsupportedOperationException("TextMapInjectAdapter should only be used with Tracer.inject()");
                        }
                    });
                    ForwardingClientCallListener.SimpleForwardingClientCallListener tracingResponseListener = new ForwardingClientCallListener.SimpleForwardingClientCallListener<RespT>(responseListener){

                        public void onClose(Status status, Metadata trailers) {
                            span.finish();
                            this.delegate().onClose(status, trailers);
                        }
                    };
                    this.delegate().start((ClientCall.Listener)tracingResponseListener, headers);
                }

                public void cancel(@Nullable String message, @Nullable Throwable cause) {
                    String errorMessage = message == null ? "Error" : message;
                    if (cause == null) {
                        span.log(errorMessage);
                    } else {
                        span.log((Map)ImmutableMap.of((Object)errorMessage, (Object)cause.getMessage()));
                    }
                    this.delegate().cancel(message, cause);
                }
            };
        }
        return new ForwardingClientCall.SimpleForwardingClientCall<ReqT, RespT>(next.newCall(method, callOptions)){};
    }

    private Span createSpanFromParent(Span parentSpan, String operationName) {
        if (parentSpan == null) {
            return this.tracer.buildSpan(operationName).start();
        }
        return this.tracer.buildSpan(operationName).asChildOf(parentSpan).start();
    }
}

