/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.gjex.http.interceptor;

import com.flipkart.gjex.core.filter.RequestParams;
import com.flipkart.gjex.core.filter.http.HttpFilter;
import com.flipkart.gjex.core.filter.http.HttpFilterParams;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.http.pathmap.ServletPathSpec;

@Singleton
@Named(value="HttpFilterInterceptor")
public class HttpFilterInterceptor
implements Filter {
    private Map<String, ServletPathFiltersHolder> filtersMap = new HashMap<String, ServletPathFiltersHolder>();
    private Map<ServletPathSpec, List<HttpFilter>> pathSpecToFilterMap = new HashMap<ServletPathSpec, List<HttpFilter>>();

    public void registerFilters(List<HttpFilterParams> httpFilterParamsList) {
        for (HttpFilterParams httpFilterParams : httpFilterParamsList) {
            if (!this.filtersMap.containsKey(httpFilterParams.getPathSpec())) {
                ServletPathSpec spec = new ServletPathSpec(httpFilterParams.getPathSpec());
                this.filtersMap.put(httpFilterParams.getPathSpec(), new ServletPathFiltersHolder(spec, new ArrayList<HttpFilter>()));
            }
            this.filtersMap.get((Object)httpFilterParams.getPathSpec()).filters.add(httpFilterParams.getFilter());
        }
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        for (ServletPathFiltersHolder servletPathFiltersHolder : this.filtersMap.values()) {
            this.pathSpecToFilterMap.computeIfAbsent(servletPathFiltersHolder.spec, k -> new ArrayList()).addAll(servletPathFiltersHolder.filters);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        List<Object> filters = new ArrayList();
        RequestParams.RequestParamsBuilder requestParamsBuilder = RequestParams.builder();
        try {
            if (request instanceof HttpServletRequest) {
                HttpServletRequest httpServletRequest = (HttpServletRequest)request;
                filters = this.getMatchingFilters(httpServletRequest.getRequestURI());
                HashSet headersNames = new HashSet(Collections.list(httpServletRequest.getHeaderNames()));
                requestParamsBuilder.metadata(headersNames);
                requestParamsBuilder.clientIp(this.getClientIp(request));
                requestParamsBuilder.resourcePath(httpServletRequest.getRequestURI());
            }
            RequestParams requestParams = requestParamsBuilder.build();
            filters.forEach(filter -> filter.doProcessRequest((Object)request, requestParams));
            chain.doFilter(request, response);
        }
        finally {
            if (response instanceof HttpServletResponse) {
                HttpServletResponse httpServletResponse = (HttpServletResponse)response;
                filters.forEach(filter -> filter.doProcessResponseHeaders(new HashSet(httpServletResponse.getHeaderNames())));
            }
            filters.forEach(filter -> filter.doProcessResponse((Object)response));
        }
    }

    private String getClientIp(ServletRequest request) {
        String remoteAddr = request.getRemoteAddr();
        String xForwardedFor = ((HttpServletRequest)request).getHeader("X-Forwarded-For");
        if (xForwardedFor != null) {
            remoteAddr = xForwardedFor.split(",")[0];
        }
        return remoteAddr;
    }

    private List<HttpFilter> getMatchingFilters(String path) {
        return this.pathSpecToFilterMap.keySet().stream().filter(key -> key.matches(path)).map(k -> this.pathSpecToFilterMap.get(k)).flatMap(Collection::stream).map(filter -> filter.getInstance()).collect(Collectors.toList());
    }

    public void destroy() {
    }

    private static class ServletPathFiltersHolder {
        ServletPathSpec spec;
        List<HttpFilter> filters;

        public ServletPathFiltersHolder(ServletPathSpec spec, List<HttpFilter> filters) {
            this.spec = spec;
            this.filters = filters;
        }
    }
}

