/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.gjex.http.interceptor;

import com.flipkart.gjex.core.filter.RequestParams;
import com.flipkart.gjex.core.filter.http.HttpFilter;
import com.flipkart.gjex.core.filter.http.HttpFilterParams;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.http.pathmap.ServletPathSpec;

@Singleton
@Named(value="HttpFilterInterceptor")
public class HttpFilterInterceptor
implements Filter {
    private final List<ServletPathFiltersHolder> pathFiltersHolders = new ArrayList<ServletPathFiltersHolder>();

    public void registerFilters(List<HttpFilterParams> httpFilterParamsList) {
        for (HttpFilterParams p : httpFilterParamsList) {
            ServletPathSpec spec = new ServletPathSpec(p.getPathSpec());
            this.pathFiltersHolders.add(new ServletPathFiltersHolder(spec, p.getFilter()));
        }
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        Map<String, String> headers;
        List<Object> filters = new ArrayList();
        RequestParams.RequestParamsBuilder requestParamsBuilder = RequestParams.builder();
        try {
            if (request instanceof HttpServletRequest) {
                HttpServletRequest httpServletRequest = (HttpServletRequest)request;
                filters = this.getMatchingFilters(httpServletRequest.getRequestURI());
                headers = Collections.list(httpServletRequest.getHeaderNames()).stream().collect(Collectors.toMap(h -> h, arg_0 -> ((HttpServletRequest)httpServletRequest).getHeader(arg_0)));
                requestParamsBuilder.metadata(headers);
                requestParamsBuilder.clientIp(HttpFilterInterceptor.getClientIp(request));
                requestParamsBuilder.method(httpServletRequest.getMethod());
                requestParamsBuilder.resourcePath(HttpFilterInterceptor.getFullURL(httpServletRequest));
            }
            RequestParams requestParams = requestParamsBuilder.build();
            filters.forEach(filter -> filter.doProcessRequest((Object)request, requestParams));
            chain.doFilter(request, response);
        }
        finally {
            if (response instanceof HttpServletResponse) {
                HttpServletResponse httpServletResponse = (HttpServletResponse)response;
                headers = httpServletResponse.getHeaderNames().stream().collect(Collectors.toMap(h -> h, arg_0 -> ((HttpServletResponse)httpServletResponse).getHeader(arg_0)));
                filters.forEach(filter -> filter.doProcessResponseHeaders((Object)headers));
            }
            filters.forEach(filter -> filter.doProcessResponse((Object)response));
        }
    }

    protected static String getFullURL(HttpServletRequest request) {
        StringBuilder requestURL = new StringBuilder(request.getRequestURL().toString());
        String queryString = request.getQueryString();
        if (queryString == null) {
            return requestURL.toString();
        }
        return requestURL.append('?').append(queryString).toString();
    }

    protected static String getClientIp(ServletRequest request) {
        String remoteAddr = request.getRemoteAddr();
        String xForwardedFor = ((HttpServletRequest)request).getHeader("X-Forwarded-For");
        if (xForwardedFor != null) {
            remoteAddr = xForwardedFor.split(",")[0];
        }
        return remoteAddr;
    }

    protected List<HttpFilter> getMatchingFilters(String path) {
        return this.pathFiltersHolders.stream().filter(t -> t.spec.matches(path)).map(t -> t.filter).map(HttpFilter::getInstance).collect(Collectors.toList());
    }

    public void destroy() {
    }

    private static class ServletPathFiltersHolder {
        ServletPathSpec spec;
        HttpFilter filter;

        public ServletPathFiltersHolder(ServletPathSpec spec, HttpFilter filter) {
            this.spec = spec;
            this.filter = filter;
        }
    }
}

