/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.gjex.http.interceptor;

import com.flipkart.gjex.core.filter.RequestParams;
import com.flipkart.gjex.core.filter.http.HttpFilter;
import com.flipkart.gjex.core.filter.http.HttpFilterParams;
import com.flipkart.gjex.http.interceptor.FilterServletResponseWrapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.http.pathmap.ServletPathSpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@Named(value="HttpFilterInterceptor")
public class HttpFilterInterceptor
implements Filter {
    private static final Logger logger = LoggerFactory.getLogger(HttpFilterInterceptor.class);
    private final List<ServletPathFiltersHolder> pathFiltersHolders = new ArrayList<ServletPathFiltersHolder>();

    public void registerFilters(List<HttpFilterParams> httpFilterParamsList) {
        for (HttpFilterParams p : httpFilterParamsList) {
            ServletPathSpec spec = new ServletPathSpec(p.getPathSpec());
            this.pathFiltersHolders.add(new ServletPathFiltersHolder(spec, p.getFilter()));
        }
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        RequestParams.RequestParamsBuilder requestParamsBuilder = RequestParams.builder();
        if (request instanceof HttpServletRequest && response instanceof HttpServletResponse) {
            HttpServletRequest httpServletRequest = (HttpServletRequest)request;
            HttpServletResponse httpServletResponse = (HttpServletResponse)response;
            List<HttpFilter> filters = this.getMatchingFilters(httpServletRequest.getRequestURI());
            Map<String, String> headers = Collections.list(httpServletRequest.getHeaderNames()).stream().collect(Collectors.toMap(h -> h, arg_0 -> ((HttpServletRequest)httpServletRequest).getHeader(arg_0)));
            requestParamsBuilder.metadata(headers);
            requestParamsBuilder.clientIp(HttpFilterInterceptor.getClientIp(request));
            requestParamsBuilder.method(httpServletRequest.getMethod());
            requestParamsBuilder.resourcePath(HttpFilterInterceptor.getFullURL(httpServletRequest));
            RequestParams requestParams = requestParamsBuilder.build();
            FilterServletResponseWrapper responseWrapper = new FilterServletResponseWrapper(httpServletResponse);
            try {
                filters.forEach(filter -> filter.doProcessRequest((Object)request, requestParams));
                chain.doFilter(request, (ServletResponse)responseWrapper);
                Map<String, String> responseHeaders = responseWrapper.getHeaderNames().stream().collect(Collectors.toMap(h -> h, arg_0 -> ((HttpServletResponse)httpServletResponse).getHeader(arg_0)));
                filters.forEach(filter -> filter.doProcessResponseHeaders((Object)responseHeaders));
                responseHeaders.forEach((arg_0, arg_1) -> ((FilterServletResponseWrapper)responseWrapper).setHeader(arg_0, arg_1));
            }
            finally {
                filters.forEach(filter -> filter.doProcessResponse((Object)responseWrapper));
                response.getOutputStream().write(responseWrapper.getWrapperBytes());
            }
        } else {
            chain.doFilter(request, response);
            logger.warn("Unsupported request type {}, pass the request and response as is.", request.getClass());
        }
    }

    protected static String getFullURL(HttpServletRequest request) {
        StringBuilder requestURL = new StringBuilder(request.getRequestURL().toString());
        String queryString = request.getQueryString();
        if (queryString == null) {
            return requestURL.toString();
        }
        return requestURL.append('?').append(queryString).toString();
    }

    protected static String getClientIp(ServletRequest request) {
        String remoteAddr = request.getRemoteAddr();
        String xForwardedFor = ((HttpServletRequest)request).getHeader("X-Forwarded-For");
        if (xForwardedFor != null) {
            remoteAddr = xForwardedFor.split(",")[0];
        }
        return remoteAddr;
    }

    protected List<HttpFilter> getMatchingFilters(String path) {
        return this.pathFiltersHolders.stream().filter(t -> t.spec.matches(path)).map(t -> t.filter).map(HttpFilter::getInstance).collect(Collectors.toList());
    }

    public void destroy() {
    }

    private static class ServletPathFiltersHolder {
        ServletPathSpec spec;
        HttpFilter filter;

        public ServletPathFiltersHolder(ServletPathSpec spec, HttpFilter filter) {
            this.spec = spec;
            this.filter = filter;
        }
    }
}

