/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.hydra.composer.utils;

import com.flipkart.hydra.composer.exception.ComposerEvaluationException;
import com.flipkart.hydra.expression.Expression;
import com.flipkart.hydra.expression.exception.ExpressionEvaluationException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CompositionEvaluator {
    public static Object evaluate(Object context, Map<String, Object> values) throws ComposerEvaluationException {
        if (context instanceof Expression) {
            try {
                return ((Expression)context).calculate(values);
            }
            catch (ExpressionEvaluationException e) {
                throw new ComposerEvaluationException("Unable to evaluate composer.", e);
            }
        }
        if (context instanceof Map) {
            Map mapContext = context;
            HashMap<Object, Object> newMapContext = new HashMap<Object, Object>();
            for (Object key : mapContext.keySet()) {
                newMapContext.put(CompositionEvaluator.evaluate(key, values), CompositionEvaluator.evaluate(mapContext.get(key), values));
            }
            context = newMapContext;
        } else if (context instanceof List) {
            List listContext = (List)((Object)context);
            ArrayList<Object> newListContext = new ArrayList<Object>();
            for (Object value : listContext) {
                newListContext.add(CompositionEvaluator.evaluate(value, values));
            }
            context = newListContext;
        }
        return context;
    }
}

