/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.hydra.dispatcher;

import com.flipkart.hydra.composer.Composer;
import com.flipkart.hydra.composer.DefaultComposer;
import com.flipkart.hydra.composer.exception.ComposerEvaluationException;
import com.flipkart.hydra.composer.exception.ComposerInstantiationException;
import com.flipkart.hydra.dispatcher.Dispatcher;
import com.flipkart.hydra.dispatcher.exception.DispatchFailedException;
import com.flipkart.hydra.task.Task;
import com.flipkart.hydra.task.exception.BadCallableException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public class DefaultDispatcher
implements Dispatcher {
    private final ExecutorService executor;
    private final ExecutorCompletionService<Object> completionService;

    public DefaultDispatcher() {
        this(Executors.newCachedThreadPool());
    }

    public DefaultDispatcher(ExecutorService executor) {
        this.executor = executor;
        this.completionService = new ExecutorCompletionService(executor);
    }

    @Override
    public Object execute(Map<String, Object> params, Map<String, Task> tasks, Object context) throws DispatchFailedException, ComposerEvaluationException {
        return this.execute(params, tasks, context, false);
    }

    @Override
    public Object execute(Map<String, Object> params, Map<String, Task> tasks, Object context, boolean isAlreadyParsed) throws DispatchFailedException, ComposerEvaluationException {
        try {
            DefaultComposer defaultComposer = new DefaultComposer(context, isAlreadyParsed);
            return this.execute(params, tasks, (Composer)defaultComposer);
        }
        catch (ComposerInstantiationException e) {
            throw new DispatchFailedException("Unable to create composer.", e);
        }
    }

    @Override
    public Object execute(Map<String, Object> params, Map<String, Task> tasks, Composer composer) throws DispatchFailedException, ComposerEvaluationException {
        Map<String, Object> responses = this.dispatchAndCollect(params, tasks);
        List dependencies = composer.getDependencies();
        Map<String, Object> collectedDependencies = this.collectDependencies(responses, dependencies);
        return composer.compose(collectedDependencies);
    }

    @Override
    public void shutdown() {
        this.executor.shutdown();
    }

    private Map<String, Object> dispatchAndCollect(Map<String, Object> params, Map<String, Task> tasks) throws DispatchFailedException, ComposerEvaluationException {
        HashMap<String, Object> responses = new HashMap<String, Object>();
        ArrayList<String> dispatched = new ArrayList<String>();
        HashMap<Future<Object>, String> futures = new HashMap<Future<Object>, String>();
        responses.putAll(params);
        for (int remaining = tasks.size(); remaining > 0; --remaining) {
            for (String key : tasks.keySet()) {
                List dependencies;
                Map<String, Object> collectedDependencies;
                Task task = tasks.get(key);
                if (responses.containsKey(key) || dispatched.contains(key) || (collectedDependencies = this.collectDependencies(responses, dependencies = task.getDependencies())).size() != dependencies.size()) continue;
                Future<Object> future = this.dispatchTask(task, collectedDependencies);
                dispatched.add(key);
                futures.put(future, key);
            }
            if (dispatched.isEmpty()) {
                throw new DispatchFailedException("No possible resolution of dependencies found.");
            }
            try {
                String key;
                Future<Object> future = this.completionService.take();
                key = (String)futures.get(future);
                responses.put(key, future.get());
                dispatched.remove(key);
                continue;
            }
            catch (InterruptedException | ExecutionException e) {
                throw new DispatchFailedException("Unable to fetch all required data", e);
            }
        }
        return responses;
    }

    private Map<String, Object> collectDependencies(Map<String, Object> responses, List<String> dependencies) {
        HashMap<String, Object> collectedDependencies = new HashMap<String, Object>();
        for (String dependency : dependencies) {
            if (!responses.containsKey(dependency)) continue;
            collectedDependencies.put(dependency, responses.get(dependency));
        }
        return collectedDependencies;
    }

    private Future<Object> dispatchTask(Task task, Map<String, Object> responses) throws DispatchFailedException {
        try {
            Callable callable = task.getCallable(responses);
            return this.completionService.submit(callable);
        }
        catch (BadCallableException e) {
            throw new DispatchFailedException("Failed to dispatch task", e);
        }
    }
}

