/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.hydra.expression.utils;

import com.flipkart.hydra.expression.exception.ExpressionEvaluationException;
import com.flipkart.hydra.expression.utils.Functions;
import com.google.common.base.Joiner;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class ExpressionEvaluator {
    public static Object evaluate(List operands, Map<String, Object> values) throws ExpressionEvaluationException {
        Object response = null;
        Object firstOperand = operands.get(0);
        if (firstOperand instanceof String && ((String)firstOperand).endsWith("()")) {
            ArrayList arguments = operands.size() > 1 ? operands.subList(1, operands.size()) : new ArrayList();
            return ExpressionEvaluator.evaluateFunction((String)firstOperand, arguments, values);
        }
        Iterator iterator = operands.iterator();
        while (iterator.hasNext()) {
            Object operand;
            Object calculatedOperand = operand = iterator.next();
            if (operand instanceof List) {
                calculatedOperand = ExpressionEvaluator.evaluate((List)operand, values);
            }
            if ((response = ExpressionEvaluator.calculateOperandResponse(calculatedOperand, values, response)) != null) continue;
            break;
        }
        return response;
    }

    private static Object evaluateFunction(String fn, List args, Map<String, Object> values) throws ExpressionEvaluationException {
        try {
            String function = fn.substring(0, fn.length() - 2);
            ArrayList<Object> computedArgs = new ArrayList<Object>();
            for (Object arg : args) {
                computedArgs.add(ExpressionEvaluator.evaluate((List)arg, values));
            }
            return ExpressionEvaluator.findFunction(function, computedArgs).invoke(null, computedArgs.toArray());
        }
        catch (Throwable e) {
            throw new ExpressionEvaluationException("Unable to evaluate function - " + fn, e);
        }
    }

    private static Method findFunction(String name, List args) throws ExpressionEvaluationException {
        Method[] methods;
        for (Method method : methods = Functions.class.getDeclaredMethods()) {
            boolean isVarArgs = method.isVarArgs();
            if (!method.getName().equals(name) || method.getParameterCount() != args.size() && (!isVarArgs || method.getParameterCount() >= args.size())) continue;
            boolean match = true;
            Class<?>[] types = method.getParameterTypes();
            for (int i = 0; i < args.size(); ++i) {
                int typeIndex;
                int n = typeIndex = i < types.length ? i : types.length - 1;
                if (types[typeIndex].isInstance(args.get(i))) continue;
                match = false;
                break;
            }
            if (!match) continue;
            return method;
        }
        Object[] typeNames = new String[args.size()];
        for (int i = 0; i < args.size(); ++i) {
            Class<?> type = args.get(i).getClass();
            typeNames[i] = type.getSimpleName();
            if (!typeNames[i].equals("")) continue;
            typeNames[i] = type.getSuperclass().getSimpleName();
        }
        throw new ExpressionEvaluationException("No such function found :: " + name + "(" + Joiner.on((String)", ").join(typeNames) + ")");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Object calculateOperandResponse(Object operand, Map<String, Object> values, Object response) throws ExpressionEvaluationException {
        if (response == null) {
            if (!(operand instanceof String)) return operand;
            String stringOperand = (String)operand;
            if (!stringOperand.startsWith("$")) return operand;
            String variable = stringOperand.substring(1);
            return values.get(variable);
        }
        if (response instanceof List) {
            if (!(operand instanceof Integer)) throw new ExpressionEvaluationException("Invalid operand - " + operand);
            return ((List)response).get((Integer)operand);
        }
        if (response.getClass().isArray()) {
            if (!(operand instanceof Integer)) throw new ExpressionEvaluationException("Invalid operand - " + operand);
            return ((Object[])response)[(Integer)operand];
        }
        if (response instanceof Map) {
            Object possibleResponse = ((Map)response).get(operand);
            return possibleResponse != null ? possibleResponse : ((Map)response).get(String.valueOf(operand));
        }
        if (response instanceof String) {
            if (!(operand instanceof Integer)) throw new ExpressionEvaluationException("Invalid operand - " + operand);
            return Character.valueOf(((String)response).charAt((Integer)operand));
        }
        if (response instanceof Integer) throw new ExpressionEvaluationException("Invalid operand - " + operand);
        if (response instanceof Double) {
            throw new ExpressionEvaluationException("Invalid operand - " + operand);
        }
        if (operand instanceof String) return ExpressionEvaluator.getFieldValue((String)operand, response);
        throw new ExpressionEvaluationException("Invalid operand - " + operand);
    }

    private static Object getFieldValue(String operand, Object response) throws ExpressionEvaluationException {
        for (Class<?> klass = response.getClass(); klass != null && klass != Object.class; klass = klass.getSuperclass()) {
            Field[] declaredFields;
            for (Field field : declaredFields = klass.getDeclaredFields()) {
                if (!field.getName().equals(operand)) continue;
                try {
                    Field declaredField = klass.getDeclaredField(operand);
                    declaredField.setAccessible(true);
                    return declaredField.get(response);
                }
                catch (IllegalAccessException | NoSuchFieldException reflectiveOperationException) {
                    // empty catch block
                }
            }
        }
        throw new ExpressionEvaluationException("No field named '" + operand + "' exists for " + response.getClass().getName());
    }
}

