/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.hydra.expression.utils;

import com.flipkart.hydra.expression.exception.ExpressionParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

public class ExpressionParser {
    public static List parse(final String expression) throws ExpressionParseException {
        if (expression.startsWith("$")) {
            return ExpressionParser.parseExpression(expression);
        }
        return new ArrayList<Object>(){
            {
                this.add(ExpressionParser.getValue(expression));
            }
        };
    }

    private static List parseExpression(String expression) throws ExpressionParseException {
        ArrayList<Object> operands = new ArrayList<Object>();
        String token = "$";
        char c = '~';
        for (int i = 1; i < expression.length(); ++i) {
            c = expression.charAt(i);
            if (ExpressionParser.isAllowedChar(c)) {
                token = token + c;
                continue;
            }
            if (c == '[' || c == '(' || c == '.') {
                int inverseBracket;
                if (("".equals(token) || "$".equals(token)) && c != '(') {
                    throw new ExpressionParseException(expression, "a-z A-Z 0-9 _ . [ (", c, i + 1);
                }
                if (token != "$") {
                    operands.add(token);
                }
                token = "";
                int brackets = 0;
                if (c != '[' && c != 40) continue;
                char originalBracket = c;
                int n = inverseBracket = c == '[' ? 93 : 41;
                while (i < expression.length()) {
                    c = expression.charAt(i);
                    switch (c) {
                        case '(': 
                        case '[': {
                            if (brackets != 0) {
                                token = token + c;
                            }
                            brackets += c == originalBracket ? 1 : 0;
                            break;
                        }
                        case ')': 
                        case ']': {
                            if ((brackets -= c == inverseBracket ? 1 : 0) == 0) break;
                            token = token + c;
                            break;
                        }
                        default: {
                            token = token + c;
                        }
                    }
                    if (brackets == 0) {
                        switch (originalBracket) {
                            case '[': {
                                operands.add(ExpressionParser.parseSubExpression(expression, token, i + 1));
                                break;
                            }
                            case '(': {
                                operands.add(ExpressionParser.parseFunction(expression, token, i + 1));
                            }
                        }
                        token = "";
                        break;
                    }
                    ++i;
                }
                if (++i >= expression.length() || (c = expression.charAt(i)) == 46) continue;
                throw new ExpressionParseException(expression, ".", c, i + 1);
            }
            throw new ExpressionParseException(expression, "a-z A-Z 0-9 _ . [ (", c, i + 1);
        }
        if ("".equals(token) || "$".equals(token)) {
            if (c != ']' && c != ')') {
                throw new ExpressionParseException(expression, "a-z A-Z 0-9 _", "EOF", expression.length());
            }
        } else {
            operands.add(token);
        }
        return operands;
    }

    private static List<Object> parseFunction(String expression, String subExpression, int position) throws ExpressionParseException {
        try {
            ArrayList<Object> operands = new ArrayList<Object>();
            int bracketsA = 0;
            int bracketsB = 0;
            String token = "";
            for (int i = 0; i <= subExpression.length(); ++i) {
                char c = i == subExpression.length() ? (char)',' : (char)subExpression.charAt(i);
                switch (c) {
                    case '[': {
                        ++bracketsA;
                        break;
                    }
                    case '(': {
                        ++bracketsB;
                        break;
                    }
                    case ']': {
                        --bracketsA;
                        break;
                    }
                    case ')': {
                        --bracketsB;
                    }
                }
                if (c == ',') {
                    if (bracketsA == 0 && bracketsB == 0) {
                        if (operands.size() == 0) {
                            ExpressionParser.verifyFunctionName(token);
                            operands.add(token + "()");
                        } else {
                            operands.add(ExpressionParser.parseSubExpression(subExpression, token, i + 1));
                        }
                        token = "";
                        continue;
                    }
                    token = token + c;
                    continue;
                }
                token = token + c;
            }
            return operands;
        }
        catch (ExpressionParseException e) {
            throw new ExpressionParseException(expression, subExpression, position);
        }
    }

    private static void verifyFunctionName(String subExpression) throws ExpressionParseException {
        if (!Pattern.matches("[a-zA-Z][a-zA-Z0-9]*", subExpression)) {
            throw new ExpressionParseException("Invalid function name - " + subExpression);
        }
    }

    private static List parseSubExpression(String expression, String subExpression, int position) throws ExpressionParseException {
        try {
            return ExpressionParser.parse(subExpression);
        }
        catch (ExpressionParseException e) {
            throw new ExpressionParseException(expression, subExpression, position);
        }
    }

    private static Object getValue(String expression) {
        try {
            return Integer.parseInt(expression);
        }
        catch (NumberFormatException e1) {
            try {
                return Double.parseDouble(expression);
            }
            catch (NumberFormatException e2) {
                return expression;
            }
        }
    }

    private static boolean isAllowedChar(char c) {
        if (c >= 'a' && c <= 'z') {
            return true;
        }
        if (c >= 'A' && c <= 'Z') {
            return true;
        }
        if (c >= '0' && c <= '9') {
            return true;
        }
        return c == '_';
    }
}

