/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.hydra.task;

import com.flipkart.hydra.composer.Composer;
import com.flipkart.hydra.composer.DefaultComposer;
import com.flipkart.hydra.composer.exception.ComposerEvaluationException;
import com.flipkart.hydra.composer.exception.ComposerInstantiationException;
import com.flipkart.hydra.task.Task;
import com.flipkart.hydra.task.exception.BadCallableException;
import com.flipkart.hydra.task.helpers.ReflectionHelper;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;

public class DefaultTask
implements Task {
    protected final Class<? extends Callable> callableClass;
    protected final Composer composer;

    public DefaultTask(Class<? extends Callable> callableClass, Composer composer) {
        this.callableClass = callableClass;
        this.composer = composer;
    }

    public DefaultTask(Class<? extends Callable> callableClass, Object context) throws ComposerInstantiationException {
        this(callableClass, context, false);
    }

    public DefaultTask(Class<? extends Callable> callableClass, Object context, boolean isAlreadyParsed) throws ComposerInstantiationException {
        this.callableClass = callableClass;
        this.composer = new DefaultComposer(context, isAlreadyParsed);
    }

    @Override
    public Callable<Object> getCallable(Map<String, Object> values) throws BadCallableException {
        try {
            Constructor<? extends Callable> constructor = ReflectionHelper.getFirstSingleArgConstructor(this.callableClass);
            return constructor.newInstance(this.composer.compose(values));
        }
        catch (ComposerEvaluationException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new BadCallableException("Unable to execute callable", e);
        }
    }

    @Override
    public List<String> getDependencies() {
        return this.composer.getDependencies();
    }
}

