/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.hydra.task.entities;

import com.flipkart.hydra.composer.Composer;
import com.flipkart.hydra.composer.exception.ComposerEvaluationException;
import com.flipkart.hydra.task.exception.BadCallableException;
import com.flipkart.hydra.task.helpers.ReflectionHelper;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;

public class WrapperCallable
implements Callable<Object> {
    protected final ListeningExecutorService executorService;
    protected final Constructor<? extends Callable> constructor;
    protected final Object loopVar;
    protected final Composer composer;
    protected final Map<String, Object> values;

    public WrapperCallable(ExecutorService executor, Class<? extends Callable> callableClass, Composer loopComposer, Composer composer, Map<String, Object> values) throws NoSuchMethodException, ComposerEvaluationException {
        this(MoreExecutors.listeningDecorator((ExecutorService)executor), ReflectionHelper.getFirstSingleArgConstructor(callableClass), loopComposer.compose(values), composer, values);
    }

    public WrapperCallable(ListeningExecutorService executorService, Constructor<? extends Callable> constructor, Object loopVar, Composer composer, Map<String, Object> values) {
        this.executorService = executorService;
        this.constructor = constructor;
        this.loopVar = loopVar;
        this.composer = composer;
        this.values = values;
    }

    @Override
    public Object call() throws Exception {
        try {
            if (this.loopVar instanceof Map) {
                return this.getResponsesForMap();
            }
            if (this.loopVar instanceof List) {
                return this.getResponsesForList();
            }
            if (this.loopVar.getClass().isArray()) {
                return this.getResponsesForArray();
            }
        }
        catch (Throwable e) {
            throw new BadCallableException("Unable to execute callable", e);
        }
        throw new BadCallableException("Loop Variable is not iterable");
    }

    protected Object getResponsesForMap() throws Exception {
        Map iterable = (Map)this.loopVar;
        HashMap futureMap = new HashMap();
        for (Object i : iterable.keySet()) {
            ListenableFuture<Object> future = this.getFuture(i, iterable.get(i));
            futureMap.put(i, future);
        }
        ListenableFuture compositeFuture = Futures.allAsList(futureMap.values());
        compositeFuture.get();
        HashMap responsesMap = new HashMap();
        for (Object i : iterable.keySet()) {
            responsesMap.put(i, ((ListenableFuture)futureMap.get(i)).get());
        }
        return responsesMap;
    }

    protected Object getResponsesForList() throws Exception {
        List list = (List)this.loopVar;
        HashMap<Integer, ListenableFuture<Object>> futureMap = new HashMap<Integer, ListenableFuture<Object>>();
        for (int i = 0; i < list.size(); ++i) {
            ListenableFuture<Object> future = this.getFuture(i, list.get(i));
            futureMap.put(i, future);
        }
        ListenableFuture compositeFuture = Futures.allAsList(futureMap.values());
        compositeFuture.get();
        ArrayList<Object> responsesList = new ArrayList<Object>();
        for (int i = 0; i < list.size(); ++i) {
            responsesList.add(((ListenableFuture)futureMap.get(i)).get());
        }
        return responsesList;
    }

    protected Object getResponsesForArray() throws Exception {
        Object[] arr = (Object[])this.loopVar;
        HashMap<Integer, ListenableFuture<Object>> futureMap = new HashMap<Integer, ListenableFuture<Object>>();
        for (int i = 0; i < arr.length; ++i) {
            ListenableFuture<Object> future = this.getFuture(i, arr[i]);
            futureMap.put(i, future);
        }
        ListenableFuture compositeFuture = Futures.allAsList(futureMap.values());
        compositeFuture.get();
        Object[] responsesArray = new Object[arr.length];
        for (int i = 0; i < arr.length; ++i) {
            responsesArray[i] = ((ListenableFuture)futureMap.get(i)).get();
        }
        return responsesArray;
    }

    protected ListenableFuture<Object> getFuture(Object key, Object value) throws Exception {
        HashMap<String, Object> request = new HashMap<String, Object>(this.values);
        request.put("__key", key);
        request.put("__value", value);
        Callable callable = this.constructor.newInstance(this.composer.compose(request));
        return this.executorService.submit(callable);
    }
}

