/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.iris.bufferqueue.mmapped;

import com.flipkart.iris.bufferqueue.mmapped.MappedBufferQueue;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteOrder;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MappedBufferQueueFactory {
    private static final Logger LOG = LoggerFactory.getLogger(MappedBufferQueueFactory.class);
    public static final String FILE_EXTENSION = ".mbq";
    public static final String FILENAME_FORMAT_STRING = "%s-%d-%d.mbq";
    public static final int PAGE_SIZE = 4096;

    public static MappedBufferQueue getInstance(File file) throws FileNotFoundException, IOException {
        if (!file.exists()) {
            throw new FileNotFoundException("File " + file + " does not exist!");
        }
        MappedByteBuffer fileBuf = MappedBufferQueueFactory.mapFile(file, file.length());
        return new MappedBufferQueue(file, fileBuf);
    }

    public static void format(File file, int maxDataLength, long numMessages) throws IllegalStateException, IOException {
        if (file.exists()) {
            throw new IllegalStateException("File " + file + " already exists!");
        }
        long fileSize = MappedBufferQueue.fileSize(maxDataLength, numMessages);
        MappedBufferQueueFactory.touchFile(file, fileSize);
        MappedByteBuffer fileBuf = MappedBufferQueueFactory.mapFile(file, fileSize);
        MappedBufferQueue.format(fileBuf, maxDataLength);
    }

    public static MappedBufferQueue getInstance(File directory, String name, int maxDataLength, long numMessages) throws IOException {
        File file = new File(directory, String.format(FILENAME_FORMAT_STRING, name, maxDataLength, numMessages));
        if (!file.exists()) {
            MappedBufferQueueFactory.format(file, maxDataLength, numMessages);
        }
        return MappedBufferQueueFactory.getInstance(file);
    }

    public static List<MappedBufferQueue> getInstances(File directory) throws IOException {
        File[] files = directory.listFiles();
        Preconditions.checkNotNull((Object)files, (String)"Error fetching list of files in given directory", (Object[])new Object[]{directory});
        ArrayList bufferQueues = Lists.newArrayList();
        for (File file : files) {
            if (!file.getName().endsWith(FILE_EXTENSION)) continue;
            bufferQueues.add(MappedBufferQueueFactory.getInstance(file));
        }
        return bufferQueues;
    }

    private static void touchFile(File file, long fileSize) throws IOException {
        Preconditions.checkArgument((fileSize > 4096L ? 1 : 0) != 0, (String)"fileSize must be at least %s", (Object[])new Object[]{4096});
        RandomAccessFile raf = new RandomAccessFile(file, "rw");
        FileChannel fc = raf.getChannel();
        MappedByteBuffer fileBuf = fc.map(FileChannel.MapMode.READ_WRITE, 0L, fileSize);
        fileBuf.order(ByteOrder.nativeOrder());
    }

    private static MappedByteBuffer mapFile(File file, long fileSize) throws IOException {
        Preconditions.checkArgument((fileSize > 4096L ? 1 : 0) != 0, (String)"fileSize must be at least %s", (Object[])new Object[]{4096});
        RandomAccessFile raf = new RandomAccessFile(file, "rw");
        FileChannel fc = raf.getChannel();
        MappedByteBuffer fileBuf = fc.map(FileChannel.MapMode.READ_WRITE, 0L, fileSize);
        fileBuf.order(ByteOrder.nativeOrder());
        return fileBuf;
    }
}

