/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.iris.bufferqueue.mmapped;

import com.google.common.annotations.VisibleForTesting;
import java.nio.ByteBuffer;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

class MappedHeader {
    @VisibleForTesting
    static final int HEADER_LENGTH = 4096;
    @VisibleForTesting
    static final long OFFSET_MAX_MSG_LENGTH = 0L;
    @VisibleForTesting
    static final long OFFSET_WRITE_CURSOR = 64L;
    @VisibleForTesting
    static final long OFFSET_READ_CURSOR = 128L;
    private final ByteBuffer headerBuffer;
    private int maxDataLengthCached;
    private final ReadWriteLock writeCursorReadWritelock = new ReentrantReadWriteLock();
    private final Lock writeCursorReadLock = this.writeCursorReadWritelock.readLock();
    private final Lock writeCursorWriteLock = this.writeCursorReadWritelock.writeLock();
    private final ReadWriteLock readCursorReadWritelock = new ReentrantReadWriteLock();
    private final Lock readCursorReadLock = this.readCursorReadWritelock.readLock();
    private final Lock readCursorWriteLock = this.readCursorReadWritelock.writeLock();

    MappedHeader(ByteBuffer headerBuffer) {
        this.headerBuffer = headerBuffer;
    }

    void format(int maxDataLength) {
        this.headerBuffer.putInt(0, maxDataLength);
        this.headerBuffer.putLong(128, 1L);
        this.headerBuffer.putLong(64, 1L);
    }

    public int maxDataLength() {
        return this.headerBuffer.getInt(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long writeCursor() {
        try {
            this.writeCursorReadLock.lock();
            long l = this.headerBuffer.getLong(64);
            return l;
        }
        finally {
            this.writeCursorReadLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long writeCursor(long n) {
        try {
            this.writeCursorWriteLock.lock();
            long currentValue = this.writeCursor();
            if (n > currentValue) {
                this.headerBuffer.putLong(64, n);
                long l = n;
                return l;
            }
        }
        finally {
            this.writeCursorWriteLock.unlock();
        }
        return this.writeCursor();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long readCursor() {
        try {
            this.readCursorReadLock.lock();
            long l = this.headerBuffer.getLong(128);
            return l;
        }
        finally {
            this.readCursorReadLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long readCursor(long n) {
        try {
            this.readCursorWriteLock.lock();
            long currentValue = this.readCursor();
            if (n > currentValue) {
                this.headerBuffer.putLong(128, n);
                long l = n;
                return l;
            }
        }
        finally {
            this.readCursorWriteLock.unlock();
        }
        return this.readCursor();
    }
}

