/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.iris.bufferqueue.mmapped;

import com.flipkart.iris.bufferqueue.BufferQueue;
import com.flipkart.iris.bufferqueue.BufferQueueEntry;
import com.flipkart.iris.bufferqueue.mmapped.Helper;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.validation.constraints.NotNull;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MappedBufferQueue
implements BufferQueue {
    private static final int MAX_BLOCK_SIZE = 0x100000;
    public static final int DEFAULT_SYNC_INTERVAL = 10;
    private final Integer blockSize;
    private final AtomicLong consumeCursor = new AtomicLong(0L);
    private final AtomicLong publishCursor = new AtomicLong(0L);
    private final HeaderSyncThread headerSyncThread;
    private final RandomAccessFile randomAccessFile;
    private final FileChannel fileChannel;
    private boolean isClosed;
    private final MappedHeader mappedHeader;
    private final MappedEntries mappedEntries;

    private MappedBufferQueue(Builder builder) throws IOException {
        boolean fileExists = builder.file.exists();
        if (!fileExists && !builder.formatIfNotExists) {
            throw new FileNotFoundException("File doesn't exist and creation not requested");
        }
        long fileSize = fileExists ? builder.file.length() : (long)builder.fileSize;
        MappedByteBuffer fileBuffer = Helper.mapFile(builder.file, fileSize);
        this.randomAccessFile = new RandomAccessFile(builder.file, "rw");
        this.fileChannel = this.randomAccessFile.getChannel();
        this.mappedHeader = this.getHeaderBuffer(fileBuffer);
        if (!fileExists) {
            Preconditions.checkArgument((builder.blockSize < 0x100000 ? 1 : 0) != 0, (String)"blockSize must be <= %s", (Object[])new Object[]{0x100000});
            this.mappedHeader.format(builder.blockSize);
        }
        this.mappedEntries = this.getEntriesBuffer(fileBuffer);
        if (!fileExists) {
            this.mappedEntries.format();
        }
        this.blockSize = this.mappedHeader.blockSize();
        this.consumeCursor.set(this.mappedHeader.readConsumeCursor());
        this.publishCursor.set(this.mappedHeader.readPublishCursor());
        this.headerSyncThread = new HeaderSyncThread(builder.headerSyncInterval);
        this.headerSyncThread.start();
    }

    private MappedHeader getHeaderBuffer(ByteBuffer fileBuffer) {
        ByteBuffer headerBuffer = MappedBufferQueue.subBuffer(fileBuffer, 0, 4096);
        return new MappedHeader(headerBuffer);
    }

    private MappedEntries getEntriesBuffer(ByteBuffer fileBuffer) {
        ByteBuffer entriesBuffer = MappedBufferQueue.subBuffer(fileBuffer, 4096);
        return new MappedEntries(entriesBuffer);
    }

    @Override
    public void close() throws IOException {
        if (!this.isClosed) {
            this.headerSyncThread.disable();
            this.syncHeader();
            this.randomAccessFile.close();
            this.fileChannel.close();
            this.isClosed = true;
        }
    }

    private void checkNotClosed() {
        if (this.isClosed) {
            throw new BufferQueue.ClosedBufferQueueException();
        }
    }

    public long forwardConsumeCursor() {
        MappedBufferQueueEntry entry;
        long consumeCursorVal;
        while ((consumeCursorVal = this.consumeCursor.get()) < this.publishCursor.get() && (entry = this.mappedEntries.getEntry(consumeCursorVal)).isPublished() && entry.isConsumed()) {
            this.consumeCursor.compareAndSet(consumeCursorVal, consumeCursorVal + 1L);
        }
        return consumeCursorVal;
    }

    public Optional<MappedBufferQueueEntry> claim(byte numBlocks) {
        long n;
        this.checkNotClosed();
        do {
            if ((n = this.publishCursor.get()) - this.consumeCursor.get() < this.maxNumEntries() - (long)numBlocks) continue;
            this.forwardConsumeCursor();
            if (n - this.consumeCursor.get() < this.maxNumEntries() - (long)numBlocks) continue;
            return Optional.absent();
        } while (!this.publishCursor.compareAndSet(n, n + (long)numBlocks));
        return Optional.of((Object)this.mappedEntries.makeEntry(n, numBlocks));
    }

    public Optional<MappedBufferQueueEntry> claim() {
        return this.claim((byte)1);
    }

    public Optional<MappedBufferQueueEntry> claimFor(int dataSize) {
        if (dataSize > this.maxDataLength()) {
            throw new IllegalArgumentException("Cannot create buffer for requested data size in this BufferQueue");
        }
        int dataPlusMetadataSize = dataSize + this.metadataOverhead();
        byte numBlocks = (byte)(dataPlusMetadataSize / this.blockSize + dataPlusMetadataSize % this.blockSize != 0 ? 1 : 0);
        return this.claim(numBlocks);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean publish(byte[] data) throws BufferOverflowException {
        Optional<MappedBufferQueueEntry> entry = this.claimFor(data.length);
        if (!entry.isPresent()) {
            return false;
        }
        try {
            ((MappedBufferQueueEntry)entry.get()).set(data);
        }
        finally {
            ((MappedBufferQueueEntry)entry.get()).markPublished();
        }
        return true;
    }

    public Optional<MappedBufferQueueEntry> peek() {
        this.checkNotClosed();
        long readCursorVal = this.forwardConsumeCursor();
        if (readCursorVal < this.publishCursor.get()) {
            return Optional.of((Object)this.mappedEntries.getEntry(readCursorVal));
        }
        return Optional.absent();
    }

    public List<MappedBufferQueueEntry> peek(int n) {
        MappedBufferQueueEntry entry;
        this.checkNotClosed();
        ArrayList bufferQueueEntries = Lists.newArrayList();
        long readCursorVal = this.forwardConsumeCursor();
        int i = 0;
        while ((long)i < Math.min((long)n, this.publishCursor.get() - readCursorVal) && (entry = this.mappedEntries.getEntry(readCursorVal + (long)i)).isPublished()) {
            bufferQueueEntries.add(entry);
            ++i;
        }
        return bufferQueueEntries;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Optional<byte[]> consume() {
        Optional<MappedBufferQueueEntry> entry = this.peek();
        try {
            if (entry.isPresent()) {
                Optional optional = Optional.of((Object)((MappedBufferQueueEntry)entry.get()).get());
                return optional;
            }
            Optional optional = Optional.absent();
            return optional;
        }
        finally {
            if (entry.isPresent()) {
                ((MappedBufferQueueEntry)entry.get()).markConsumed();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<byte[]> consume(int n) {
        List<MappedBufferQueueEntry> entries = this.peek(n);
        ArrayList dataList = Lists.newArrayListWithCapacity((int)entries.size());
        for (MappedBufferQueueEntry entry : entries) {
            try {
                dataList.add(entry.get());
            }
            finally {
                entry.markConsumed();
            }
        }
        return dataList;
    }

    public int metadataOverhead() {
        return 64 + BufferQueueEntry.metadataOverhead();
    }

    @Override
    public int maxDataLength() {
        return 127 * this.blockSize - this.metadataOverhead();
    }

    @Override
    public long maxNumEntries() {
        return this.mappedEntries.capacity;
    }

    @Override
    public long size() {
        return this.publishCursor.get() - this.consumeCursor.get();
    }

    @Override
    public boolean isFull() {
        return this.size() == this.maxNumEntries();
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void syncHeader() {
        block7: {
            if (this.fileChannel == null || !this.fileChannel.isOpen()) {
                return;
            }
            try {
                FileLock lock = this.fileChannel.lock();
                if (lock == null) break block7;
                try {
                    long currentWriteCursor = this.publishCursor.get();
                    long persistedWriteCursor = this.mappedHeader.commitPublishCursor(currentWriteCursor);
                    this.publishCursor.compareAndSet(currentWriteCursor, persistedWriteCursor);
                    long currentReadCursor = this.consumeCursor.get();
                    long persistedReadCursor = this.mappedHeader.commitConsumeCursor(currentReadCursor);
                    this.consumeCursor.compareAndSet(currentReadCursor, persistedReadCursor);
                }
                finally {
                    if (lock.isValid()) {
                        lock.release();
                    }
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private static ByteBuffer subBuffer(ByteBuffer buf, int start, int length) {
        buf = buf.duplicate();
        buf.position(start);
        buf = buf.slice();
        buf.limit(length);
        buf.rewind();
        return buf;
    }

    private static ByteBuffer subBuffer(ByteBuffer buf, int start) {
        buf = buf.duplicate();
        buf.position(start);
        buf = buf.slice();
        buf.rewind();
        return buf;
    }

    public class MappedBufferQueueEntry
    extends BufferQueueEntry {
        @VisibleForTesting
        static final int OFFSET_CURSOR = 0;
        @VisibleForTesting
        static final int OFFSET_ENTRY = 64;
        private static final long CURSOR_UNPUBLISHED = -1L;
        private static final long CURSOR_CONSUMED = -2L;
        private final ByteBuffer buf;
        private final long cursor;

        MappedBufferQueueEntry(ByteBuffer buf, long cursor) {
            super(MappedBufferQueue.subBuffer(buf, 64));
            this.buf = buf;
            this.cursor = cursor;
            buf.putLong(0, -1L);
        }

        MappedBufferQueueEntry(ByteBuffer buf) {
            super(MappedBufferQueue.subBuffer(buf, 64));
            this.buf = buf;
            this.cursor = buf.getLong(0);
        }

        public void markPublished() {
            this.writeCursor(this.cursor);
            MappedBufferQueue.this.forwardConsumeCursor();
        }

        public boolean isPublished() {
            return this.readCursor() != -1L;
        }

        public void markConsumed() {
            this.writeCursor(-2L);
            MappedBufferQueue.this.forwardConsumeCursor();
        }

        public boolean isConsumed() {
            return this.readCursor() == -2L;
        }

        @VisibleForTesting
        long readCursor() {
            return this.buf.getLong(0);
        }

        @VisibleForTesting
        void writeCursor(long cursor) {
            this.buf.putLong(0, cursor);
        }
    }

    public class MappedEntries {
        @VisibleForTesting
        static final int OFFSET_NUM_BLOCKS = 0;
        @VisibleForTesting
        static final int OFFSET_ENTRY = 1;
        private final ByteBuffer entriesBuffer;
        public final int blockSize;
        public final int capacity;

        MappedEntries(ByteBuffer entriesBuffer) {
            this.entriesBuffer = entriesBuffer;
            this.blockSize = MappedBufferQueue.this.mappedHeader.blockSize();
            this.capacity = entriesBuffer.limit() / this.blockSize;
        }

        public void format() {
            long numMessages = this.capacity;
            int i = 0;
            while ((long)i < numMessages) {
                this.makeEntry(i).set(new byte[0]);
                ++i;
            }
        }

        @NotNull
        @VisibleForTesting
        MappedBufferQueueEntry makeEntry(long cursor, byte numBlocks) {
            int offset = (int)(cursor % (long)this.capacity * (long)this.blockSize);
            ByteBuffer buf = MappedBufferQueue.subBuffer(this.entriesBuffer, offset);
            buf.put(0, numBlocks);
            return new MappedBufferQueueEntry(MappedBufferQueue.subBuffer(buf, 1), cursor);
        }

        @NotNull
        @VisibleForTesting
        MappedBufferQueueEntry makeEntry(long cursor) {
            return this.makeEntry(cursor, (byte)1);
        }

        @NotNull
        @VisibleForTesting
        MappedBufferQueueEntry getEntry(long cursor) {
            int offset = (int)(cursor % (long)this.capacity * (long)this.blockSize);
            ByteBuffer buf = MappedBufferQueue.subBuffer(this.entriesBuffer, offset);
            byte numBlocks = buf.get(0);
            return new MappedBufferQueueEntry(MappedBufferQueue.subBuffer(buf, 1));
        }
    }

    private class HeaderSyncThread
    extends Thread {
        private final long waitMillies;
        private volatile boolean isEnabled = true;

        private HeaderSyncThread(long waitMillies) {
            this.waitMillies = waitMillies;
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (true) {
                MappedHeader mappedHeader = MappedBufferQueue.this.mappedHeader;
                synchronized (mappedHeader) {
                    if (this.isEnabled) {
                        MappedBufferQueue.this.syncHeader();
                    }
                    try {
                        MappedBufferQueue.this.mappedHeader.wait(this.waitMillies);
                    }
                    catch (InterruptedException e) {
                        break;
                    }
                }
            }
        }

        public void disable() {
            this.isEnabled = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void enable() {
            this.isEnabled = true;
            HeaderSyncThread headerSyncThread = this;
            synchronized (headerSyncThread) {
                this.notifyAll();
            }
        }
    }

    static class MappedHeader {
        @VisibleForTesting
        static final int HEADER_LENGTH = 4096;
        @VisibleForTesting
        static final long OFFSET_BLOCK_SIZE = 0L;
        @VisibleForTesting
        static final long OFFSET_PUBLISH_CURSOR = 64L;
        @VisibleForTesting
        static final long OFFSET_CONSUME_CURSOR = 128L;
        private final ByteBuffer headerBuffer;
        private int maxDataLengthCached;
        private final ReadWriteLock publishCursorReadWritelock = new ReentrantReadWriteLock();
        private final Lock publishCursorReadLock = this.publishCursorReadWritelock.readLock();
        private final Lock publishCursorWriteLock = this.publishCursorReadWritelock.writeLock();
        private final ReadWriteLock consumeCursorReadWritelock = new ReentrantReadWriteLock();
        private final Lock consumeCursorReadLock = this.consumeCursorReadWritelock.readLock();
        private final Lock consumeCursorWriteLock = this.consumeCursorReadWritelock.writeLock();

        MappedHeader(ByteBuffer headerBuffer) {
            this.headerBuffer = headerBuffer;
        }

        void format(int maxDataLength) {
            this.headerBuffer.putInt(0, maxDataLength);
            this.headerBuffer.putLong(128, 0L);
            this.headerBuffer.putLong(64, 0L);
        }

        public int blockSize() {
            return this.headerBuffer.getInt(0);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        long readPublishCursor() {
            try {
                this.publishCursorReadLock.lock();
                long l = this.headerBuffer.getLong(64);
                return l;
            }
            finally {
                this.publishCursorReadLock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        long commitPublishCursor(long n) {
            try {
                this.publishCursorWriteLock.lock();
                long currentValue = this.readPublishCursor();
                if (n > currentValue) {
                    this.headerBuffer.putLong(64, n);
                    long l = n;
                    return l;
                }
            }
            finally {
                this.publishCursorWriteLock.unlock();
            }
            return this.readPublishCursor();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        long readConsumeCursor() {
            try {
                this.consumeCursorReadLock.lock();
                long l = this.headerBuffer.getLong(128);
                return l;
            }
            finally {
                this.consumeCursorReadLock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        long commitConsumeCursor(long n) {
            try {
                this.consumeCursorWriteLock.lock();
                long currentValue = this.readConsumeCursor();
                if (n > currentValue) {
                    this.headerBuffer.putLong(128, n);
                    long l = n;
                    return l;
                }
            }
            finally {
                this.consumeCursorWriteLock.unlock();
            }
            return this.readConsumeCursor();
        }
    }

    public static class Builder {
        private File file;
        private int headerSyncInterval = 10;
        private boolean formatIfNotExists = false;
        private int blockSize;
        private int fileSize;

        public Builder(File file) {
            this.file = file;
        }

        public Builder headerSyncInterval(int headerSyncInterval) {
            this.headerSyncInterval = headerSyncInterval;
            return this;
        }

        public Builder formatIfNotExists(int fileSize, int blockSize) {
            this.formatIfNotExists = true;
            this.blockSize = blockSize;
            this.fileSize = fileSize;
            return this;
        }

        public MappedBufferQueue build() throws IOException {
            return new MappedBufferQueue(this);
        }
    }
}

