/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.iris.bufferqueue.mmapped;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteOrder;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;

public class Helper {
    public static final int PAGE_SIZE = 4096;

    public static void createFile(File file, long fileSize) throws IOException {
        Preconditions.checkArgument((fileSize > 4096L ? 1 : 0) != 0, (String)"fileSize must be at least %s", (Object[])new Object[]{4096});
        RandomAccessFile raf = new RandomAccessFile(file, "rw");
        FileChannel fc = raf.getChannel();
        MappedByteBuffer fileBuf = fc.map(FileChannel.MapMode.READ_WRITE, 0L, fileSize);
        fileBuf.order(ByteOrder.nativeOrder());
    }

    public static MappedByteBuffer mapFile(File file, long fileSize) throws IOException {
        Preconditions.checkArgument((fileSize > 4096L ? 1 : 0) != 0, (String)"fileSize must be at least %s", (Object[])new Object[]{4096});
        RandomAccessFile raf = new RandomAccessFile(file, "rw");
        FileChannel fc = raf.getChannel();
        MappedByteBuffer fileBuf = fc.map(FileChannel.MapMode.READ_WRITE, 0L, fileSize);
        fileBuf.order(ByteOrder.nativeOrder());
        return fileBuf;
    }
}

