/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.iris.bufferqueue.mmapped;

import com.flipkart.iris.bufferqueue.BufferQueue;
import com.flipkart.iris.bufferqueue.BufferQueueEntry;
import com.flipkart.iris.bufferqueue.mmapped.MappedBufferQueue;
import com.google.common.base.Optional;
import java.io.File;
import java.io.IOException;
import java.nio.BufferOverflowException;
import java.util.Arrays;
import java.util.List;

public class MappedDirBufferQueue
implements BufferQueue {
    private final File dir;
    private final int blockSize;
    private final int fileSize;
    private final int maxFiles;
    private volatile Publisher publisher;
    private volatile Consumer consumer;
    private MappedBufferQueue oldestBufferQueue;
    private MappedBufferQueue newestBufferQueue;
    private boolean isClosed;

    public MappedDirBufferQueue(File dir, int blockSize, int fileSize, int maxFiles) throws IOException {
        this.dir = dir;
        this.blockSize = blockSize;
        this.fileSize = fileSize;
        this.maxFiles = maxFiles;
        if (!dir.exists() && !dir.mkdirs()) {
            throw new IOException("Couldn't create directory");
        }
        File newestFile = this.getNewestFile();
        if (newestFile == null) {
            this.createNewBufferQueue();
        } else {
            this.newestBufferQueue = new MappedBufferQueue.Builder(newestFile).headerSyncInterval(1).build();
        }
        this.updateOldestBufferQueue();
    }

    private File getNewestFile() {
        Object[] files = this.dir.listFiles();
        if (files == null || files.length == 0) {
            return null;
        }
        Arrays.sort(files);
        return files[files.length - 1];
    }

    private File getOldestFile() {
        Object[] files = this.dir.listFiles();
        if (files == null || files.length == 0) {
            return null;
        }
        Arrays.sort(files);
        return files[0];
    }

    private synchronized void createNewBufferQueue() throws IOException {
        if (this.newestBufferQueue != null && this.newestBufferQueue != this.oldestBufferQueue) {
            this.newestBufferQueue.close();
        }
        File file = new File(this.dir, Long.toString(System.nanoTime()));
        this.newestBufferQueue = new MappedBufferQueue.Builder(file).formatIfNotExists(this.fileSize, this.blockSize).headerSyncInterval(1).build();
    }

    private synchronized void updateOldestBufferQueue() throws IOException {
        if (this.oldestBufferQueue != null) {
            if (!this.oldestBufferQueue.isEmpty()) {
                return;
            }
            if (this.oldestBufferQueue == this.newestBufferQueue) {
                return;
            }
            this.oldestBufferQueue.close();
            File oldFile = this.oldestBufferQueue.getFile();
            if (!oldFile.delete()) {
                throw new IOException("Unable to delete old file");
            }
        }
        File oldestFile = this.getOldestFile();
        this.oldestBufferQueue = this.newestBufferQueue != null && oldestFile.equals(this.newestBufferQueue.getFile()) ? this.newestBufferQueue : new MappedBufferQueue.Builder(oldestFile).headerSyncInterval(1).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BufferQueue.Publisher getMappedBufferQueuePublisher() throws IOException {
        if (this.newestBufferQueue.isFull()) {
            MappedDirBufferQueue mappedDirBufferQueue = this;
            synchronized (mappedDirBufferQueue) {
                if (this.newestBufferQueue.isFull()) {
                    this.createNewBufferQueue();
                }
            }
        }
        return this.newestBufferQueue.publisher();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BufferQueue.Consumer getMappedBufferQueueConsumer() throws IOException {
        if (this.oldestBufferQueue.isEmpty()) {
            MappedDirBufferQueue mappedDirBufferQueue = this;
            synchronized (mappedDirBufferQueue) {
                if (this.oldestBufferQueue.isEmpty()) {
                    this.updateOldestBufferQueue();
                }
            }
        }
        return this.oldestBufferQueue.consumer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Publisher publisher() throws IllegalStateException, IOException {
        if (this.publisher == null) {
            MappedDirBufferQueue mappedDirBufferQueue = this;
            synchronized (mappedDirBufferQueue) {
                if (this.publisher == null) {
                    this.publisher = new Publisher();
                }
            }
        }
        return this.publisher;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Consumer consumer() throws IllegalStateException, IOException {
        if (this.consumer == null) {
            MappedDirBufferQueue mappedDirBufferQueue = this;
            synchronized (mappedDirBufferQueue) {
                if (this.consumer == null) {
                    this.consumer = new Consumer();
                }
            }
        }
        return this.consumer;
    }

    public void close() throws IOException {
        if (!this.isClosed) {
            if (this.oldestBufferQueue != null) {
                this.oldestBufferQueue.close();
            }
            if (this.newestBufferQueue != null && this.newestBufferQueue != this.oldestBufferQueue) {
                this.newestBufferQueue.close();
            }
        }
        this.isClosed = true;
    }

    public int maxDataLength() throws IOException {
        return Math.max(this.getMappedBufferQueueConsumer().bufferQueue().maxDataLength(), this.getMappedBufferQueuePublisher().bufferQueue().maxDataLength());
    }

    public long maxNumEntries() {
        return 0L;
    }

    public long size() throws IOException {
        return this.getMappedBufferQueuePublisher().bufferQueue().size() + this.getMappedBufferQueueConsumer().bufferQueue().size();
    }

    public boolean isFull() throws IOException {
        return this.getMappedBufferQueuePublisher().bufferQueue().isFull();
    }

    public boolean isEmpty() throws IOException {
        return this.getMappedBufferQueueConsumer().bufferQueue().isEmpty() && this.getMappedBufferQueuePublisher().bufferQueue().isEmpty();
    }

    public static void main(String[] args) throws IOException {
        MappedDirBufferQueue bufferQueue = new MappedDirBufferQueue(new File("/tmp/bqtest"), 1024, 10240, 5);
        long startTime = System.nanoTime();
        for (int j = 0; j < 100; ++j) {
            Optional<byte[]> msg;
            int i;
            for (i = 0; i < 100; ++i) {
                System.out.println("Publishing " + i);
                boolean publish = bufferQueue.publisher().publish(Integer.toString(i).getBytes());
                System.out.println(publish);
            }
            for (i = 0; i < 100 && (msg = bufferQueue.consumer().consume()).isPresent(); ++i) {
                System.out.println(new String((byte[])msg.get()));
            }
        }
        long endTime = System.nanoTime();
        System.out.println("Time Taken: " + (endTime - startTime) / 1000L / 1000L);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class Consumer
    implements BufferQueue.Consumer {
        @Override
        public BufferQueue bufferQueue() throws IOException {
            return MappedDirBufferQueue.this.getMappedBufferQueueConsumer().bufferQueue();
        }

        @Override
        public Optional<? extends BufferQueueEntry> peek() throws IOException {
            return MappedDirBufferQueue.this.getMappedBufferQueueConsumer().peek();
        }

        @Override
        public List<? extends BufferQueueEntry> peek(int n) throws IOException {
            return MappedDirBufferQueue.this.getMappedBufferQueueConsumer().peek(n);
        }

        @Override
        public Optional<byte[]> consume() throws IOException {
            return MappedDirBufferQueue.this.getMappedBufferQueueConsumer().consume();
        }

        @Override
        public List<byte[]> consume(int n) throws IOException {
            return MappedDirBufferQueue.this.getMappedBufferQueueConsumer().consume(n);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class Publisher
    implements BufferQueue.Publisher {
        @Override
        public BufferQueue bufferQueue() throws IOException {
            return MappedDirBufferQueue.this.getMappedBufferQueuePublisher().bufferQueue();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Optional<? extends BufferQueueEntry> claim() throws IOException {
            Optional<? extends BufferQueueEntry> claim = MappedDirBufferQueue.this.getMappedBufferQueuePublisher().claim();
            if (!claim.isPresent()) {
                Publisher publisher = this;
                synchronized (publisher) {
                    claim = MappedDirBufferQueue.this.getMappedBufferQueuePublisher().claim();
                    if (!claim.isPresent()) {
                        MappedDirBufferQueue.this.createNewBufferQueue();
                        claim = MappedDirBufferQueue.this.getMappedBufferQueuePublisher().claim();
                    }
                }
            }
            return claim;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Optional<? extends BufferQueueEntry> claimFor(int dataSize) throws IOException {
            Optional<? extends BufferQueueEntry> claim = MappedDirBufferQueue.this.getMappedBufferQueuePublisher().claimFor(dataSize);
            if (!claim.isPresent()) {
                Publisher publisher = this;
                synchronized (publisher) {
                    claim = MappedDirBufferQueue.this.getMappedBufferQueuePublisher().claimFor(dataSize);
                    if (!claim.isPresent()) {
                        MappedDirBufferQueue.this.createNewBufferQueue();
                        claim = MappedDirBufferQueue.this.getMappedBufferQueuePublisher().claimFor(dataSize);
                    }
                }
            }
            return claim;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean publish(byte[] data) throws BufferOverflowException, IOException {
            boolean publish = MappedDirBufferQueue.this.getMappedBufferQueuePublisher().publish(data);
            if (!publish) {
                Publisher publisher = this;
                synchronized (publisher) {
                    publish = MappedDirBufferQueue.this.getMappedBufferQueuePublisher().publish(data);
                    if (!publish) {
                        MappedDirBufferQueue.this.createNewBufferQueue();
                        publish = MappedDirBufferQueue.this.getMappedBufferQueuePublisher().publish(data);
                    }
                }
            }
            return publish;
        }
    }
}

