/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.caramel.model;

import com.flipkart.krystal.caramel.model.AccessBeforeInitializationException;
import com.flipkart.krystal.caramel.model.CaramelField;
import com.flipkart.krystal.caramel.model.ImmutabilityViolationException;
import com.flipkart.krystal.caramel.model.Value;
import com.flipkart.krystal.caramel.model.WorkflowPayload;
import java.util.Optional;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.initialization.qual.NotOnlyInitialized;
import org.checkerframework.checker.initialization.qual.UnknownInitialization;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public final class ValueImpl<@UnknownKeyFor T, @UnknownKeyFor P extends @UnknownKeyFor @NonNull @Initialized WorkflowPayload>
implements Value<T, P> {
    private final @UnknownKeyFor @NonNull @Initialized CaramelField<T, P> field;
    @NotOnlyInitialized
    private final P payload;
    private @MonotonicNonNull T value;

    public ValueImpl(@UnknownKeyFor @NonNull @Initialized CaramelField<T, P> field, @UnknownInitialization P payload) {
        this.field = field;
        this.payload = payload;
    }

    @Override
    public void set(T value) {
        if (this.value != null) {
            throw new ImmutabilityViolationException(this);
        }
        if (value != null) {
            this.value = value;
        }
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized Optional<T> get() {
        return Optional.ofNullable(this.value);
    }

    @Override
    public T getOrThrow() {
        return this.get().orElseThrow(() -> new AccessBeforeInitializationException(this));
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized CaramelField<T, P> field() {
        return this.field;
    }

    @Override
    public @UnknownInitialization P payload() {
        return this.payload;
    }
}

