/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.data;

import com.flipkart.krystal.data.InputValue;
import com.flipkart.krystal.data.Results;
import com.flipkart.krystal.data.ValueOrError;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;

public final class Inputs {
    private static final Inputs EMPTY = new Inputs((Map<String, InputValue<?>>)ImmutableMap.of());
    private final Map<String, InputValue<?>> values;

    public Inputs(Map<String, InputValue<?>> values) {
        this.values = values;
    }

    public InputValue<?> get(String inputName) {
        return this.values.getOrDefault(inputName, ValueOrError.empty());
    }

    public <T> ValueOrError<T> getInputValue(String inputName) {
        InputValue inputValue = this.values.getOrDefault(inputName, ValueOrError.empty());
        if (inputValue instanceof ValueOrError) {
            ValueOrError voe = (ValueOrError)inputValue;
            return voe;
        }
        throw new IllegalArgumentException();
    }

    public <T> Optional<T> getInputValueOpt(String inputName) {
        return this.getInputValue(inputName).value();
    }

    public <T> T getInputValueOrThrow(String inputName) {
        return this.getInputValueOpt(inputName).orElseThrow();
    }

    public <T> T getInputValueOrDefault(String inputName, T defaultValue) {
        return this.getInputValueOpt(inputName).orElse(defaultValue);
    }

    public <T> Results<T> getDepValue(String inputName) {
        InputValue inputValue = this.values.getOrDefault(inputName, Results.empty());
        if (inputValue instanceof Results) {
            Results voe = (Results)inputValue;
            return voe;
        }
        throw new IllegalArgumentException();
    }

    public static Inputs empty() {
        return EMPTY;
    }

    public Map<String, InputValue<?>> values() {
        return this.values;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Inputs)) {
            return false;
        }
        Inputs other = (Inputs)o;
        Map<String, InputValue<?>> this$values = this.values();
        Map<String, InputValue<?>> other$values = other.values();
        return !(this$values == null ? other$values != null : !((Object)this$values).equals(other$values));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map<String, InputValue<?>> $values = this.values();
        result = result * 59 + ($values == null ? 43 : ((Object)$values).hashCode());
        return result;
    }

    public String toString() {
        return "Inputs(values=" + this.values() + ")";
    }
}

