/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.data;

import com.flipkart.krystal.data.InputValue;
import com.flipkart.krystal.data.Results;
import com.flipkart.krystal.data.ValueOrError;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;

public record Inputs(Map<String, InputValue<Object>> values) {
    private static final Inputs EMPTY = new Inputs((Map<String, InputValue<Object>>)ImmutableMap.of());

    public InputValue<?> get(String inputName) {
        return this.values.getOrDefault(inputName, ValueOrError.empty());
    }

    public <T> ValueOrError<T> getInputValue(String inputName) {
        InputValue inputValue = this.values.getOrDefault(inputName, ValueOrError.empty());
        if (inputValue instanceof ValueOrError) {
            ValueOrError voe = (ValueOrError)inputValue;
            return voe;
        }
        throw new IllegalArgumentException();
    }

    public <T> Optional<T> getInputValueOpt(String inputName) {
        return this.getInputValue(inputName).value();
    }

    public <T> T getInputValueOrThrow(String inputName) {
        return this.getInputValueOpt(inputName).orElseThrow();
    }

    public <T> T getInputValueOrDefault(String inputName, T defaultValue) {
        return this.getInputValueOpt(inputName).orElse(defaultValue);
    }

    public <T> Results<T> getDepValue(String inputName) {
        InputValue inputValue = this.values.getOrDefault(inputName, Results.empty());
        if (inputValue instanceof Results) {
            Results voe = (Results)inputValue;
            return voe;
        }
        throw new IllegalArgumentException();
    }

    public static Inputs empty() {
        return EMPTY;
    }

    @Override
    public String toString() {
        return this.values().toString();
    }
}

