/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.data;

import com.flipkart.krystal.data.InputValue;
import java.util.Optional;
import java.util.concurrent.Callable;

public record ValueOrError<T>(Optional<T> value, Optional<Throwable> error) implements InputValue<T>
{
    private static final ValueOrError<?> EMPTY = new ValueOrError(Optional.empty(), Optional.empty());

    public ValueOrError {
        if (value.isPresent() && error.isPresent()) {
            throw new IllegalArgumentException("Both of 'value' and 'failureReason' cannot be present together");
        }
    }

    public static <T> ValueOrError<T> from(Callable<T> valueProvider) {
        try {
            return ValueOrError.withValue(valueProvider.call());
        }
        catch (Exception e) {
            return new ValueOrError(Optional.empty(), Optional.of(e));
        }
    }

    public static <T> ValueOrError<T> empty() {
        return EMPTY;
    }

    public static <T> ValueOrError<T> withValue(T t) {
        return ValueOrError.valueOrError(t, null);
    }

    public static <T> ValueOrError<T> error(Throwable t) {
        return ValueOrError.valueOrError(null, t);
    }

    public static <T> ValueOrError<T> valueOrError(Object t, Throwable throwable) {
        Optional o;
        return new ValueOrError<T>(t instanceof Optional ? (o = (Optional)t) : Optional.ofNullable(t), Optional.ofNullable(throwable));
    }

    @Override
    public String toString() {
        if (this.error.isPresent()) {
            return this.error.toString();
        }
        return this.value().toString();
    }
}

