/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.utils;

import java.util.concurrent.CompletableFuture;

public final class Futures {
    public static void propagateCancellation(CompletableFuture<?> from, CompletableFuture<?> to) {
        from.whenComplete((unused, throwable) -> {
            if (from.isDone() && !to.isDone()) {
                to.cancel(true);
            }
        });
    }

    public static <T> void propagateCompletion(CompletableFuture<? extends T> from, CompletableFuture<T> to) {
        from.whenComplete((result, error) -> {
            if (error != null) {
                to.completeExceptionally((Throwable)error);
            } else {
                to.complete(result);
            }
        });
    }

    public static <T> void linkFutures(CompletableFuture<? extends T> sourceFuture, CompletableFuture<T> destinationFuture) {
        Futures.propagateCompletion(sourceFuture, destinationFuture);
        Futures.propagateCancellation(destinationFuture, sourceFuture);
    }

    private Futures() {
    }
}

