/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.data;

import com.flipkart.krystal.data.InputValue;
import com.flipkart.krystal.data.Results;
import com.flipkart.krystal.data.ValueOrError;
import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.checker.nullness.qual.KeyForBottom;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.PolyNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;

public final class Inputs {
    private transient @UnknownKeyFor @NonNull @Initialized int $hashCodeCache;
    private final @UnknownKeyFor @NonNull @Initialized ImmutableMap<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized InputValue<@UnknownKeyFor @NonNull @Initialized Object>> values;
    private static final @UnknownKeyFor @NonNull @Initialized Inputs EMPTY = new Inputs((Map<String, InputValue<Object>>)ImmutableMap.of());

    public Inputs(@UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized InputValue<@UnknownKeyFor @NonNull @Initialized Object>> values) {
        this.values = ImmutableMap.copyOf(values);
    }

    public <T> @UnknownKeyFor @NonNull @Initialized ValueOrError<T> getInputValue(@UnknownKeyFor @NonNull @Initialized String inputName) {
        InputValue inputValue = (InputValue)this.values.getOrDefault((Object)inputName, ValueOrError.empty());
        if (inputValue instanceof ValueOrError) {
            ValueOrError voe = (ValueOrError)inputValue;
            return voe;
        }
        throw new IllegalArgumentException("%s is not of type ValueOrError".formatted(inputName));
    }

    public <T> @UnknownKeyFor @NonNull @Initialized Optional<T> getInputValueOpt(@UnknownKeyFor @NonNull @Initialized String inputName) {
        return this.getInputValue(inputName).value();
    }

    public <T> @NonNull T getInputValueOrThrow(@UnknownKeyFor @NonNull @Initialized String inputName) {
        return this.getInputValue(inputName).getValueOrThrow().orElseThrow(() -> new IllegalStateException("Could not find input value %s".formatted(inputName)));
    }

    public <T> @PolyNull T getInputValueOrDefault(@UnknownKeyFor @NonNull @Initialized String inputName, @PolyNull T defaultValue) {
        return this.getInputValueOpt(inputName).orElse(defaultValue);
    }

    public <T> @UnknownKeyFor @NonNull @Initialized Results<T> getDepValue(@UnknownKeyFor @NonNull @Initialized String inputName) {
        InputValue inputValue = (InputValue)this.values.getOrDefault((Object)inputName, Results.empty());
        if (inputValue instanceof Results) {
            Results voe = (Results)inputValue;
            return voe;
        }
        throw new IllegalArgumentException("%s is not of type Results".formatted(inputName));
    }

    public static @UnknownKeyFor @NonNull @Initialized Inputs union(@UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @KeyForBottom @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized InputValue<@UnknownKeyFor @NonNull @Initialized Object>> inputs1, @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @KeyForBottom @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized InputValue<@UnknownKeyFor @NonNull @Initialized Object>> inputs2) {
        if (inputs1 == null && inputs2 == null) {
            return new Inputs(new HashMap<String, InputValue<Object>>());
        }
        if (inputs1 == null) {
            HashMap<String, InputValue<Object>> inputValueMap = new HashMap<String, InputValue<Object>>(inputs2);
            return new Inputs(inputValueMap);
        }
        if (inputs2 == null) {
            HashMap<String, InputValue<Object>> inputValueMap = new HashMap<String, InputValue<Object>>(inputs1);
            return new Inputs(inputValueMap);
        }
        HashMap<String, InputValue<Object>> inputValueMap = new HashMap<String, InputValue<Object>>(inputs1);
        inputValueMap.putAll(inputs2);
        return new Inputs(inputValueMap);
    }

    public static @UnknownKeyFor @NonNull @Initialized Inputs empty() {
        return EMPTY;
    }

    public @UnknownKeyFor @NonNull @Initialized ImmutableMap<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized InputValue<@UnknownKeyFor @NonNull @Initialized Object>> values() {
        return this.values;
    }

    @SideEffectFree
    public @UnknownKeyFor @NonNull @Initialized String toString() {
        return this.values().toString();
    }

    @EnsuresNonNullIf(expression={"#1"}, result=true)
    @Pure
    public @UnknownKeyFor @NonNull @Initialized boolean equals(@UnknownKeyFor @NonNull @Initialized Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Inputs)) {
            return false;
        }
        Inputs other = (Inputs)o;
        ImmutableMap<String, InputValue<Object>> this$values = this.values;
        ImmutableMap<String, InputValue<Object>> other$values = other.values;
        return !(this$values == null ? other$values != null : !this$values.equals(other$values));
    }

    @Pure
    public @UnknownKeyFor @NonNull @Initialized int hashCode() {
        if (this.$hashCodeCache != 0) {
            return this.$hashCodeCache;
        }
        int PRIME = 59;
        int result = 1;
        ImmutableMap<String, InputValue<Object>> $values = this.values;
        if ((result = result * 59 + ($values == null ? 43 : $values.hashCode())) == 0) {
            result = Integer.MIN_VALUE;
        }
        this.$hashCodeCache = result;
        return result;
    }
}

