/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.datatypes;

import com.flipkart.krystal.datatypes.DataType;
import com.flipkart.krystal.datatypes.JavaDataType;
import com.flipkart.krystal.datatypes.TypeUtils;
import com.google.common.collect.ImmutableList;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.KeyForBottom;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public final class JavaType<@UnknownKeyFor T>
implements JavaDataType<T> {
    private final @UnknownKeyFor @NonNull @Initialized String className;
    private @MonotonicNonNull @UnknownKeyFor @Initialized String packageName;
    private @MonotonicNonNull @UnknownKeyFor @Initialized String simpleName;
    private @UnknownKeyFor @NonNull @Initialized ImmutableList<@UnknownKeyFor @NonNull @Initialized String> enclosingClasses = ImmutableList.of();
    private @UnknownKeyFor @NonNull @Initialized ImmutableList<@UnknownKeyFor @NonNull @Initialized DataType> typeParameters = ImmutableList.of();
    private @MonotonicNonNull @UnknownKeyFor @Initialized Type clazz;

    private JavaType(@UnknownKeyFor @NonNull @Initialized Class<T> clazz) {
        this(clazz.getPackageName(), clazz.getSimpleName(), JavaType.getEnclosingClasses(clazz));
        this.clazz = clazz;
    }

    public JavaType(@UnknownKeyFor @NonNull @Initialized String className) {
        this.className = className;
    }

    private JavaType(@UnknownKeyFor @NonNull @Initialized String className, @UnknownKeyFor @NonNull @Initialized List<@KeyForBottom @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized DataType> typeParameters) {
        this.className = className;
        this.typeParameters = ImmutableList.copyOf(typeParameters);
    }

    public JavaType(@UnknownKeyFor @NonNull @Initialized String packageName, @UnknownKeyFor @NonNull @Initialized String simpleName, @UnknownKeyFor @NonNull @Initialized ImmutableList<@UnknownKeyFor @NonNull @Initialized String> enclosingClasses) {
        this(packageName, simpleName, (List<String>)enclosingClasses, new ArrayList());
    }

    public JavaType(@UnknownKeyFor @NonNull @Initialized String packageName, @UnknownKeyFor @NonNull @Initialized String simpleName, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> enclosingClasses, @UnknownKeyFor @NonNull @Initialized List<@KeyForBottom @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized DataType> typeParameters) {
        this(Stream.of(Stream.of(packageName), enclosingClasses.stream(), Stream.of(simpleName)).flatMap(Function.identity()).collect(Collectors.joining(".")));
        this.packageName = packageName;
        this.simpleName = simpleName;
        this.enclosingClasses = ImmutableList.copyOf(enclosingClasses);
        this.typeParameters = ImmutableList.copyOf(typeParameters);
    }

    private static @UnknownKeyFor @NonNull @Initialized ImmutableList<@UnknownKeyFor @NonNull @Initialized String> getEnclosingClasses(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> clazz) {
        ArrayDeque<String> enclosingClasses = new ArrayDeque<String>();
        Class<?> enclosingClass = clazz;
        while ((enclosingClass = enclosingClass.getEnclosingClass()) != null) {
            enclosingClasses.push(enclosingClass.getSimpleName());
        }
        return ImmutableList.copyOf(enclosingClasses);
    }

    public @UnknownKeyFor @NonNull @Initialized String className() {
        return this.className;
    }

    public @UnknownKeyFor @NonNull @Initialized Optional<@UnknownKeyFor @NonNull @Initialized String> packageName() {
        return Optional.ofNullable(this.packageName);
    }

    public @UnknownKeyFor @NonNull @Initialized Optional<@UnknownKeyFor @NonNull @Initialized String> simpleName() {
        return Optional.ofNullable(this.simpleName);
    }

    public @UnknownKeyFor @NonNull @Initialized ImmutableList<@UnknownKeyFor @NonNull @Initialized String> enclosingClasses() {
        return this.enclosingClasses;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized Optional<@UnknownKeyFor @NonNull @Initialized Type> javaType() {
        block4: {
            if (this.clazz == null) {
                try {
                    Class<?> type;
                    this.clazz = type = Optional.ofNullable(this.getClass().getClassLoader()).orElseThrow(() -> new IllegalStateException("null classloader returned. Cannot proceed further")).loadClass(this.className());
                    if (this.typeParameters.isEmpty()) break block4;
                    if (this.typeParameters.stream().map(TypeUtils::getJavaType).allMatch(Optional::isPresent)) {
                        this.clazz = new ParameterizedType(){

                            @Override
                            public @UnknownKeyFor @NonNull @Initialized Type @UnknownKeyFor @NonNull @Initialized [] getActualTypeArguments() {
                                return (Type[])JavaType.this.typeParameters.stream().map(TypeUtils::getJavaType).filter(Optional::isPresent).map(Optional::get).toArray(Type[]::new);
                            }

                            @Override
                            public @UnknownKeyFor @NonNull @Initialized Type getRawType() {
                                return type;
                            }

                            @Override
                            public @Nullable @UnknownKeyFor @Initialized Type getOwnerType() {
                                return null;
                            }
                        };
                        break block4;
                    }
                    return Optional.empty();
                }
                catch (ClassNotFoundException e) {
                    return Optional.empty();
                }
            }
        }
        return Optional.of(this.clazz);
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized JavaType<T> java(@UnknownKeyFor @NonNull @Initialized Class<T> clazz) {
        return new JavaType<T>(clazz);
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized JavaType<T> java(@UnknownKeyFor @NonNull @Initialized String packageName, @UnknownKeyFor @NonNull @Initialized String simpleName, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> enclosingClasses, @UnknownKeyFor @NonNull @Initialized List<@KeyForBottom @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized DataType> typeParameters) {
        return new JavaType<T>(packageName, simpleName, enclosingClasses, typeParameters);
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized JavaType<T> java(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> typeInfo, @UnknownKeyFor @NonNull @Initialized List<@KeyForBottom @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized DataType> typeParameters) {
        if (typeInfo.size() < 1) {
            throw new IllegalArgumentException("At least one type name is needed for java types.");
        }
        if (typeInfo.size() == 1) {
            return JavaType.java(typeInfo.get(0), typeParameters);
        }
        return JavaType.java(typeInfo.get(0), typeInfo.get(typeInfo.size() - 1), typeInfo.subList(1, typeInfo.size() - 1), typeParameters);
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized JavaType<T> java(@UnknownKeyFor @NonNull @Initialized String className) {
        return new JavaType<T>(className);
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized JavaType<T> java(@UnknownKeyFor @NonNull @Initialized String className, @UnknownKeyFor @NonNull @Initialized List<@KeyForBottom @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized DataType> typeParameters) {
        return new JavaType<T>(className, typeParameters);
    }

    public @UnknownKeyFor @NonNull @Initialized ImmutableList<@UnknownKeyFor @NonNull @Initialized DataType> typeParameters() {
        return this.typeParameters;
    }
}

