/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.datatypes;

import com.flipkart.krystal.datatypes.AbstractDataType;
import com.flipkart.krystal.datatypes.DataType;
import com.flipkart.krystal.datatypes.TypeUtils;
import com.google.common.collect.ImmutableList;
import java.lang.reflect.Type;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.checker.nullness.qual.KeyForBottom;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;

public final class CustomType<@UnknownKeyFor T>
extends AbstractDataType<T> {
    private final @UnknownKeyFor @NonNull @Initialized String canonicalClassName;
    private @MonotonicNonNull @UnknownKeyFor @Initialized String packageName;
    private @MonotonicNonNull @UnknownKeyFor @Initialized String simpleName;
    private @UnknownKeyFor @NonNull @Initialized ImmutableList<@UnknownKeyFor @NonNull @Initialized String> enclosingClasses = ImmutableList.of();
    private /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized ImmutableList<@UnknownKeyFor @NonNull @Initialized DataType<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> typeParameters = ImmutableList.of();
    private @MonotonicNonNull @UnknownKeyFor @Initialized Type clazz;

    private CustomType(@UnknownKeyFor @NonNull @Initialized Class<T> clazz) {
        this(clazz.getPackageName(), clazz.getSimpleName(), CustomType.getEnclosingClasses(clazz));
        this.clazz = clazz;
    }

    public CustomType(@UnknownKeyFor @NonNull @Initialized String canonicalClassName) {
        this.canonicalClassName = canonicalClassName;
    }

    private CustomType(@UnknownKeyFor @NonNull @Initialized String canonicalClassName, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized List<@KeyForBottom @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized DataType<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> typeParameters) {
        this.canonicalClassName = canonicalClassName;
        this.typeParameters = ImmutableList.copyOf(typeParameters);
    }

    private CustomType(@UnknownKeyFor @NonNull @Initialized String packageName, @UnknownKeyFor @NonNull @Initialized String simpleName, @UnknownKeyFor @NonNull @Initialized ImmutableList<@UnknownKeyFor @NonNull @Initialized String> enclosingClasses) {
        this(packageName, simpleName, (List<String>)enclosingClasses, new ArrayList());
    }

    private CustomType(@UnknownKeyFor @NonNull @Initialized String packageName, @UnknownKeyFor @NonNull @Initialized String simpleName, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> enclosingClasses, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized List<@KeyForBottom @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized DataType<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> typeParameters) {
        this(Stream.of(Stream.of(packageName), enclosingClasses.stream(), Stream.of(simpleName)).flatMap(Function.identity()).collect(Collectors.joining(".")));
        this.packageName = packageName;
        this.simpleName = simpleName;
        this.enclosingClasses = ImmutableList.copyOf(enclosingClasses);
        this.typeParameters = ImmutableList.copyOf(typeParameters);
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized CustomType<T> create(@UnknownKeyFor @NonNull @Initialized Class<T> clazz) {
        return new CustomType<T>(clazz);
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized CustomType<T> create(@UnknownKeyFor @NonNull @Initialized String packageName, @UnknownKeyFor @NonNull @Initialized String simpleName, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> enclosingClasses, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized List<@KeyForBottom @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized DataType<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> typeParameters) {
        return new CustomType<T>(packageName, simpleName, enclosingClasses, typeParameters);
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized CustomType<T> create(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> typeInfo, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized List<@KeyForBottom @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized DataType<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> typeParameters) {
        if (typeInfo.isEmpty()) {
            throw new IllegalArgumentException("At least one type name is needed for java types.");
        }
        if (typeInfo.size() == 1) {
            return CustomType.create(typeInfo.get(0), typeParameters);
        }
        return CustomType.create(typeInfo.get(0), typeInfo.get(typeInfo.size() - 1), typeInfo.subList(1, typeInfo.size() - 1), typeParameters);
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized CustomType<T> create(@UnknownKeyFor @NonNull @Initialized String className, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized List<@KeyForBottom @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized DataType<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> typeParameters) {
        return new CustomType<T>(className, typeParameters);
    }

    public @UnknownKeyFor @NonNull @Initialized String canonicalClassName() {
        return this.canonicalClassName;
    }

    public @UnknownKeyFor @NonNull @Initialized Optional<@UnknownKeyFor @NonNull @Initialized String> packageName() {
        return Optional.ofNullable(this.packageName);
    }

    public @UnknownKeyFor @NonNull @Initialized Optional<@UnknownKeyFor @NonNull @Initialized String> simpleName() {
        return Optional.ofNullable(this.simpleName);
    }

    public @UnknownKeyFor @NonNull @Initialized ImmutableList<@UnknownKeyFor @NonNull @Initialized String> enclosingClasses() {
        return this.enclosingClasses;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized Type javaReflectType() throws @UnknownKeyFor @NonNull @Initialized ClassNotFoundException {
        if (this.clazz == null) {
            if (!this.enclosingClasses.isEmpty()) {
                throw new UnsupportedOperationException("Cannot load java type of an enclosed class - only top level classes supported");
            }
            Class<?> type = Optional.ofNullable(this.getClass().getClassLoader()).orElseThrow(() -> new IllegalStateException("null classloader returned. Cannot proceed further")).loadClass(this.canonicalClassName());
            ArrayList<Type> list = new ArrayList<Type>();
            for (DataType typeParameter : this.typeParameters) {
                Type javaReflectType = typeParameter.javaReflectType();
                list.add(javaReflectType);
            }
            this.clazz = TypeUtils.getJavaType(type, list.toArray(new Type[0]));
        }
        return this.clazz;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized TypeMirror javaModelType(@UnknownKeyFor @NonNull @Initialized ProcessingEnvironment processingEnv) {
        TypeElement typeElement = processingEnv.getElementUtils().getTypeElement(this.canonicalClassName);
        return processingEnv.getTypeUtils().getDeclaredType(typeElement, (TypeMirror[])this.typeParameters.stream().map(t -> TypeUtils.box(t.javaModelType(processingEnv), processingEnv)).toArray(TypeMirror[]::new));
    }

    private static @UnknownKeyFor @NonNull @Initialized ImmutableList<@UnknownKeyFor @NonNull @Initialized String> getEnclosingClasses(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> clazz) {
        ArrayDeque<String> enclosingClasses = new ArrayDeque<String>();
        Class<?> enclosingClass = clazz;
        while ((enclosingClass = enclosingClass.getEnclosingClass()) != null) {
            enclosingClasses.push(enclosingClass.getSimpleName());
        }
        return ImmutableList.copyOf(enclosingClasses);
    }

    @Override
    @SideEffectFree
    public @UnknownKeyFor @NonNull @Initialized String toString() {
        return "CustomType(canonicalClassName=" + this.canonicalClassName() + ", packageName=" + this.packageName() + ", simpleName=" + this.simpleName() + ", enclosingClasses=" + this.enclosingClasses() + ", typeParameters=" + this.typeParameters() + ", clazz=" + this.clazz + ")";
    }

    @EnsuresNonNullIf(expression={"#1"}, result=true)
    @Pure
    public @UnknownKeyFor @NonNull @Initialized boolean equals(@UnknownKeyFor @NonNull @Initialized Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CustomType)) {
            return false;
        }
        CustomType other = (CustomType)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$canonicalClassName = this.canonicalClassName();
        String other$canonicalClassName = other.canonicalClassName();
        if (this$canonicalClassName == null ? other$canonicalClassName != null : !this$canonicalClassName.equals(other$canonicalClassName)) {
            return false;
        }
        ImmutableList<DataType<?>> this$typeParameters = this.typeParameters();
        ImmutableList<DataType<?>> other$typeParameters = other.typeParameters();
        return !(this$typeParameters == null ? other$typeParameters != null : !this$typeParameters.equals(other$typeParameters));
    }

    protected @UnknownKeyFor @NonNull @Initialized boolean canEqual(@UnknownKeyFor @NonNull @Initialized Object other) {
        return other instanceof CustomType;
    }

    @Pure
    public @UnknownKeyFor @NonNull @Initialized int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $canonicalClassName = this.canonicalClassName();
        result = result * 59 + ($canonicalClassName == null ? 43 : $canonicalClassName.hashCode());
        ImmutableList<DataType<?>> $typeParameters = this.typeParameters();
        result = result * 59 + ($typeParameters == null ? 43 : $typeParameters.hashCode());
        return result;
    }

    public /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized ImmutableList<@UnknownKeyFor @NonNull @Initialized DataType<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> typeParameters() {
        return this.typeParameters;
    }
}

