/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.datatypes;

import com.flipkart.krystal.datatypes.DataType;
import com.flipkart.krystal.datatypes.TypeUtils;
import com.google.common.collect.ImmutableList;
import java.lang.reflect.Type;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import lombok.Generated;
import org.checkerframework.checker.calledmethods.qual.CalledMethods;
import org.checkerframework.checker.calledmethods.qual.CalledMethodsBottom;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.checker.nullness.qual.KeyForBottom;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.common.returnsreceiver.qual.UnknownThis;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;

public final class JavaType<@UnknownKeyFor T>
implements DataType<T> {
    private final @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) String canonicalClassName;
    private @MonotonicNonNull @UnknownKeyFor @Initialized @UnknownThis @CalledMethods(value={}) String packageName;
    private @MonotonicNonNull @UnknownKeyFor @Initialized @UnknownThis @CalledMethods(value={}) String simpleName;
    private @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) ImmutableList<@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) String> enclosingClasses = ImmutableList.of();
    private final /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) ImmutableList<@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) DataType<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized @UnknownThis @UnknownThis @CalledMethods(value={}) @CalledMethodsBottom ?>> typeParameters;
    private @MonotonicNonNull @UnknownKeyFor @Initialized @UnknownThis @CalledMethods(value={}) Type clazz;

    JavaType(@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) Class<T> clazz, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) List<@KeyForBottom @NonNull @Initialized @UnknownThis @CalledMethodsBottom ? extends @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) DataType<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized @UnknownThis @UnknownThis @CalledMethods(value={}) @CalledMethodsBottom ?>> typeParams) {
        this(Optional.ofNullable(clazz.getPackage()).map(Package::getName).orElse(null), clazz.getSimpleName(), (List<String>)JavaType.getEnclosingClasses(clazz), (List<DataType<?>>)typeParams);
        this.clazz = clazz;
    }

    private JavaType(@Nullable @UnknownKeyFor @Initialized @UnknownThis @CalledMethods(value={}) String packageName, @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) String simpleName, @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) List<@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) String> enclosingClasses, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) List<@KeyForBottom @NonNull @Initialized @UnknownThis @CalledMethodsBottom ? extends @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) DataType<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized @UnknownThis @UnknownThis @CalledMethods(value={}) @CalledMethodsBottom ?>> typeParameters) {
        this(Stream.of(Stream.of(packageName), enclosingClasses.stream(), Stream.of(simpleName)).flatMap(Function.identity()).filter(Objects::nonNull).collect(Collectors.joining(".")), typeParameters);
        this.packageName = packageName;
        this.simpleName = simpleName;
        this.enclosingClasses = ImmutableList.copyOf(enclosingClasses);
    }

    private JavaType(@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) String canonicalClassName, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) List<@KeyForBottom @NonNull @Initialized @UnknownThis @CalledMethodsBottom ? extends @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) DataType<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized @UnknownThis @UnknownThis @CalledMethods(value={}) @CalledMethodsBottom ?>> typeParameters) {
        this.canonicalClassName = canonicalClassName;
        this.typeParameters = ImmutableList.copyOf(typeParameters);
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) JavaType<T> create(@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) Class<T> clazz) {
        return JavaType.create(clazz, ImmutableList.of());
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) JavaType<T> create(@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) Class<T> clazz, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) List<@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) DataType<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized @UnknownThis @UnknownThis @CalledMethods(value={}) @CalledMethodsBottom ?>> typeParams) {
        String canonicalClassName = clazz.getCanonicalName();
        if (canonicalClassName != null && TypeUtils.dataTypeMappings.containsKey(canonicalClassName)) {
            return TypeUtils.dataTypeMappings.get(canonicalClassName).apply(typeParams);
        }
        return new JavaType<T>(clazz, typeParams);
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) JavaType<T> create(@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) String canonicalClassName, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) List<@KeyForBottom @NonNull @Initialized @UnknownThis @CalledMethodsBottom ? extends @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) DataType<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized @UnknownThis @UnknownThis @CalledMethods(value={}) @CalledMethodsBottom ?>> typeParameters) {
        if (TypeUtils.dataTypeMappings.containsKey(canonicalClassName)) {
            return TypeUtils.dataTypeMappings.get(canonicalClassName).apply(typeParameters);
        }
        return new JavaType<T>(canonicalClassName, typeParameters);
    }

    public @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) String canonicalClassName() {
        return this.canonicalClassName;
    }

    public @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) Optional<@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) String> packageName() {
        return Optional.ofNullable(this.packageName);
    }

    public @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) Optional<@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) String> simpleName() {
        return Optional.ofNullable(this.simpleName);
    }

    public @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) ImmutableList<@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) String> enclosingClasses() {
        return this.enclosingClasses;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) Type javaReflectType() throws @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) ClassNotFoundException {
        if (this.clazz == null) {
            if (!this.enclosingClasses.isEmpty()) {
                throw new UnsupportedOperationException("Cannot load java type of an enclosed class - only top level classes supported");
            }
            Class<?> type = Optional.ofNullable(this.getClass().getClassLoader()).orElseThrow(() -> new IllegalStateException("null classloader returned. Cannot proceed further")).loadClass(this.canonicalClassName());
            ArrayList<Type> list = new ArrayList<Type>();
            for (DataType typeParameter : this.typeParameters) {
                Type javaReflectType = typeParameter.javaReflectType();
                list.add(javaReflectType);
            }
            this.clazz = TypeUtils.getJavaType(type, list.toArray(new Type[0]));
        }
        return this.clazz;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) TypeMirror javaModelType(@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) ProcessingEnvironment processingEnv) {
        TypeKind typeKind;
        if (this.clazz != null && (typeKind = TypeUtils.typeKindMappings.get(this.clazz)) != null && typeKind.isPrimitive()) {
            return processingEnv.getTypeUtils().getPrimitiveType(typeKind);
        }
        TypeElement typeElement = processingEnv.getElementUtils().getTypeElement(this.canonicalClassName);
        if (typeElement == null) {
            throw new IllegalArgumentException("Could not find typeElement for canonical class name %s".formatted(this.canonicalClassName));
        }
        return processingEnv.getTypeUtils().getDeclaredType(typeElement, (TypeMirror[])this.typeParameters.stream().map(t -> TypeUtils.box(t.javaModelType(processingEnv), processingEnv)).toArray(TypeMirror[]::new));
    }

    private static @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) ImmutableList<@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) String> getEnclosingClasses(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) Class<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized @UnknownThis @UnknownThis @CalledMethods(value={}) @CalledMethodsBottom ?> clazz) {
        ArrayDeque<String> enclosingClasses = new ArrayDeque<String>();
        Class<?> enclosingClass = clazz;
        while ((enclosingClass = enclosingClass.getEnclosingClass()) != null) {
            enclosingClasses.push(enclosingClass.getSimpleName());
        }
        return ImmutableList.copyOf(enclosingClasses);
    }

    @SideEffectFree
    public @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) String toString() {
        try {
            return this.javaReflectType().toString();
        }
        catch (ClassNotFoundException e) {
            return super.toString();
        }
    }

    @EnsuresNonNullIf(expression={"#1"}, result=true)
    @Pure
    @Generated
    public @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) boolean equals(@Nullable @UnknownKeyFor @Initialized @UnknownThis @CalledMethods(value={}) Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JavaType)) {
            return false;
        }
        JavaType other = (JavaType)o;
        String this$canonicalClassName = this.canonicalClassName();
        String other$canonicalClassName = other.canonicalClassName();
        if (this$canonicalClassName == null ? other$canonicalClassName != null : !this$canonicalClassName.equals(other$canonicalClassName)) {
            return false;
        }
        ImmutableList<DataType<?>> this$typeParameters = this.typeParameters();
        ImmutableList<DataType<?>> other$typeParameters = other.typeParameters();
        return !(this$typeParameters == null ? other$typeParameters != null : !this$typeParameters.equals(other$typeParameters));
    }

    @Pure
    @Generated
    public @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $canonicalClassName = this.canonicalClassName();
        result = result * 59 + ($canonicalClassName == null ? 43 : $canonicalClassName.hashCode());
        ImmutableList<DataType<?>> $typeParameters = this.typeParameters();
        result = result * 59 + ($typeParameters == null ? 43 : $typeParameters.hashCode());
        return result;
    }

    @Generated
    public /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) ImmutableList<@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) DataType<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized @UnknownThis @UnknownThis @CalledMethods(value={}) @CalledMethodsBottom ?>> typeParameters() {
        return this.typeParameters;
    }
}

