/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.utils;

import com.flipkart.krystal.utils.DistributeLeases;
import com.flipkart.krystal.utils.LeaseUnavailableException;
import com.flipkart.krystal.utils.MultiLeasePolicy;
import com.flipkart.krystal.utils.PreferObjectReuse;
import java.util.Deque;
import java.util.LinkedList;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.checkerframework.checker.calledmethods.qual.CalledMethods;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.common.returnsreceiver.qual.UnknownThis;

public class MultiLeasePool<@UnknownKeyFor T>
implements AutoCloseable {
    private final @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) Supplier<@NonNull T> creator;
    private final @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) MultiLeasePolicy leasePolicy;
    private final @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) Consumer<T> destroyer;
    private volatile @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) double peakAvgActiveLeasesPerObject;
    private volatile @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) int maxPoolSize;
    private final @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) Deque<@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) PooledObject<T>> queue = new LinkedList<PooledObject<T>>();
    private volatile @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) boolean closed;
    private volatile @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) int maxActiveLeasesPerObject;

    public MultiLeasePool(@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) Supplier<@NonNull T> creator, @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) MultiLeasePolicy leasePolicy, @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) Consumer<T> destroyer) {
        this.creator = creator;
        this.leasePolicy = leasePolicy;
        this.destroyer = destroyer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) Lease<T> lease() throws @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) LeaseUnavailableException {
        MultiLeasePool multiLeasePool = this;
        synchronized (multiLeasePool) {
            PooledObject<T> leasable;
            PooledObject<T> head;
            boolean leasable2;
            if (this.closed) {
                throw new IllegalStateException("MultiLeasePool already closed");
            }
            int count = this.queue.size();
            while (!(leasable2 = this.checkLeasabilityAndRotateIfNeeded(head = this.queue.peek())) && head != null && --count > 0) {
            }
            if (head == null || !this.shouldLeaseOut(head)) {
                leasable = this.createNewForLeasing();
            } else {
                leasable = head;
                leasable.incrementActiveLeases();
            }
            this.maxActiveLeasesPerObject = Math.max(this.maxActiveLeasesPerObject, leasable.activeLeases());
            this.peakAvgActiveLeasesPerObject = Math.max(this.peakAvgActiveLeasesPerObject, this.queue.stream().mapToInt(PooledObject::activeLeases).average().orElse(0.0));
            return new Lease<T>(leasable, this::giveBack);
        }
    }

    private @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) boolean checkLeasabilityAndRotateIfNeeded(@Nullable @UnknownKeyFor @Initialized @UnknownThis @CalledMethods(value={}) PooledObject<T> head) {
        DistributeLeases distributeLeases;
        MultiLeasePolicy multiLeasePolicy;
        boolean shouldPushToLast;
        if (head == null) {
            return false;
        }
        boolean shouldLeaseOut = this.shouldLeaseOut(head);
        boolean bl = shouldPushToLast = !shouldLeaseOut || (multiLeasePolicy = this.leasePolicy) instanceof DistributeLeases && (distributeLeases = (DistributeLeases)multiLeasePolicy).maxActiveObjects() == this.queue.size();
        if (shouldPushToLast) {
            this.queue.poll();
            if (!this.shouldDelete(head)) {
                this.queue.add(head);
            }
        }
        return shouldLeaseOut;
    }

    private @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) boolean shouldDelete(@Nullable @UnknownKeyFor @Initialized @UnknownThis @CalledMethods(value={}) PooledObject<T> pooledObject) {
        if (pooledObject == null) {
            return false;
        }
        return pooledObject.markForDeletion > 100;
    }

    private void addLeasedToQueue(@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) PooledObject<T> pooledObject) {
        if (this.leasePolicy instanceof PreferObjectReuse) {
            this.queue.addFirst(pooledObject);
        } else if (this.leasePolicy instanceof DistributeLeases) {
            this.queue.addLast(pooledObject);
        } else {
            throw new UnsupportedOperationException();
        }
    }

    private @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) boolean shouldLeaseOut(@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) PooledObject<T> pooledObject) {
        if (this.shouldDelete(pooledObject)) {
            return false;
        }
        MultiLeasePolicy multiLeasePolicy = this.leasePolicy;
        if (multiLeasePolicy instanceof PreferObjectReuse) {
            PreferObjectReuse preferObjectReuse = (PreferObjectReuse)multiLeasePolicy;
            return pooledObject.activeLeases() < preferObjectReuse.maxActiveLeasesPerObject();
        }
        multiLeasePolicy = this.leasePolicy;
        if (multiLeasePolicy instanceof DistributeLeases) {
            DistributeLeases distributeLeases = (DistributeLeases)multiLeasePolicy;
            return pooledObject.activeLeases() < distributeLeases.distributionTriggerThreshold() || this.queue.size() == distributeLeases.maxActiveObjects();
        }
        throw new UnsupportedOperationException();
    }

    private synchronized void giveBack(@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) PooledObject<T> pooledObject) {
        if (this.shouldDelete(pooledObject) && pooledObject.activeLeases() == 0) {
            this.destroyer.accept(pooledObject.ref());
        }
    }

    private @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) PooledObject<T> createNewForLeasing() throws @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) LeaseUnavailableException {
        PreferObjectReuse preferObjectReuse;
        int limit = Integer.MAX_VALUE;
        MultiLeasePolicy multiLeasePolicy = this.leasePolicy;
        if (multiLeasePolicy instanceof PreferObjectReuse && (preferObjectReuse = (PreferObjectReuse)multiLeasePolicy).maxActiveObjects().isPresent()) {
            limit = preferObjectReuse.maxActiveObjects().get();
        } else {
            multiLeasePolicy = this.leasePolicy;
            if (multiLeasePolicy instanceof DistributeLeases) {
                DistributeLeases distributeLeases = (DistributeLeases)multiLeasePolicy;
                limit = distributeLeases.maxActiveObjects();
            }
        }
        if (this.queue.size() >= limit) {
            throw new LeaseUnavailableException("Reached max object limit : " + limit + " in MultiLeasePool");
        }
        PooledObject<T> pooledObject = new PooledObject<T>(this.creator.get(), this.maxActiveLeasesPerObject());
        pooledObject.incrementActiveLeases();
        this.addLeasedToQueue(pooledObject);
        this.maxPoolSize = Math.max(this.maxPoolSize, this.queue.size());
        return pooledObject;
    }

    public final @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) int maxActiveLeasesPerObject() {
        return this.maxActiveLeasesPerObject;
    }

    public final @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) double peakAvgActiveLeasesPerObject() {
        return this.peakAvgActiveLeasesPerObject;
    }

    public final @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) int maxPoolSize() {
        return this.maxPoolSize;
    }

    @Override
    public void close() {
        PooledObject<T> pooledObject;
        this.closed = true;
        while ((pooledObject = this.queue.pollLast()) != null) {
            this.destroyer.accept(pooledObject.ref());
        }
    }

    private static final class PooledObject<@UnknownKeyFor T> {
        private final @NonNull T ref;
        private final @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) int deletionThreshold;
        private @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) int activeLeases = 0;
        private @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) int markForDeletion;

        private PooledObject(@NonNull T ref, @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) int deletionThreshold) {
            this.ref = ref;
            this.deletionThreshold = deletionThreshold;
        }

        private T ref() {
            return this.ref;
        }

        private @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) int activeLeases() {
            return this.activeLeases;
        }

        private void incrementActiveLeases() {
            ++this.activeLeases;
            if (this.activeLeases() == this.deletionThreshold) {
                this.markForDeletion = 0;
            }
        }

        private void decrementActiveLeases() {
            --this.activeLeases;
            if (this.activeLeases() < this.deletionThreshold) {
                ++this.markForDeletion;
            }
        }
    }

    public static final class Lease<@UnknownKeyFor T>
    implements AutoCloseable {
        private @Nullable @UnknownKeyFor @Initialized @UnknownThis @CalledMethods(value={}) PooledObject<T> pooledObject;
        private final @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) Consumer<@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) PooledObject<T>> giveback;

        private Lease(@NonNull @UnknownKeyFor @Initialized @UnknownThis @CalledMethods(value={}) PooledObject<T> pooledObject, @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) Consumer<@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) PooledObject<T>> giveback) {
            this.pooledObject = pooledObject;
            this.giveback = giveback;
        }

        public T get() {
            if (this.pooledObject == null) {
                throw new IllegalStateException("Lease already released");
            }
            return this.pooledObject.ref();
        }

        @Override
        public void close() {
            PooledObject<T> pooledObject = this.pooledObject;
            if (pooledObject != null) {
                this.giveback.accept(pooledObject);
                pooledObject.decrementActiveLeases();
                this.pooledObject = null;
            }
        }
    }
}

