/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.concurrent;

import com.google.common.annotations.VisibleForTesting;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinTask;
import java.util.concurrent.ForkJoinWorkerThread;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SingleThreadExecutor
extends ForkJoinPool {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SingleThreadExecutor.class);

    public SingleThreadExecutor(String poolName) {
        super(1, new SingleThreadFactory(poolName), null, true, 1, 1, 1, null, Integer.MAX_VALUE, TimeUnit.DAYS);
        Future task = this.submit(() -> {});
        ((ForkJoinTask)task).join();
    }

    @VisibleForTesting
    Thread executionThread() {
        ForkJoinWorkerThread singleThread = ((SingleThreadFactory)this.getFactory()).singleThread;
        if (singleThread != null) {
            return singleThread;
        }
        throw new AssertionError((Object)"ThreadPerRequestExecutor thread not created yet. This should not happen since we executed a task and waited for its completion in the constructor");
    }

    public boolean isCurrentThreadTheSingleThread() {
        ForkJoinWorkerThread forkJoinWorkerThread;
        Thread thread = Thread.currentThread();
        return thread instanceof ForkJoinWorkerThread && (forkJoinWorkerThread = (ForkJoinWorkerThread)thread).getPool() == this;
    }

    @Override
    public void execute(Runnable runnable) {
        if (this.isCurrentThreadTheSingleThread()) {
            runnable.run();
        } else {
            super.execute(runnable);
        }
    }

    private static final class SingleThreadFactory
    implements ForkJoinPool.ForkJoinWorkerThreadFactory {
        private final String poolName;
        private @MonotonicNonNull ForkJoinWorkerThread singleThread;
        private volatile boolean threadReturned = false;

        private SingleThreadFactory(String poolName) {
            this.poolName = poolName;
        }

        @Override
        public ForkJoinWorkerThread newThread(ForkJoinPool pool) {
            if (this.threadReturned) {
                log.error("ThreadPerRequestExecutor can only have one thread. But `ForkJoinWorkerThreadFactory.newThread` was called more than once. Returning the same thread again. This means the original thread is somehow being stopped, or the ForkjoinPool is creating more than one thread. If this cannot be fixed, then we cannot assume that the initial thread will always be used.");
            }
            this.threadReturned = true;
            return this.singleThread(pool);
        }

        private synchronized ForkJoinWorkerThread singleThread(ForkJoinPool pool) {
            boolean isTerminated = false;
            if (this.singleThread == null || (isTerminated = Thread.State.TERMINATED.equals((Object)this.singleThread.getState()))) {
                if (isTerminated) {
                    log.error("ThreadPerRequestExecutor thread was terminated.  This should not happen. Needs investigation.  Creating a new thread.");
                }
                @NonNull ForkJoinWorkerThread thread = ForkJoinPool.defaultForkJoinWorkerThreadFactory.newThread(pool);
                thread.setName(this.poolName() + "-" + thread.getName());
                this.singleThread = thread;
            }
            return this.singleThread;
        }

        public String poolName() {
            return this.poolName;
        }

        @Generated
        public @NonNull String toString() {
            return "SingleThreadExecutor.SingleThreadFactory(poolName=" + this.poolName() + ", singleThread=" + this.singleThread + ", threadReturned=" + this.threadReturned + ")";
        }
    }
}

