/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.datatypes;

import com.flipkart.krystal.datatypes.DataType;
import com.flipkart.krystal.datatypes.JavaType;
import com.flipkart.krystal.datatypes.JavaTypes;
import com.google.common.base.Preconditions;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class TypeUtils {
    static final Map<String, Function<DataType<?>[], JavaType<?>>> dataTypeMappings = new LinkedHashMap();
    static final Map<String, TypeKind> typeKindMappings = new LinkedHashMap<String, TypeKind>();
    static final Set<Class<?>> NON_PRIMITIVE_CLASSES_WITH_PLATFORM_DEFAULTS = Set.of(String.class, List.class, Map.class);

    static Type getJavaType(final Type rawType, final Type ... typeParameters) {
        if (typeParameters.length == 0) {
            return rawType;
        }
        return new ParameterizedType(){

            @Override
            public Type[] getActualTypeArguments() {
                return typeParameters;
            }

            @Override
            public Type getRawType() {
                return rawType;
            }

            @Override
            public @Nullable Type getOwnerType() {
                return null;
            }
        };
    }

    static TypeMirror box(TypeMirror typeMirror, ProcessingEnvironment processingEnv) {
        if (typeMirror.getKind().isPrimitive()) {
            return processingEnv.getTypeUtils().boxedClass((PrimitiveType)typeMirror).asType();
        }
        return typeMirror;
    }

    static boolean hasPlatformDefaultValue(TypeMirror t) {
        DeclaredType declaredType;
        Element element;
        if (t instanceof PrimitiveType) {
            return true;
        }
        if (t instanceof ArrayType) {
            return true;
        }
        if (t instanceof DeclaredType && (element = (declaredType = (DeclaredType)t).asElement()) instanceof TypeElement) {
            TypeElement typeElement = (TypeElement)element;
            return NON_PRIMITIVE_CLASSES_WITH_PLATFORM_DEFAULTS.stream().anyMatch(aClass -> typeElement.getQualifiedName().contentEquals((CharSequence)Preconditions.checkNotNull((Object)aClass.getCanonicalName())));
        }
        return false;
    }

    private TypeUtils() {
    }

    static {
        dataTypeMappings.put(Boolean.TYPE.getCanonicalName(), _unused -> JavaTypes.BOOLEAN);
        dataTypeMappings.put(Boolean.class.getCanonicalName(), _unused -> JavaTypes.BOOLEAN);
        typeKindMappings.put(Boolean.TYPE.getCanonicalName(), TypeKind.BOOLEAN);
        typeKindMappings.put(Boolean.class.getCanonicalName(), TypeKind.BOOLEAN);
        dataTypeMappings.put(Integer.TYPE.getCanonicalName(), _unused -> JavaTypes.INT);
        dataTypeMappings.put(Integer.class.getCanonicalName(), _unused -> JavaTypes.INT);
        typeKindMappings.put(Integer.TYPE.getCanonicalName(), TypeKind.INT);
        typeKindMappings.put(Integer.class.getCanonicalName(), TypeKind.INT);
        dataTypeMappings.put(Byte.TYPE.getCanonicalName(), _unused -> JavaTypes.BYTE);
        dataTypeMappings.put(Byte.class.getCanonicalName(), _unused -> JavaTypes.BYTE);
        typeKindMappings.put(Byte.TYPE.getCanonicalName(), TypeKind.BYTE);
        typeKindMappings.put(Byte.class.getCanonicalName(), TypeKind.BYTE);
        dataTypeMappings.put(Short.TYPE.getCanonicalName(), _unused -> JavaTypes.SHORT);
        dataTypeMappings.put(Short.class.getCanonicalName(), _unused -> JavaTypes.SHORT);
        typeKindMappings.put(Short.TYPE.getCanonicalName(), TypeKind.SHORT);
        typeKindMappings.put(Short.class.getCanonicalName(), TypeKind.SHORT);
        dataTypeMappings.put(Long.TYPE.getCanonicalName(), _unused -> JavaTypes.LONG);
        dataTypeMappings.put(Long.class.getCanonicalName(), _unused -> JavaTypes.LONG);
        typeKindMappings.put(Long.TYPE.getCanonicalName(), TypeKind.LONG);
        typeKindMappings.put(Long.class.getCanonicalName(), TypeKind.LONG);
        dataTypeMappings.put(Character.TYPE.getCanonicalName(), _unused -> JavaTypes.CHAR);
        dataTypeMappings.put(Character.class.getCanonicalName(), _unused -> JavaTypes.CHAR);
        typeKindMappings.put(Character.TYPE.getCanonicalName(), TypeKind.CHAR);
        typeKindMappings.put(Character.class.getCanonicalName(), TypeKind.CHAR);
        dataTypeMappings.put(Character.TYPE.getCanonicalName(), _unused -> JavaTypes.FLOAT);
        dataTypeMappings.put(Character.class.getCanonicalName(), _unused -> JavaTypes.FLOAT);
        typeKindMappings.put(Float.TYPE.getCanonicalName(), TypeKind.FLOAT);
        typeKindMappings.put(Float.class.getCanonicalName(), TypeKind.FLOAT);
        dataTypeMappings.put(Character.TYPE.getCanonicalName(), _unused -> JavaTypes.DOUBLE);
        dataTypeMappings.put(Character.class.getCanonicalName(), _unused -> JavaTypes.DOUBLE);
        typeKindMappings.put(Double.TYPE.getCanonicalName(), TypeKind.DOUBLE);
        typeKindMappings.put(Double.class.getCanonicalName(), TypeKind.DOUBLE);
        dataTypeMappings.put(String.class.getCanonicalName(), _unused -> JavaTypes.STRING);
        dataTypeMappings.put(Object.class.getCanonicalName(), _unused -> JavaTypes.OBJECT);
        dataTypeMappings.put(List.class.getName(), typeParams -> ((DataType[])typeParams).length == 0 ? JavaTypes.LIST_RAW : new JavaType(List.class, (DataType<?>)typeParams));
        dataTypeMappings.put(Set.class.getName(), typeParams -> ((DataType[])typeParams).length == 0 ? JavaTypes.MAP_RAW : new JavaType(Set.class, (DataType<?>)typeParams));
    }
}

