/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.concurrent;

import com.google.common.annotations.VisibleForTesting;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinTask;
import java.util.concurrent.ForkJoinWorkerThread;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.checkerframework.checker.calledmethods.qual.CalledMethods;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.checker.optional.qual.MaybePresent;
import org.checkerframework.common.aliasing.qual.MaybeAliased;
import org.checkerframework.common.aliasing.qual.MaybeLeaked;
import org.checkerframework.common.returnsreceiver.qual.UnknownThis;
import org.checkerframework.dataflow.qual.SideEffectFree;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SingleThreadExecutor
extends ForkJoinPool {
    @Generated
    private static final @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent Logger log = LoggerFactory.getLogger(SingleThreadExecutor.class);

    public SingleThreadExecutor(@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent String poolName) {
        super(1, new SingleThreadFactory(poolName), null, true, 1, 1, 1, null, Integer.MAX_VALUE, TimeUnit.DAYS);
        Future task = this.submit(() -> {});
        ((ForkJoinTask)task).join();
    }

    @VisibleForTesting
    @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent Thread executionThread() {
        ForkJoinWorkerThread singleThread = ((SingleThreadFactory)this.getFactory()).singleThread;
        if (singleThread != null) {
            return singleThread;
        }
        throw new AssertionError((Object)"ThreadPerRequestExecutor thread not created yet. This should not happen since we executed a task and waited for its completion in the constructor");
    }

    public @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent boolean isCurrentThreadTheSingleThread() {
        ForkJoinWorkerThread forkJoinWorkerThread;
        Thread thread = Thread.currentThread();
        return thread instanceof ForkJoinWorkerThread && (forkJoinWorkerThread = (ForkJoinWorkerThread)thread).getPool() == this;
    }

    @Override
    public void execute(@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent Runnable runnable) {
        if (this.isCurrentThreadTheSingleThread()) {
            runnable.run();
        } else {
            super.execute(runnable);
        }
    }

    private static final class SingleThreadFactory
    implements ForkJoinPool.ForkJoinWorkerThreadFactory {
        private final @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent String poolName;
        private @MonotonicNonNull @UnknownKeyFor @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent ForkJoinWorkerThread singleThread;
        private volatile @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent boolean threadReturned = false;

        private SingleThreadFactory(@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent String poolName) {
            this.poolName = poolName;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent ForkJoinWorkerThread newThread(@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent ForkJoinPool pool) {
            if (this.threadReturned) {
                log.error("ThreadPerRequestExecutor can only have one thread. But `ForkJoinWorkerThreadFactory.newThread` was called more than once. Returning the same thread again. This means the original thread is somehow being stopped, or the ForkjoinPool is creating more than one thread. If this cannot be fixed, then we cannot assume that the initial thread will always be used.");
            }
            this.threadReturned = true;
            return this.singleThread(pool);
        }

        private synchronized @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent ForkJoinWorkerThread singleThread(@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent ForkJoinPool pool) {
            boolean isTerminated = false;
            if (this.singleThread == null || (isTerminated = Thread.State.TERMINATED.equals((Object)this.singleThread.getState()))) {
                if (isTerminated) {
                    log.error("ThreadPerRequestExecutor thread was terminated.  This should not happen. Needs investigation.  Creating a new thread.");
                }
                @NonNull ForkJoinWorkerThread thread = ForkJoinPool.defaultForkJoinWorkerThreadFactory.newThread(pool);
                thread.setName(this.poolName() + "-" + thread.getName());
                this.singleThread = thread;
            }
            return this.singleThread;
        }

        public @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent String poolName() {
            return this.poolName;
        }

        @SideEffectFree
        @Generated
        public @NonNull @UnknownKeyFor @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent String toString() {
            return "SingleThreadExecutor.SingleThreadFactory(poolName=" + this.poolName() + ", singleThread=" + this.singleThread + ", threadReturned=" + this.threadReturned + ")";
        }
    }
}

