/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.traits.matchers;

import com.flipkart.krystal.traits.matchers.AnythingMatcher;
import com.flipkart.krystal.traits.matchers.EnumMatcher;
import com.flipkart.krystal.traits.matchers.TypeMatcher;
import lombok.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface InputValueMatcher<T> {
    public boolean matches(@Nullable Object var1);

    public static <T> InputValueMatcher<T> isInstanceOf(Class<? extends T> type) {
        return new TypeMatcher<T>(type);
    }

    public static <T extends Enum<T>> InputValueMatcher<T> equalsEnum(@NonNull Enum<T> enumValue) {
        if (enumValue == null) {
            throw new NullPointerException("enumValue is marked non-null but is null");
        }
        return new EnumMatcher<T>(enumValue);
    }

    public static <T> InputValueMatcher<T> isAnyValue() {
        return AnythingMatcher.ANY_VALUE;
    }

    public static <T> InputValueMatcher<T> isAnyNonNullValue() {
        return AnythingMatcher.ANY_NON_NULL;
    }
}

