/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.vajram.codegen;

import com.flipkart.krystal.vajram.Vajram;
import com.flipkart.krystal.vajram.VajramID;
import com.flipkart.krystal.vajram.codegen.VajramCodeGenerator;
import com.flipkart.krystal.vajram.codegen.models.DependencyDef;
import com.flipkart.krystal.vajram.codegen.models.InputDef;
import com.flipkart.krystal.vajram.codegen.models.ParsedVajramData;
import com.flipkart.krystal.vajram.codegen.models.VajramFacetsDef;
import com.flipkart.krystal.vajram.codegen.models.VajramInfo;
import com.flipkart.krystal.vajram.codegen.models.VajramInfoLite;
import com.flipkart.krystal.vajram.codegen.utils.CodegenUtils;
import com.flipkart.krystal.vajram.codegen.utils.Constants;
import com.flipkart.krystal.vajram.das.DataAccessSpec;
import com.flipkart.krystal.vajram.exception.VajramValidationException;
import com.flipkart.krystal.vajram.inputs.Dependency;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.squareup.javapoet.TypeName;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.KeyForBottom;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.common.reflection.qual.ClassValBottom;
import org.checkerframework.common.reflection.qual.MethodValBottom;
import org.checkerframework.common.reflection.qual.UnknownClass;
import org.checkerframework.common.reflection.qual.UnknownMethod;
import org.checkerframework.common.value.qual.BottomVal;
import org.checkerframework.common.value.qual.UnknownVal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class VajramCodeGenFacade {
    private static final @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized Logger log = LoggerFactory.getLogger(VajramCodeGenFacade.class);
    public static final @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized String INPUTS_FILE_EXTENSION = ".vajram.yaml";
    private final @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized List<@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized Path> srcDirs;
    private final @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized Path compiledClassesDir;
    private final @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized Path generatedSrcDir;
    private final @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized Iterable<@BottomVal @ClassValBottom @MethodValBottom @KeyForBottom @NonNull @Initialized ? extends @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized File> compileClasspath;

    public static void main(@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized String @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized [] args) {
        Options options = new Options();
        String command = args[0];
        options.addOption(Option.builder((String)"j").longOpt("javaDir").hasArg().desc("Root Directory for all .java files").required().build());
        options.addOption(Option.builder((String)"v").longOpt("vajramFile").hasArg().desc("FilePath of the vajram input file for which request code will be generated").required().build());
        options.addOption(Option.builder((String)"g").longOpt("generatedSrcDir").hasArg().desc("Root Directory for generated source code").build());
        DefaultParser parser = new DefaultParser();
        HelpFormatter formatter = new HelpFormatter();
        if ("codeVajramModels".equals(command)) {
            try {
                List<String> arguments = List.of(args).subList(1, args.length);
                CommandLine cmd = parser.parse(options, (String[])arguments.toArray(String[]::new));
                Path vajramInputFilePath = Path.of(cmd.getOptionValue("v"), new String[0]);
                Path vajramInputFileName = vajramInputFilePath.getFileName();
                if (vajramInputFileName == null || !vajramInputFileName.toString().endsWith(INPUTS_FILE_EXTENSION)) {
                    return;
                }
                Path javaSrcDirPath = Path.of(cmd.getOptionValue("j"), new String[0]);
                Path sourceSetPath = Optional.ofNullable(javaSrcDirPath.getParent()).orElseThrow(() -> new IllegalStateException("Java src dir does not have a parent"));
                String sourceSetName = Optional.ofNullable(sourceSetPath.getFileName()).map(Path::toString).orElseThrow();
                Path projectDir = Optional.ofNullable(sourceSetPath.getParent()).map(Path::getParent).orElseThrow();
                Path generatedSrcDir = cmd.getOptionValue("g") == null ? projectDir.resolve(Path.of("build", "generated", "sources", "vajrams", sourceSetName, "java")) : Path.of(cmd.getOptionValue("g"), new String[0]);
                new VajramCodeGenFacade(List.of(javaSrcDirPath), projectDir.resolve(Path.of("build", "classes", "java", sourceSetName)), generatedSrcDir).codeGenModels(javaSrcDirPath, javaSrcDirPath.relativize(vajramInputFilePath));
            }
            catch (ParseException e) {
                log.error("Command line options could not be parsed", (Throwable)e);
                formatter.printHelp("Vajram Code Generator", options);
                System.exit(1);
            }
            catch (IOException e) {
                log.error("Error reading vajramInputFile", (Throwable)e);
                System.exit(1);
            }
        }
    }

    public static void codeGenVajramImpl(@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized Set<@BottomVal @ClassValBottom @MethodValBottom @KeyForBottom @NonNull @Initialized ? extends @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized File> srcDirs, @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized String compiledDir, @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized String destinationDir, @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized Iterable<@BottomVal @ClassValBottom @MethodValBottom @KeyForBottom @NonNull @Initialized ? extends @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized File> classpath) throws @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized Exception {
        new VajramCodeGenFacade(srcDirs.stream().map(File::toPath).toList(), Path.of(compiledDir, new String[0]), Path.of(destinationDir, new String[0]), classpath).codeGenVajramImpl();
    }

    public VajramCodeGenFacade(@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized List<@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized Path> srcDirs, @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized Path compiledClassesDir, @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized Path generatedSrcDir) {
        this(srcDirs, compiledClassesDir, generatedSrcDir, Collections.emptyList());
    }

    public VajramCodeGenFacade(@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized List<@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized Path> srcDirs, @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized Path compiledClassesDir, @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized Path generatedSrcDir, @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized Iterable<@BottomVal @ClassValBottom @MethodValBottom @KeyForBottom @NonNull @Initialized ? extends @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized File> compileClasspath) {
        this.compiledClassesDir = compiledClassesDir;
        this.srcDirs = Collections.unmodifiableList(srcDirs);
        this.generatedSrcDir = generatedSrcDir;
        this.compileClasspath = compileClasspath;
    }

    private void codeGenModels(@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized Path srcDir, @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized Path vajramInputRelativePath) throws @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized IOException {
        this.codeGenModels(VajramCodeGenFacade.toVajramInfo(new VajramFacetsDef.InputFilePath(srcDir, vajramInputRelativePath)));
    }

    private void codeGenModels(@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized VajramInfo inputFile) {
        try {
            VajramCodeGenerator vajramCodeGenerator = new VajramCodeGenerator(inputFile, Collections.emptyMap());
            this.codeGenRequest(vajramCodeGenerator);
            this.codeGenUtil(vajramCodeGenerator);
        }
        catch (Throwable e) {
            throw new RuntimeException("Could not generate code for file %s".formatted(inputFile.packageName() + "." + inputFile.vajramName()), e);
        }
    }

    private void codeGenRequest(@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized VajramCodeGenerator vajramCodeGenerator) throws @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized IOException {
        File vajramJavaDir = Paths.get(this.generatedSrcDir.toString(), vajramCodeGenerator.getPackageName().split("\\.")).toFile();
        if (vajramJavaDir.isDirectory() || vajramJavaDir.mkdirs()) {
            String vajramRequestJavaCode = vajramCodeGenerator.codeGenVajramRequest();
            File vajramRequestSourceFile = new File(vajramJavaDir, vajramCodeGenerator.getRequestClassName() + ".java");
            Files.writeString(vajramRequestSourceFile.toPath(), (CharSequence)vajramRequestJavaCode, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.WRITE);
        }
    }

    private void codeGenVajramImpl() throws @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized Exception {
        ImmutableList<VajramInfo> vajramInfos = this.getInputDefinitions();
        ClassLoader systemClassLoader = (ClassLoader)Preconditions.checkNotNull((Object)VajramID.class.getClassLoader());
        ArrayList<URL> urls = new ArrayList<URL>();
        this.srcDirs.forEach(path -> {
            try {
                urls.add(path.toFile().toURI().toURL());
            }
            catch (MalformedURLException e) {
                log.error("Malformed url {}", (Object)path.toFile().toURI());
                throw new RuntimeException(e);
            }
        });
        this.compileClasspath.forEach(file -> {
            try {
                urls.add(file.toURI().toURL());
            }
            catch (MalformedURLException e) {
                log.error("Malformed url {}", (Object)file.toURI());
                throw new RuntimeException(e);
            }
        });
        urls.add(this.compiledClassesDir.toFile().toURI().toURL());
        try (URLClassLoader urlcl = new URLClassLoader((URL[])urls.toArray(URL[]::new), systemClassLoader);){
            HashMap vajramDefs = new HashMap();
            vajramInfos.forEach(vajramInfo -> {
                Optional<ParsedVajramData> parsedVajramData = ParsedVajramData.fromVajram(urlcl, vajramInfo);
                if (parsedVajramData.isEmpty()) {
                    log.warn("VajramImpl codegen will be skipped for {}. ", (Object)vajramInfo.vajramName());
                } else {
                    String vajramName = parsedVajramData.get().vajramName();
                    vajramDefs.put(vajramName, new VajramInfoLite(vajramName, vajramInfo.responseType()));
                }
            });
            vajramInfos.forEach(vajramInfo -> vajramInfo.allInputsStream().forEach(inputDef -> {
                VajramID vajramID;
                String depVajramClass;
                String[] splits;
                String vajramName;
                Dependency dependency;
                DataAccessSpec patt10410$temp;
                if (inputDef instanceof Dependency && (patt10410$temp = (dependency = (Dependency)inputDef).dataAccessSpec()) instanceof VajramID && !vajramDefs.containsKey(vajramName = (splits = Constants.DOT_PATTERN.split(depVajramClass = (String)(vajramID = (VajramID)patt10410$temp).className().orElseThrow(() -> new VajramValidationException("Vajram class missing in VajramInputDefinition for :" + vajramID))))[splits.length - 1])) {
                    try {
                        Class<?> vajramClass = urlcl.loadClass(depVajramClass);
                        vajramDefs.put(vajramName, new VajramInfoLite(vajramName, TypeName.get((Type)this.getVajramResponseType(vajramClass))));
                    }
                    catch (ClassNotFoundException e) {
                        throw new RuntimeException(e);
                    }
                }
            }));
            vajramInfos.forEach(vajramInfo -> {
                if (vajramDefs.containsKey(vajramInfo.vajramName())) {
                    try {
                        VajramCodeGenerator vajramCodeGenerator = new VajramCodeGenerator((VajramInfo)vajramInfo, vajramDefs);
                        this.codeGenVajramImpl(vajramCodeGenerator, urlcl);
                    }
                    catch (Throwable e) {
                        throw new RuntimeException("Could not generate vajram impl for file %s".formatted(vajramInfo.packageName() + "." + vajramInfo.vajramName()), e);
                    }
                }
            });
        }
        catch (IOException e) {
            throw new RuntimeException("Exception while generating vajram impl", e);
        }
    }

    private @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized Type getVajramResponseType(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized Class<@BottomVal @ClassValBottom @MethodValBottom @UnknownKeyFor @NonNull @Initialized ? extends @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized Vajram<@UnknownVal @BottomVal @UnknownClass @ClassValBottom @UnknownMethod @MethodValBottom @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> vajramClass) {
        return VajramCodeGenFacade.getGenericClassParameter(vajramClass);
    }

    private static /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized Class<@UnknownVal @BottomVal @UnknownClass @ClassValBottom @UnknownMethod @MethodValBottom @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> getGenericClassParameter(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized Class<@UnknownVal @BottomVal @UnknownClass @ClassValBottom @UnknownMethod @MethodValBottom @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> parameterizedSubClass) {
        HashMap mapping = new HashMap();
        List<Class<?>> klasses = List.of(parameterizedSubClass);
        while (!klasses.isEmpty()) {
            ArrayList newSuperKlasses = new ArrayList();
            for (Class<?> klass : klasses) {
                List<Type> superTypes = Stream.concat(Arrays.stream(klass.getGenericInterfaces()), Stream.of(klass.getGenericSuperclass())).toList();
                for (Type type : superTypes) {
                    if (type instanceof ParameterizedType) {
                        ParameterizedType parType = (ParameterizedType)type;
                        Type rawType = parType.getRawType();
                        if (rawType == Vajram.class) {
                            Type t = parType.getActualTypeArguments()[0];
                            if (t instanceof Class) {
                                return (Class)t;
                            }
                            return Optional.ofNullable((Class)mapping.get((TypeVariable)t)).orElseThrow(() -> new IllegalStateException("Could not find mapping for type variable %s".formatted(t)));
                        }
                        TypeVariable<?>[] vars = ((GenericDeclaration)((Object)parType.getRawType())).getTypeParameters();
                        Type[] args = parType.getActualTypeArguments();
                        for (int i = 0; i < vars.length; ++i) {
                            if (args[i] instanceof Class) {
                                mapping.put(vars[i], (Class)args[i]);
                                continue;
                            }
                            TypeVariable tVar = (TypeVariable)args[i];
                            mapping.put(vars[i], Optional.ofNullable((Class)mapping.get(tVar)).orElseThrow(() -> new IllegalStateException("Could not find mapping for type variable %s".formatted(tVar))));
                        }
                        newSuperKlasses.add((Class)rawType);
                        continue;
                    }
                    newSuperKlasses.add((Class)type);
                }
            }
            klasses = newSuperKlasses;
        }
        throw new IllegalArgumentException("no generic supertype for " + parameterizedSubClass + " of type " + Vajram.class);
    }

    private void codeGenVajramImpl(@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized VajramCodeGenerator vajramCodeGenerator, @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized ClassLoader classLoader) throws @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized IOException {
        File vajramJavaDir = Paths.get(this.generatedSrcDir.toString(), vajramCodeGenerator.getPackageName().split("\\.")).toFile();
        if (vajramJavaDir.isDirectory() || vajramJavaDir.mkdirs()) {
            String vajramImplCode = vajramCodeGenerator.codeGenVajramImpl(classLoader);
            File vajramImplSourceFile = new File(vajramJavaDir, CodegenUtils.getVajramImplClassName(vajramCodeGenerator.getVajramName()) + ".java");
            Files.writeString(vajramImplSourceFile.toPath(), (CharSequence)vajramImplCode, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.WRITE);
        }
    }

    private void codeGenUtil(@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized VajramCodeGenerator vajramCodeGenerator) throws @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized IOException {
        File vajramJavaDir = Paths.get(this.generatedSrcDir.toString(), vajramCodeGenerator.getPackageName().split("\\.")).toFile();
        if (vajramJavaDir.isDirectory() || vajramJavaDir.mkdirs()) {
            String inputUtilJavaCode = vajramCodeGenerator.codeGenInputUtil();
            File inputUtilSourceFile = new File(vajramJavaDir, CodegenUtils.getInputUtilClassName(vajramCodeGenerator.getVajramName()) + ".java");
            Files.writeString(inputUtilSourceFile.toPath(), (CharSequence)inputUtilJavaCode, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.WRITE);
        }
    }

    @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized ImmutableList<@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized VajramInfo> getInputDefinitions() throws @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized Exception {
        ArrayList<VajramInfo> vajramInputFiles = new ArrayList<VajramInfo>();
        Set<VajramFacetsDef.InputFilePath> inputFiles = this.getInputsYamlFiles();
        for (VajramFacetsDef.InputFilePath inputFile : inputFiles) {
            vajramInputFiles.add(VajramCodeGenFacade.toVajramInfo(inputFile));
        }
        return ImmutableList.copyOf(vajramInputFiles);
    }

    private static @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized VajramInfo toVajramInfo(@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized VajramFacetsDef.InputFilePath inputFile) throws @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized IOException {
        String fileName = String.valueOf(Preconditions.checkNotNull((Object)inputFile.relativeFilePath().getFileName()));
        String vajramName = fileName.substring(0, fileName.length() - INPUTS_FILE_EXTENSION.length());
        File vajramInputFile = inputFile.absolutePath().toFile();
        String packageName = CodegenUtils.getPackageFromPath(inputFile.relativeFilePath());
        return VajramCodeGenFacade.toVajramInfo(vajramInputFile, vajramName, packageName);
    }

    public static @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized VajramInfo toVajramInfo(@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized File vajramInputFile, @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized String vajramName, @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized String packageName) throws @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized IOException {
        VajramFacetsDef vajramFacetsDef = VajramFacetsDef.from(vajramInputFile);
        TypeName responseType = vajramFacetsDef.output().toTypeName();
        System.out.println("******************************");
        System.out.println(responseType);
        System.out.println("******************************");
        return new VajramInfo(vajramName, packageName, (ImmutableList)vajramFacetsDef.inputs().stream().map(InputDef::toInputDefinition).collect(ImmutableList.toImmutableList()), (ImmutableList)vajramFacetsDef.dependencies().stream().map(DependencyDef::toInputDefinition).collect(ImmutableList.toImmutableList()), responseType);
    }

    private @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized Set<@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized VajramFacetsDef.InputFilePath> getInputsYamlFiles() throws @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized IOException {
        LinkedHashSet<VajramFacetsDef.InputFilePath> inputFilePaths = new LinkedHashSet<VajramFacetsDef.InputFilePath>();
        for (Path srcDir : this.srcDirs) {
            if (!srcDir.toFile().isDirectory()) continue;
            Stream<Path> vajramInputPathStream = Files.find(srcDir, 100, (path, fileAttributes) -> {
                if (!fileAttributes.isRegularFile()) {
                    return false;
                }
                Path fileName = path.getFileName();
                return fileName != null && fileName.toString().endsWith(INPUTS_FILE_EXTENSION);
            }, new FileVisitOption[0]);
            try {
                vajramInputPathStream.forEach(p -> inputFilePaths.add(new VajramFacetsDef.InputFilePath(srcDir, srcDir.relativize((Path)p))));
            }
            finally {
                if (vajramInputPathStream == null) continue;
                vajramInputPathStream.close();
            }
        }
        return inputFilePaths;
    }
}

