/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.visualization;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.checkerframework.checker.calledmethods.qual.CalledMethods;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.checker.optional.qual.MaybePresent;
import org.checkerframework.common.aliasing.qual.MaybeAliased;
import org.checkerframework.common.aliasing.qual.MaybeLeaked;
import org.checkerframework.common.returnsreceiver.qual.UnknownThis;

public class StaticCallGraphHtml {
    private static final @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent String TEMPLATE_PATH = "/templates/graph.html";
    private static final @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent String STATIC_PATH = "/static";
    private static final @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent String JS_PATH = "/static/js";
    private static final @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent String CSS_PLACEHOLDER = "__CSS_CONTENT__";
    private static final @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent String DATA_PLACEHOLDER = "__GRAPH_DATA__";
    private static final @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent String MAIN_JS_PLACEHOLDER = "__MAIN_JS__";
    private static final @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent String CONFIG_JS_PLACEHOLDER = "__CONFIG_JS__";
    private static final @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent String DATA_PROCESSOR_JS_PLACEHOLDER = "__DATA_PROCESSOR_JS__";
    private static final @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent String GRAPH_RENDERER_JS_PLACEHOLDER = "__GRAPH_RENDERER_JS__";
    private static final @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent String NODE_CONTROLLER_JS_PLACEHOLDER = "__NODE_CONTROLLER_JS__";
    private static final @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent String SEARCH_CONTROLLER_JS_PLACEHOLDER = "__SEARCH_CONTROLLER_JS__";
    private static final @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent String TOOLTIP_JS_PLACEHOLDER = "__TOOLTIP_JS__";
    private static final @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent String INTERACTION_HANDLER_JS_PLACEHOLDER = "__INTERACTION_HANDLER_JS__";
    private static final @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent Pattern D3_IMPORT = Pattern.compile("import \\* as d3 from.*?;");
    private static final @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent Pattern D3_DAG_IMPORT = Pattern.compile("import \\* as d3dag from.*?;");
    private static final @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent Pattern JS_FILE_IMPORT = Pattern.compile("import \\{ .+? } from ['\"]\\./(.+?)\\.js['\"];");
    private static final @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent Pattern EXPORT_FUNC_CLASS = Pattern.compile("export (class|function) (\\w+)");
    private static final @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent Pattern EXPORT_CONST = Pattern.compile("export const ([\\w_]+) =");

    private static @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent String loadTemplate() {
        String string;
        InputStream inputStream = StaticCallGraphHtml.class.getResourceAsStream(TEMPLATE_PATH);
        if (inputStream == null) {
            throw new RuntimeException("Template file not found in /templates/graph.html");
        }
        BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));
        try {
            string = reader.lines().collect(Collectors.joining("\n"));
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                throw new RuntimeException("Error reading template", e);
            }
        }
        reader.close();
        return string;
    }

    public static @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent String generateStaticCallGraphHtml(@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent String jsonGraphData) {
        try {
            String template = StaticCallGraphHtml.loadTemplate();
            template = template.replace(DATA_PLACEHOLDER, jsonGraphData);
            String cssContent = StaticCallGraphHtml.loadResourceContent("/static/styles.css");
            template = template.replace(CSS_PLACEHOLDER, cssContent);
            HashMap<String, String> jsFilePlaceholders = new HashMap<String, String>();
            jsFilePlaceholders.put(MAIN_JS_PLACEHOLDER, "/static/js/main.js");
            jsFilePlaceholders.put(CONFIG_JS_PLACEHOLDER, "/static/js/config.js");
            jsFilePlaceholders.put(DATA_PROCESSOR_JS_PLACEHOLDER, "/static/js/dataProcessor.js");
            jsFilePlaceholders.put(GRAPH_RENDERER_JS_PLACEHOLDER, "/static/js/graphRenderer.js");
            jsFilePlaceholders.put(NODE_CONTROLLER_JS_PLACEHOLDER, "/static/js/nodeController.js");
            jsFilePlaceholders.put(SEARCH_CONTROLLER_JS_PLACEHOLDER, "/static/js/searchController.js");
            jsFilePlaceholders.put(TOOLTIP_JS_PLACEHOLDER, "/static/js/tooltip.js");
            jsFilePlaceholders.put(INTERACTION_HANDLER_JS_PLACEHOLDER, "/static/js/interactionHandler.js");
            for (Map.Entry entry : jsFilePlaceholders.entrySet()) {
                String placeholder = (String)entry.getKey();
                String filePath = (String)entry.getValue();
                String jsContent = StaticCallGraphHtml.loadResourceContent(filePath);
                jsContent = StaticCallGraphHtml.processJsContent(jsContent);
                template = template.replace(placeholder, jsContent);
            }
            return template;
        }
        catch (IOException e) {
            throw new RuntimeException("Error generating HTML with inlined resources", e);
        }
    }

    private static @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent String processJsContent(@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent String jsContent) {
        String processed = JS_FILE_IMPORT.matcher(D3_DAG_IMPORT.matcher(D3_IMPORT.matcher(jsContent).replaceAll("")).replaceAll("")).replaceAll("");
        processed = EXPORT_CONST.matcher(EXPORT_FUNC_CLASS.matcher(processed).replaceAll("$1 $2")).replaceAll("const $1 =");
        return processed;
    }

    private static @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent String loadResourceContent(@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent String resourcePath) throws @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent IOException {
        InputStream inputStream = StaticCallGraphHtml.class.getResourceAsStream(resourcePath);
        if (inputStream == null) {
            throw new IOException("Resource not found: " + resourcePath);
        }
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));){
            String string = reader.lines().collect(Collectors.joining("\n"));
            return string;
        }
    }
}

