/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.krystex.decoration;

import com.flipkart.krystal.krystex.RateLimitingStrategy;
import com.flipkart.krystal.krystex.config.ConfigProvider;
import com.flipkart.krystal.krystex.node.MainLogic;
import com.flipkart.krystal.krystex.node.MainLogicDecorator;
import com.flipkart.krystal.krystex.node.MainLogicDefinition;
import com.flipkart.krystal.krystex.node.NodeLogicId;
import io.github.resilience4j.decorators.Decorators;
import io.github.resilience4j.ratelimiter.RateLimiter;
import io.github.resilience4j.ratelimiter.RateLimiterConfig;
import io.github.resilience4j.ratelimiter.internal.SemaphoreBasedRateLimiter;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public class Resilience4JStrategy<T>
implements MainLogicDecorator<T> {
    private final ConfigProvider configProvider;
    private final Map<NodeLogicId, RateLimiter> rateLimiters = new HashMap<NodeLogicId, RateLimiter>();

    public Resilience4JStrategy(ConfigProvider configProvider) {
        this.configProvider = configProvider;
    }

    @Override
    public MainLogic<T> decorateLogic(MainLogicDefinition<T> nodeDef, MainLogic<T> logicToDecorate) {
        Decorators.DecorateFunction decorateCompletionStage = Decorators.ofFunction(logicToDecorate::execute);
        this.decorateWithRateLimiter(nodeDef, decorateCompletionStage);
        this.decorateWithCircuitBreaker(nodeDef, decorateCompletionStage);
        return arg_0 -> ((Decorators.DecorateFunction)decorateCompletionStage).apply(arg_0);
    }

    private void decorateWithRateLimiter(MainLogicDefinition<T> nodeDef, Decorators.DecorateFunction<?, ?> decorateFunction) {
        RateLimiter rateLimiter = this.rateLimiters.get(nodeDef.nodeLogicId());
        if (rateLimiter == null) {
            rateLimiter = this.rateLimiters.computeIfAbsent(nodeDef.nodeLogicId(), nodeId -> this.createRateLimiter((NodeLogicId)nodeId).orElse(null));
        } else {
            this.updateRateLimiter(nodeDef.nodeLogicId(), rateLimiter);
        }
        if (rateLimiter != null) {
            decorateFunction.withRateLimiter(rateLimiter);
        }
    }

    private void decorateWithCircuitBreaker(MainLogicDefinition<T> nodeDef, Decorators.DecorateFunction<?, ?> decorateFunction) {
    }

    private void updateRateLimiter(NodeLogicId nodeLogicId, RateLimiter rateLimiter) {
        try {
            Optional<Integer> rateLimit = this.configProvider.getInt(nodeLogicId + ".concurrentExecutions");
            this.configProvider.getString(nodeLogicId + ".rate_limiting_strategy").map(RateLimitingStrategy::valueOf).ifPresent(rateLimitingStrategy -> {
                if (RateLimitingStrategy.SEMAPHORE.equals(rateLimitingStrategy) && rateLimit.isPresent() && rateLimiter.getRateLimiterConfig().getLimitForPeriod() != ((Integer)rateLimit.get()).intValue()) {
                    rateLimiter.changeLimitForPeriod(((Integer)rateLimit.get()).intValue());
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private Optional<RateLimiter> createRateLimiter(NodeLogicId nodeLogicId) {
        try {
            Optional<Integer> rateLimit = this.configProvider.getInt(nodeLogicId + ".concurrentExecutions");
            Optional<String> rateLimitingStrategy = this.configProvider.getString(nodeLogicId + ".rate_limiting_strategy");
            if (rateLimitingStrategy.isEmpty() || rateLimit.isEmpty()) {
                return Optional.empty();
            }
            if (RateLimitingStrategy.SEMAPHORE.equals((Object)RateLimitingStrategy.valueOf(rateLimitingStrategy.get()))) {
                return Optional.of(new SemaphoreBasedRateLimiter(nodeLogicId.asString(), RateLimiterConfig.custom().limitForPeriod(rateLimit.get().intValue()).build()));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return Optional.empty();
    }
}

