/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.krystex.decorators;

import com.flipkart.krystal.krystex.MainLogic;
import com.flipkart.krystal.krystex.config.ConfigProvider;
import com.flipkart.krystal.krystex.decoration.MainLogicDecorator;
import io.github.resilience4j.bulkhead.Bulkhead;
import io.github.resilience4j.bulkhead.BulkheadConfig;
import io.github.resilience4j.bulkhead.internal.SemaphoreBulkhead;
import io.github.resilience4j.decorators.Decorators;
import java.util.Optional;

public final class Resilience4JBulkhead
implements MainLogicDecorator {
    public static final String DECORATOR_TYPE = Resilience4JBulkhead.class.getName();
    private final ConfigProvider configProvider;
    private final String instanceId;
    private Bulkhead bulkhead;

    public Resilience4JBulkhead(String instanceId, ConfigProvider configProvider) {
        this.instanceId = instanceId;
        this.configProvider = configProvider;
        this.init();
    }

    @Override
    public MainLogic<Object> decorateLogic(MainLogic<Object> logicToDecorate) {
        Bulkhead bulkhead = this.bulkhead;
        if (bulkhead != null) {
            return arg_0 -> ((Decorators.DecorateFunction)Decorators.ofFunction(logicToDecorate::execute).withBulkhead(bulkhead)).apply(arg_0);
        }
        return logicToDecorate;
    }

    @Override
    public void onConfigUpdate() {
        this.updateBulkhead();
    }

    @Override
    public String getId() {
        return this.instanceId;
    }

    private void init() {
        this.bulkhead = this.getBulkheadConfig().map(bulkheadConfig -> new SemaphoreBulkhead(this.instanceId + ".bulkhead", bulkheadConfig)).orElse(null);
    }

    private void updateBulkhead() {
        Bulkhead bulkhead = this.bulkhead;
        Optional<BulkheadConfig> newBulkheadConfig = this.getBulkheadConfig();
        if (!Optional.ofNullable(bulkhead).map(Bulkhead::getBulkheadConfig).equals(newBulkheadConfig)) {
            if (bulkhead != null && newBulkheadConfig.isPresent()) {
                bulkhead.changeConfig(newBulkheadConfig.get());
            } else {
                this.init();
            }
        }
    }

    private Optional<BulkheadConfig> getBulkheadConfig() {
        boolean bulkheadEnabled = this.configProvider.getConfig(this.instanceId + ".bulkhead.enabled").orElse(true);
        if (!bulkheadEnabled) {
            return Optional.empty();
        }
        BulkheadConfig.Builder builder = BulkheadConfig.custom().writableStackTraceEnabled(false);
        this.configProvider.getConfig(this.instanceId + ".bulkhead.max_concurrency").ifPresent(arg_0 -> ((BulkheadConfig.Builder)builder).maxConcurrentCalls(arg_0));
        return Optional.of(builder.build());
    }
}

