/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.krystex.node;

import com.flipkart.krystal.data.InputValue;
import com.flipkart.krystal.data.Inputs;
import com.flipkart.krystal.data.Results;
import com.flipkart.krystal.data.ValueOrError;
import com.flipkart.krystal.krystex.MainLogic;
import com.flipkart.krystal.krystex.MainLogicDefinition;
import com.flipkart.krystal.krystex.RequestId;
import com.flipkart.krystal.krystex.ResolverCommand;
import com.flipkart.krystal.krystex.ResolverDefinition;
import com.flipkart.krystal.krystex.commands.ExecuteWithAllInputs;
import com.flipkart.krystal.krystex.commands.ExecuteWithDependency;
import com.flipkart.krystal.krystex.commands.NodeCommand;
import com.flipkart.krystal.krystex.commands.SkipNode;
import com.flipkart.krystal.krystex.decoration.LogicDecorationOrdering;
import com.flipkart.krystal.krystex.decoration.MainLogicDecorator;
import com.flipkart.krystal.krystex.node.DuplicateInputForRequestException;
import com.flipkart.krystal.krystex.node.KrystalNodeExecutor;
import com.flipkart.krystal.krystex.node.NodeDefinition;
import com.flipkart.krystal.krystex.node.NodeId;
import com.flipkart.krystal.krystex.node.NodeLogicId;
import com.flipkart.krystal.krystex.node.NodeResponseFuture;
import com.flipkart.krystal.krystex.node.SkipNodeException;
import com.flipkart.krystal.utils.Futures;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;

public class Node {
    private final NodeId nodeId;
    private final NodeDefinition nodeDefinition;
    private final KrystalNodeExecutor krystalNodeExecutor;
    private final ImmutableMap<String, MainLogicDecorator> requestScopedMainLogicDecorators;
    private final ImmutableMap<Optional<String>, List<ResolverDefinition>> resolverDefinitionsByInput;
    private final ImmutableMap<String, List<ResolverDefinition>> resolverDefinitionsByDependency;
    private final LogicDecorationOrdering logicDecorationOrdering;
    private final Map<RequestId, Map<String, InputValue<Object>>> inputsValueCollector = new LinkedHashMap<RequestId, Map<String, InputValue<Object>>>();
    private final Map<RequestId, NodeResponseFuture> resultsByRequest = new LinkedHashMap<RequestId, NodeResponseFuture>();
    private final Map<Inputs, CompletableFuture<ValueOrError<Object>>> resultsCache = new LinkedHashMap<Inputs, CompletableFuture<ValueOrError<Object>>>();
    private final Map<RequestId, Map<NodeLogicId, List<ResolverCommand>>> resolverResults = new LinkedHashMap<RequestId, Map<NodeLogicId, List<ResolverCommand>>>();

    public Node(NodeDefinition nodeDefinition, KrystalNodeExecutor krystalNodeExecutor, ImmutableMap<String, MainLogicDecorator> requestScopedMainLogicDecorators, LogicDecorationOrdering logicDecorationOrdering) {
        this.nodeId = nodeDefinition.nodeId();
        this.nodeDefinition = nodeDefinition;
        this.krystalNodeExecutor = krystalNodeExecutor;
        this.requestScopedMainLogicDecorators = requestScopedMainLogicDecorators;
        this.resolverDefinitionsByInput = Node.createResolverDefinitionsByInputs(nodeDefinition.resolverDefinitions());
        this.resolverDefinitionsByDependency = Node.createResolverDefinitionsByDependency(nodeDefinition.resolverDefinitions());
        this.logicDecorationOrdering = logicDecorationOrdering;
    }

    NodeResponseFuture executeCommand(NodeCommand nodeCommand) {
        RequestId requestId = nodeCommand.requestId();
        NodeResponseFuture resultForRequest = this.resultsByRequest.computeIfAbsent(requestId, r -> new NodeResponseFuture());
        try {
            boolean executeMainLogic;
            if (nodeCommand instanceof SkipNode) {
                SkipNode skipNode = (SkipNode)nodeCommand;
                resultForRequest.responseFuture().completeExceptionally(new SkipNodeException(skipNode.skipDependencyCommand().reason()));
                return resultForRequest;
            }
            if (nodeCommand instanceof ExecuteWithDependency) {
                ExecuteWithDependency executeWithInput = (ExecuteWithDependency)nodeCommand;
                executeMainLogic = this.executeWithInput(requestId, executeWithInput);
            } else if (nodeCommand instanceof ExecuteWithAllInputs) {
                ExecuteWithAllInputs executeWithAllInputs = (ExecuteWithAllInputs)nodeCommand;
                executeMainLogic = this.executeWithInputs(requestId, executeWithAllInputs);
            } else {
                throw new UnsupportedOperationException("Unknown type of nodeCommand: %s".formatted(nodeCommand));
            }
            if (executeMainLogic) {
                this.executeMainLogic(resultForRequest, requestId);
            }
        }
        catch (DuplicateInputForRequestException e) {
            throw e;
        }
        catch (Exception e) {
            resultForRequest.responseFuture().completeExceptionally(e);
        }
        return resultForRequest;
    }

    private boolean executeWithInputs(RequestId requestId, ExecuteWithAllInputs executeWithAllInputs) {
        LinkedHashSet providedInputs = new LinkedHashSet(executeWithAllInputs.inputs().values().keySet());
        this.nodeDefinition.nodeDefinitionRegistry().logicDefinitionRegistry().getMain(this.nodeDefinition.mainLogicNode()).inputNames().stream().filter(s -> !this.nodeDefinition.dependencyNodes().containsKey(s)).forEach(providedInputs::add);
        ImmutableSet inputNames = ImmutableSet.copyOf(providedInputs);
        this.collectInputValues(requestId, (ImmutableSet<String>)inputNames, executeWithAllInputs.inputs());
        return this.executeWithInputs(requestId, (ImmutableSet<String>)inputNames, executeWithAllInputs);
    }

    private boolean executeWithInput(RequestId requestId, ExecuteWithDependency executeWithInput) {
        String input = executeWithInput.dependencyName();
        ImmutableSet inputNames = ImmutableSet.of((Object)input);
        this.collectInputValues(requestId, (ImmutableSet<String>)inputNames, new Inputs((Map)ImmutableMap.of((Object)input, executeWithInput.results())));
        return this.executeWithInputs(requestId, (ImmutableSet<String>)inputNames, executeWithInput);
    }

    private void collectInputValues(RequestId requestId, ImmutableSet<String> inputNames, Inputs executeWithInput) {
        for (String inputName : inputNames) {
            if (this.inputsValueCollector.computeIfAbsent(requestId, r -> new LinkedHashMap()).putIfAbsent(inputName, (InputValue)executeWithInput.values().get(inputName)) == null) continue;
            throw new DuplicateInputForRequestException("Duplicate input data for a request %s".formatted(requestId));
        }
    }

    private boolean executeWithInputs(RequestId requestId, ImmutableSet<String> newInputNames, NodeCommand nodeCommand) {
        MainLogicDefinition mainLogicNodeDefinition = this.nodeDefinition.nodeDefinitionRegistry().logicDefinitionRegistry().getMain(this.nodeDefinition.mainLogicNode());
        Inputs allInputs = new Inputs(this.inputsValueCollector.computeIfAbsent(requestId, r -> new LinkedHashMap()));
        ImmutableSet inputAndDepNames = mainLogicNodeDefinition.inputNames();
        if (allInputs.values().isEmpty()) {
            if (inputAndDepNames.isEmpty()) {
                return true;
            }
            if (this.nodeDefinition.resolverDefinitions().isEmpty() && !this.nodeDefinition.dependencyNodes().isEmpty()) {
                this.nodeDefinition.dependencyNodes().forEach((depName, depNodeId) -> {
                    if (!this.inputsValueCollector.getOrDefault(requestId, (Map<String, InputValue<Object>>)ImmutableMap.of()).containsKey(depName)) {
                        RequestId dependencyRequestId = requestId.append("%s".formatted(depName));
                        NodeResponseFuture nodeResponse = this.krystalNodeExecutor.enqueueCommand(new ExecuteWithAllInputs((NodeId)depNodeId, Inputs.empty(), dependencyRequestId));
                        nodeResponse.responseFuture().whenComplete((result, throwable) -> {
                            if (throwable != null) {
                                result = ValueOrError.error((Throwable)throwable);
                            }
                            this.krystalNodeExecutor.enqueueCommand(new ExecuteWithDependency(nodeCommand.nodeId(), (String)depName, (Results<Object>)new Results((Map)ImmutableMap.of((Object)Inputs.empty(), (Object)result)), requestId));
                        });
                    }
                });
                return false;
            }
        }
        Set allInputNames = allInputs.values().keySet();
        this.resultsByRequest.computeIfAbsent(requestId, r -> new NodeResponseFuture());
        Map nodeResults = this.resolverResults.computeIfAbsent(requestId, r -> new LinkedHashMap());
        Iterable pendingResolvers = newInputNames.isEmpty() ? ((List)this.resolverDefinitionsByInput.getOrDefault(Optional.empty(), Collections.emptyList())).stream().filter(resolverDefinition -> !nodeResults.containsKey(resolverDefinition.resolverNodeLogicId()))::iterator : newInputNames.stream().flatMap(input -> ((List)this.resolverDefinitionsByInput.getOrDefault(Optional.ofNullable(input), (Object)ImmutableList.of())).stream().filter(resolverDefinition -> !nodeResults.containsKey(resolverDefinition.resolverNodeLogicId())))::iterator;
        LinkedHashMap<NodeLogicId, ResolverDefinition> uniquePendingResolvers = new LinkedHashMap<NodeLogicId, ResolverDefinition>();
        for (ResolverDefinition pendingResolver : pendingResolvers) {
            uniquePendingResolvers.putIfAbsent(pendingResolver.resolverNodeLogicId(), pendingResolver);
        }
        LinkedHashMap pendingResolverDefinitionsByResolvedDependency = new LinkedHashMap();
        uniquePendingResolvers.forEach((logicId, resolverDefinition) -> pendingResolverDefinitionsByResolvedDependency.computeIfAbsent(resolverDefinition.dependencyName(), k -> new ArrayList()).addAll((Collection)this.resolverDefinitionsByDependency.getOrDefault((Object)resolverDefinition.dependencyName(), (Object)ImmutableList.of())));
        int pendingResolverCount = 0;
        for (Map.Entry resolverDefinitions : pendingResolverDefinitionsByResolvedDependency.entrySet()) {
            String dependencyName = (String)resolverDefinitions.getKey();
            if (!((List)resolverDefinitions.getValue()).stream().allMatch(resolverDefinition -> allInputNames.containsAll((Collection<?>)resolverDefinition.boundFrom()))) continue;
            ++pendingResolverCount;
            ArrayList<ResolverCommand> resolverCommands = new ArrayList<ResolverCommand>();
            LinkedHashMap<ImmutableSet<String>, ImmutableList<Inputs>> result = new LinkedHashMap<ImmutableSet<String>, ImmutableList<Inputs>>();
            for (ResolverDefinition resolverDefinition2 : (List)resolverDefinitions.getValue()) {
                ImmutableSet<String> boundFrom = resolverDefinition2.boundFrom();
                NodeLogicId nodeLogicId = resolverDefinition2.resolverNodeLogicId();
                Inputs inputs = new Inputs(Maps.filterKeys((Map)allInputs.values(), arg_0 -> boundFrom.contains(arg_0)));
                ResolverCommand resolverCommand2 = this.nodeDefinition.nodeDefinitionRegistry().logicDefinitionRegistry().getResolver(nodeLogicId).resolve(inputs);
                resolverCommands.add(resolverCommand2);
                nodeResults.put(nodeLogicId, ImmutableList.of((Object)resolverCommand2));
                result.put(resolverDefinition2.resolvedInputNames(), resolverCommand2.getInputs());
            }
            NodeId depNodeId2 = (NodeId)this.nodeDefinition.dependencyNodes().get((Object)dependencyName);
            if (resolverCommands.size() > 0 && resolverCommands.stream().allMatch(resolverCommand -> resolverCommand instanceof ResolverCommand.SkipDependency)) {
                if (allInputs.values().get(dependencyName) != null) continue;
                this.krystalNodeExecutor.enqueueCommand(new SkipNode(depNodeId2, requestId.append("skip(%s)".formatted(dependencyName)), (ResolverCommand.SkipDependency)resolverCommands.get(0)));
                this.executeCommand(new ExecuteWithDependency(this.nodeId, dependencyName, (Results<Object>)new Results((Map)ImmutableMap.of()), requestId));
                continue;
            }
            ImmutableList<Inputs> inputPermutations = this.createInputPermutations(result);
            int counter = 0;
            LinkedHashMap<Inputs, NodeResponseFuture> nodeResponseFutures = new LinkedHashMap<Inputs, NodeResponseFuture>();
            for (Inputs resolverInput : inputPermutations) {
                RequestId dependencyRequestId = requestId.append("%s[%s]".formatted(dependencyName, counter++));
                NodeResponseFuture nodeResponseFuture = this.krystalNodeExecutor.enqueueCommand(new ExecuteWithAllInputs(depNodeId2, resolverInput, dependencyRequestId));
                nodeResponseFutures.put(resolverInput, nodeResponseFuture);
            }
            CompletableFuture.allOf((CompletableFuture[])nodeResponseFutures.values().stream().map(NodeResponseFuture::responseFuture).toArray(CompletableFuture[]::new)).whenComplete((unused, throwable) -> {
                LinkedHashMap<Inputs, ValueOrError<Object>> results = new LinkedHashMap<Inputs, ValueOrError<Object>>();
                if (throwable != null) {
                    results.putAll((Map)inputPermutations.stream().collect(ImmutableMap.toImmutableMap(Function.identity(), k -> ValueOrError.error((Throwable)throwable))));
                } else {
                    for (Map.Entry nodeResponseFuture : nodeResponseFutures.entrySet()) {
                        ValueOrError<Object> now = ((NodeResponseFuture)nodeResponseFuture.getValue()).responseFuture().getNow((ValueOrError<Object>)ValueOrError.empty());
                        results.put((Inputs)nodeResponseFuture.getKey(), now);
                    }
                }
                this.krystalNodeExecutor.enqueueCommand(new ExecuteWithDependency(this.nodeId, dependencyName, (Results<Object>)new Results(results), requestId));
            });
        }
        boolean executeMainLogic = false;
        if (pendingResolverCount == 0) {
            ImmutableSet inputNames = mainLogicNodeDefinition.inputNames();
            if (this.inputsValueCollector.getOrDefault(requestId, (Map<String, InputValue<Object>>)ImmutableMap.of()).keySet().containsAll((Collection<?>)inputNames)) {
                executeMainLogic = true;
            }
        }
        return executeMainLogic;
    }

    private void executeMainLogic(NodeResponseFuture resultForRequest, RequestId requestId) {
        CompletionStage<Object> result;
        NodeLogicId mainLogicNode = this.nodeDefinition.mainLogicNode();
        MainLogicDefinition<Object> mainLogicDefinition = this.nodeDefinition.nodeDefinitionRegistry().logicDefinitionRegistry().getMain(mainLogicNode);
        Map<String, InputValue<Object>> allInputs = this.inputsValueCollector.getOrDefault(requestId, (Map<String, InputValue<Object>>)ImmutableMap.of());
        Inputs nonDependencyInputs = new Inputs(Maps.filterKeys(allInputs, input -> !this.nodeDefinition.dependencyNodes().containsKey(input)));
        CompletableFuture<ValueOrError<Object>> responseFuture = this.resultsCache.get(nonDependencyInputs);
        if (responseFuture == null) {
            result = this.executeDecoratedMainLogic(new Inputs(allInputs), mainLogicDefinition).handle(ValueOrError::valueOrError);
            this.resultsCache.put(nonDependencyInputs, (CompletableFuture<ValueOrError<Object>>)result);
        } else {
            result = responseFuture;
        }
        result.whenComplete((value, throwable) -> {
            if (throwable != null) {
                value = ValueOrError.error((Throwable)throwable);
            }
            this.resultsCache.computeIfPresent(nonDependencyInputs, (i, f) -> {
                Futures.propagateCompletion((CompletableFuture)result, (CompletableFuture)f);
                return f;
            });
            resultForRequest.responseFuture().complete((ValueOrError<Object>)value);
        });
    }

    private CompletableFuture<Object> executeDecoratedMainLogic(Inputs inputs, MainLogicDefinition<Object> mainLogicDefinition) {
        LinkedHashMap<String, MainLogicDecorator> decorators = new LinkedHashMap<String, MainLogicDecorator>(mainLogicDefinition.getSessionScopedLogicDecorators());
        decorators.putAll((Map<String, MainLogicDecorator>)this.requestScopedMainLogicDecorators);
        TreeSet sortedDecorators = new TreeSet(this.logicDecorationOrdering.decorationOrder());
        sortedDecorators.addAll(decorators.values());
        MainLogic logic = mainLogicDefinition::execute;
        for (MainLogicDecorator mainLogicDecorator : sortedDecorators) {
            logic = mainLogicDecorator.decorateLogic(logic);
        }
        return (CompletableFuture)logic.execute((ImmutableList<Inputs>)ImmutableList.of((Object)inputs)).get((Object)inputs);
    }

    private ImmutableList<Inputs> createInputPermutations(Map<ImmutableSet<String>, ImmutableList<Inputs>> inputValues) {
        ImmutableList<Inputs> subPermutation;
        Set<ImmutableSet<String>> inputNames = inputValues.keySet();
        if (inputNames.isEmpty()) {
            return ImmutableList.of((Object)Inputs.empty());
        }
        ImmutableSet<String> currentInputNames = inputNames.iterator().next();
        ImmutableList currentValues = inputValues.get(currentInputNames);
        if (currentValues == null || currentValues.isEmpty()) {
            currentValues = ImmutableList.of((Object)new Inputs((Map)currentInputNames.stream().collect(ImmutableMap.toImmutableMap(Function.identity(), k -> ValueOrError.empty()))));
        }
        if ((subPermutation = this.createInputPermutations(Maps.filterKeys(inputValues, key -> !currentInputNames.equals(key)))).isEmpty()) {
            return currentValues;
        }
        ImmutableList.Builder result = ImmutableList.builderWithExpectedSize((int)(currentValues.size() * subPermutation.size()));
        for (Inputs currentValue : currentValues) {
            for (Inputs subInputs : subPermutation) {
                LinkedHashMap map = new LinkedHashMap();
                map.putAll(currentValue.values());
                map.putAll(subInputs.values());
                result.add((Object)new Inputs(map));
            }
        }
        return result.build();
    }

    private static ImmutableMap<Optional<String>, List<ResolverDefinition>> createResolverDefinitionsByInputs(ImmutableList<ResolverDefinition> resolverDefinitions) {
        LinkedHashMap resolverDefinitionsByInput = new LinkedHashMap();
        resolverDefinitions.forEach(resolverDefinition -> {
            if (!resolverDefinition.boundFrom().isEmpty()) {
                resolverDefinition.boundFrom().forEach(input -> resolverDefinitionsByInput.computeIfAbsent(Optional.of(input), s -> new ArrayList()).add(resolverDefinition));
            } else {
                resolverDefinitionsByInput.computeIfAbsent(Optional.empty(), s -> new ArrayList()).add(resolverDefinition);
            }
        });
        return ImmutableMap.copyOf(resolverDefinitionsByInput);
    }

    private static ImmutableMap<String, List<ResolverDefinition>> createResolverDefinitionsByDependency(ImmutableList<ResolverDefinition> resolverDefinitions) {
        LinkedHashMap resolverDefinitionsByInput = new LinkedHashMap();
        resolverDefinitions.forEach(resolverDefinition -> resolverDefinitionsByInput.computeIfAbsent(resolverDefinition.dependencyName(), s -> new ArrayList()).add(resolverDefinition));
        return ImmutableMap.copyOf(resolverDefinitionsByInput);
    }
}

