/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.krystex.decorators;

import com.flipkart.krystal.config.ConfigProvider;
import com.flipkart.krystal.krystex.MainLogic;
import com.flipkart.krystal.krystex.decoration.MainLogicDecorator;
import io.github.resilience4j.circuitbreaker.CircuitBreaker;
import io.github.resilience4j.circuitbreaker.CircuitBreakerConfig;
import io.github.resilience4j.circuitbreaker.internal.CircuitBreakerStateMachine;
import io.github.resilience4j.decorators.Decorators;
import java.util.Optional;

public final class Resilience4JCircuitBreaker
implements MainLogicDecorator {
    public static final String DECORATOR_TYPE = Resilience4JCircuitBreaker.class.getName();
    private final String instanceId;
    private CircuitBreaker circuitBreaker;

    public Resilience4JCircuitBreaker(String instanceId) {
        this.instanceId = instanceId;
    }

    @Override
    public MainLogic<Object> decorateLogic(MainLogic<Object> logicToDecorate) {
        CircuitBreaker circuitBreaker = this.circuitBreaker;
        if (circuitBreaker != null) {
            return arg_0 -> ((Decorators.DecorateFunction)Decorators.ofFunction(logicToDecorate::execute).withCircuitBreaker(circuitBreaker)).apply(arg_0);
        }
        return logicToDecorate;
    }

    public void onConfigUpdate(ConfigProvider configProvider) {
        this.updateCircuitBreaker(configProvider);
    }

    @Override
    public String getId() {
        return this.instanceId;
    }

    private void init(ConfigProvider configProvider) {
        this.circuitBreaker = this.getCircuitBreakerConfig(configProvider).map(config -> new CircuitBreakerStateMachine(this.instanceId + ".circuit_breaker", config)).orElse(null);
    }

    private Optional<CircuitBreakerConfig> getCircuitBreakerConfig(ConfigProvider configProvider) {
        boolean circuitBreakerEnabled = configProvider.getConfig(this.instanceId + ".circuit_breaker.enabled").orElse(true);
        if (!circuitBreakerEnabled) {
            return Optional.empty();
        }
        return Optional.of(CircuitBreakerConfig.ofDefaults());
    }

    private void updateCircuitBreaker(ConfigProvider configProvider) {
        CircuitBreaker circuitBreaker = this.circuitBreaker;
        Optional<CircuitBreakerConfig> newConfig = this.getCircuitBreakerConfig(configProvider);
        if (!Optional.ofNullable(circuitBreaker).map(CircuitBreaker::getCircuitBreakerConfig).equals(newConfig)) {
            this.init(configProvider);
        }
    }
}

