/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.krystex.node;

import com.flipkart.krystal.data.Inputs;
import com.flipkart.krystal.krystex.KrystalExecutor;
import com.flipkart.krystal.krystex.MainLogicDefinition;
import com.flipkart.krystal.krystex.RequestId;
import com.flipkart.krystal.krystex.SingleThreadExecutorPool;
import com.flipkart.krystal.krystex.commands.ExecuteWithInputs;
import com.flipkart.krystal.krystex.commands.Flush;
import com.flipkart.krystal.krystex.commands.NodeRequestCommand;
import com.flipkart.krystal.krystex.decoration.InitiateActiveDepChains;
import com.flipkart.krystal.krystex.decoration.LogicDecorationOrdering;
import com.flipkart.krystal.krystex.decoration.LogicExecutionContext;
import com.flipkart.krystal.krystex.decoration.MainLogicDecorator;
import com.flipkart.krystal.krystex.decoration.MainLogicDecoratorConfig;
import com.flipkart.krystal.krystex.node.DependantChain;
import com.flipkart.krystal.krystex.node.DependantChainStart;
import com.flipkart.krystal.krystex.node.Node;
import com.flipkart.krystal.krystex.node.NodeDefinition;
import com.flipkart.krystal.krystex.node.NodeDefinitionRegistry;
import com.flipkart.krystal.krystex.node.NodeId;
import com.flipkart.krystal.krystex.node.NodeRegistry;
import com.flipkart.krystal.krystex.node.NodeResponse;
import com.flipkart.krystal.utils.Futures;
import com.flipkart.krystal.utils.MultiLeasePool;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class KrystalNodeExecutor
implements KrystalExecutor {
    private static final Logger log = LoggerFactory.getLogger(KrystalNodeExecutor.class);
    private final NodeDefinitionRegistry nodeDefinitionRegistry;
    private final LogicDecorationOrdering logicDecorationOrdering;
    private final MultiLeasePool.Lease commandQueueLease;
    private final RequestId requestId;
    private final Map<String, Map<String, MainLogicDecorator>> requestScopedMainDecorators = new LinkedHashMap<String, Map<String, MainLogicDecorator>>();
    private final NodeRegistry nodeRegistry = new NodeRegistry();
    private volatile boolean closed;
    private final Map<RequestId, List<NodeExecutionInfo>> allRequests = new LinkedHashMap<RequestId, List<NodeExecutionInfo>>();
    private final Map<RequestId, List<NodeExecutionInfo>> unFlushedRequests = new LinkedHashMap<RequestId, List<NodeExecutionInfo>>();
    private final Map<NodeId, Set<DependantChain>> dependantChainsPerNode = new LinkedHashMap<NodeId, Set<DependantChain>>();

    public KrystalNodeExecutor(NodeDefinitionRegistry nodeDefinitionRegistry, LogicDecorationOrdering logicDecorationOrdering, SingleThreadExecutorPool commandQueuePool, String requestId) {
        this.nodeDefinitionRegistry = nodeDefinitionRegistry;
        this.logicDecorationOrdering = logicDecorationOrdering;
        this.commandQueueLease = commandQueuePool.lease();
        this.requestId = new RequestId(requestId);
    }

    private ImmutableMap<String, MainLogicDecorator> getRequestScopedDecorators(LogicExecutionContext logicExecutionContext) {
        NodeId nodeId = logicExecutionContext.nodeId();
        NodeDefinition nodeDefinition = this.nodeDefinitionRegistry.get(nodeId);
        MainLogicDefinition mainLogicDefinition = this.nodeDefinitionRegistry.logicDefinitionRegistry().getMain(nodeDefinition.mainLogicNode());
        LinkedHashMap decorators = new LinkedHashMap();
        mainLogicDefinition.getRequestScopedLogicDecoratorConfigs().forEach((decoratorType, decoratorConfig) -> {
            if (decoratorConfig.shouldDecorate().test(logicExecutionContext)) {
                String instanceId = decoratorConfig.instanceIdGenerator().apply(logicExecutionContext);
                MainLogicDecorator mainLogicDecorator = this.requestScopedMainDecorators.computeIfAbsent((String)decoratorType, k -> new LinkedHashMap()).computeIfAbsent(instanceId, k -> decoratorConfig.factory().apply(new MainLogicDecoratorConfig.DecoratorContext(instanceId, logicExecutionContext)));
                mainLogicDecorator.executeCommand(new InitiateActiveDepChains(nodeId, (ImmutableSet<DependantChain>)ImmutableSet.copyOf((Collection)this.dependantChainsPerNode.get(nodeId))));
                decorators.put(decoratorType, mainLogicDecorator);
            }
        });
        return ImmutableMap.copyOf(decorators);
    }

    @Override
    public <T> CompletableFuture<T> executeNode(NodeId nodeId, Inputs inputs) {
        return this.executeNode(nodeId, inputs, this.requestId);
    }

    @Override
    public <T> CompletableFuture<T> executeNode(NodeId nodeId, Inputs inputs, String requestId) {
        return this.executeNode(nodeId, inputs, new RequestId(requestId));
    }

    private CompletableFuture<?> executeNode(NodeId nodeId, Inputs inputs, RequestId requestId) {
        if (this.closed) {
            throw new RejectedExecutionException("KrystalNodeExecutor is already closed");
        }
        this.createDependantNodes(nodeId, DependantChainStart.instance());
        CompletableFuture<Object> future = new CompletableFuture<Object>();
        this.allRequests.computeIfAbsent(requestId, r -> new ArrayList()).add(new NodeExecutionInfo(nodeId, inputs, future));
        this.unFlushedRequests.computeIfAbsent(requestId, r -> new ArrayList()).add(new NodeExecutionInfo(nodeId, inputs, future));
        return future;
    }

    private void createDependantNodes(NodeId nodeId, DependantChain dependantChain) {
        NodeDefinition nodeDefinition = this.nodeDefinitionRegistry.get(nodeId);
        if (dependantChain.contains(nodeId)) {
            this.dependantChainsPerNode.computeIfAbsent(nodeId, k -> new LinkedHashSet()).add(dependantChain);
        } else {
            this.nodeRegistry.createIfAbsent(nodeId, n -> new Node(nodeDefinition, this, this::getRequestScopedDecorators, this.logicDecorationOrdering));
            ImmutableMap<String, NodeId> dependencyNodes = nodeDefinition.dependencyNodes();
            dependencyNodes.forEach((dependencyName, depNodeId) -> this.createDependantNodes((NodeId)depNodeId, DependantChain.from(nodeId, dependencyName, dependantChain)));
            this.dependantChainsPerNode.computeIfAbsent(nodeId, k -> new LinkedHashSet()).add(dependantChain);
        }
    }

    CompletableFuture<NodeResponse> enqueueCommand(NodeRequestCommand nodeCommand) {
        return CompletableFuture.supplyAsync(() -> this.nodeRegistry.get(nodeCommand.nodeId()).executeRequestCommand(nodeCommand), (Executor)this.commandQueueLease.get()).thenCompose(Function.identity());
    }

    void enqueueCommand(Flush flush) {
        CompletableFuture.runAsync(() -> this.nodeRegistry.get(flush.nodeId()).executeCommand(flush), (Executor)this.commandQueueLease.get());
    }

    @Override
    public void flush() {
        this.unFlushedRequests.forEach((requestId, nodeExecutionInfos) -> nodeExecutionInfos.forEach(nodeExecutionInfo -> {
            NodeId nodeId = nodeExecutionInfo.nodeId();
            if (nodeExecutionInfo.future().isDone()) {
                return;
            }
            NodeDefinition nodeDefinition = this.nodeDefinitionRegistry.get(nodeId);
            CompletionStage submissionResult = ((CompletableFuture)this.enqueueCommand(new ExecuteWithInputs(nodeId, (ImmutableSet<String>)((ImmutableSet)this.nodeDefinitionRegistry.logicDefinitionRegistry().getMain(nodeDefinition.mainLogicNode()).inputNames().stream().filter(s -> !nodeDefinition.dependencyNodes().containsKey(s)).collect(ImmutableSet.toImmutableSet())), nodeExecutionInfo.inputs(), DependantChainStart.instance(), (RequestId)requestId)).thenApply(NodeResponse::response)).thenApply(valueOrError -> {
                if (valueOrError.error().isPresent()) {
                    throw new RuntimeException((Throwable)valueOrError.error().get());
                }
                return valueOrError.value().orElse(null);
            });
            Futures.linkFutures((CompletableFuture)submissionResult, nodeExecutionInfo.future());
        }));
        this.unFlushedRequests.forEach((requestId, nodeExecutionInfos) -> nodeExecutionInfos.forEach(nodeExecutionInfo -> this.enqueueCommand(new Flush(nodeExecutionInfo.nodeId()))));
        this.unFlushedRequests.clear();
    }

    @Override
    public void close() {
        this.closed = true;
        this.flush();
        CompletableFuture.allOf((CompletableFuture[])this.allRequests.values().stream().flatMap(nodeExecutionInfos -> nodeExecutionInfos.stream().map(NodeExecutionInfo::future)).toArray(CompletableFuture[]::new)).whenComplete((unused, throwable) -> this.commandQueueLease.close());
    }

    private record NodeExecutionInfo(NodeId nodeId, Inputs inputs, CompletableFuture<Object> future) {
    }
}

