/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.krystex.node;

import com.flipkart.krystal.krystex.LogicDefinitionRegistry;
import com.flipkart.krystal.krystex.ResolverDefinition;
import com.flipkart.krystal.krystex.node.NodeDefinition;
import com.flipkart.krystal.krystex.node.NodeId;
import com.flipkart.krystal.krystex.node.NodeLogicId;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.LinkedHashMap;
import java.util.Map;

public final class NodeDefinitionRegistry {
    private final LogicDefinitionRegistry logicDefinitionRegistry;
    private final Map<NodeId, NodeDefinition> nodeDefinitions = new LinkedHashMap<NodeId, NodeDefinition>();

    public NodeDefinitionRegistry(LogicDefinitionRegistry logicDefinitionRegistry) {
        this.logicDefinitionRegistry = logicDefinitionRegistry;
    }

    public LogicDefinitionRegistry logicDefinitionRegistry() {
        return this.logicDefinitionRegistry;
    }

    public NodeDefinition get(NodeId nodeId) {
        NodeDefinition node = this.nodeDefinitions.get(nodeId);
        if (node == null) {
            throw new IllegalArgumentException("No Node with id %s found".formatted(nodeId));
        }
        return node;
    }

    public NodeDefinition newNodeDefinition(String nodeId, NodeLogicId logicNode) {
        return this.newNodeDefinition(nodeId, logicNode, (ImmutableMap<String, NodeId>)ImmutableMap.of());
    }

    public NodeDefinition newNodeDefinition(String nodeId, NodeLogicId logicNode, ImmutableMap<String, NodeId> dependencyNodes) {
        return this.newNodeDefinition(nodeId, logicNode, dependencyNodes, (ImmutableList<ResolverDefinition>)ImmutableList.of());
    }

    public NodeDefinition newNodeDefinition(String nodeId, NodeLogicId logicNode, ImmutableMap<String, NodeId> dependencyNodes, ImmutableList<ResolverDefinition> resolverDefinitions) {
        NodeDefinition nodeDefinition = new NodeDefinition(new NodeId(nodeId), logicNode, dependencyNodes, resolverDefinitions, this);
        this.nodeDefinitions.put(nodeDefinition.nodeId(), nodeDefinition);
        return nodeDefinition;
    }
}

