/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.krystex.logicdecorators.observability;

import org.checkerframework.checker.calledmethods.qual.CalledMethods;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.checker.optional.qual.MaybePresent;
import org.checkerframework.common.aliasing.qual.MaybeAliased;
import org.checkerframework.common.aliasing.qual.MaybeLeaked;
import org.checkerframework.common.returnsreceiver.qual.UnknownThis;

class GenerateHtml {
    GenerateHtml() {
    }

    public static @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent String generateHtml(@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent String jsonData) {
        return "<!DOCTYPE html>\n<html lang=\"en\">\n  <head>\n    <meta charset=\"UTF-8\" />\n    <meta name=\"viewport\" content=\"width=device-width, initial-scale=1.0\" />\n    <title>Collapsible Tree</title>\n    <script src=\"https://d3js.org/d3.v7.min.js\"></script>\n    <style>\n      body {\n        background-color: #edf2f8;\n      }\n      circle {\n        fill: #fff;\n        stroke: steelblue;\n        stroke-width: 1.5px;\n      }\n      text {\n        font: 10px sans-serif;\n      }\n      path.link {\n        fill: none;\n        stroke: #ccc;\n        stroke-width: 1.5px;\n      }\n      .clicked circle {\n        fill: #313bac;\n      }\n      #details {\n        margin-top: 40px;\n        overflow: scroll;\n        padding: 10px 10px 0;\n        box-shadow: 0 0 20px rgba(0, 0, 0, 0.2);\n        border-radius: 15px;\n        display: none;\n      }\n      .json-node {\n        margin-left: 20px;\n      }\n      .json-key {\n        font-weight: bold;\n        margin-right: 5px;\n      }\n      .toggle-button {\n        margin-right: 5px;\n      }\n      .json-children {\n        display: none;\n      }\n      .json-node.open .json-children {\n        display: block;\n      }\n    </style>\n  </head>\n  <body>\n    <div id=\"tree-container\">\n      <svg id=\"svg-container\"></svg>\n      <div id=\"details\"></div>\n    </div>\n    <script src=\"https://cdn.rawgit.com/caldwell/renderjson/master/renderjson.js\"></script>\n    <script>\n      const data =\n" + jsonData + "        ;\n        const width = 1000;\n        const marginTop = 10;\n        const marginRight = 10;\n        const marginBottom = 10;\n        const marginLeft = 150;\n        // Rows are separated by dx pixels, columns by dy pixels. These names can be counter-intuitive\n        // (dx is a height, and dy a width). This because the tree must be viewed with the root at the\n        // \u201cbottom\u201d, in the data domain. The width of a column is based on the tree\u2019s height.\n        const root = d3.hierarchy(transformDataToHierarchy(data));\n        const dx = 20;\n        const dy = (width - marginRight - marginLeft) / (1 + root.height);\n        // Define the tree layout and the shape for links.\n        const tree = d3.tree().nodeSize([dx, dy]);\n        const diagonal = d3\n          .linkHorizontal()\n          .x((d) => d.y)\n          .y((d) => d.x);\n        // Create the SVG container, a layer for the links and a layer for the nodes.\n        const svg = d3\n          .select(\"#svg-container\")\n          .attr(\"width\", width)\n          .attr(\"height\", dx)\n          .attr(\"viewBox\", [-marginLeft, -marginTop, width, dx])\n          .attr(\n            \"style\",\n            \"max-width: 100%; height: auto; font: 10px sans-serif; user-select: none;\"\n          );\n        const gLink = svg\n          .append(\"g\")\n          .attr(\"fill\", \"none\")\n          .attr(\"stroke\", \"#555\")\n          .attr(\"stroke-opacity\", 0.4)\n          .attr(\"stroke-width\", 1.5);\n        const gNode = svg\n          .append(\"g\")\n          .attr(\"cursor\", \"pointer\")\n          .attr(\"pointer-events\", \"all\");\n        function update(event, source) {\n          const duration = event?.altKey ? 2500 : 250; // hold the alt key to slow down the transition\n          const nodes = root.descendants().reverse();\n          const links = root.links();\n          // Compute the new tree layout.\n          tree(root);\n          let left = root;\n          let right = root;\n          root.eachBefore((node) => {\n            if (node.x < left.x) left = node;\n            if (node.x > right.x) right = node;\n          });\n          const height = right.x - left.x + marginTop + marginBottom;\n          const transition = svg\n            .transition()\n            .duration(duration)\n            .attr(\"height\", height)\n            .attr(\"viewBox\", [-marginLeft, left.x - marginTop, width, height])\n            .tween(\n              \"resize\",\n              window.ResizeObserver ? null : () => () => svg.dispatch(\"toggle\")\n            );\n          // Update the nodes\u2026\n          const node = gNode.selectAll(\"g\").data(nodes, (d) => d.id);\n          // Enter any new nodes at the parent's previous position.\n          const nodeEnter = node\n            .enter()\n            .append(\"g\")\n            .attr(\"transform\", (d) => `translate(${source.y0},${source.x0})`)\n            .attr(\"fill-opacity\", 0)\n            .attr(\"stroke-opacity\", 0)\n            .on(\"click\", (event, d) => {\n              d.children = d.children ? null : d._children;\n              update(event, d);\n              renderDetails(d.data.value);\n              svg.selectAll(\".clicked\").classed(\"clicked\", false);\n              d3.select(event.currentTarget).classed(\"clicked\", true);\n            });\n          nodeEnter\n            .append(\"circle\")\n            .attr(\"r\", 5)\n            .attr(\"fill\", (d) => (d._children ? \"#555\" : \"#999\"))\n            .attr(\"stroke-width\", 10);\n          nodeEnter\n            .append(\"text\")\n            .attr(\"dy\", \"0.31em\")\n            .attr(\"x\", (d) => (d._children ? -6 : 6))\n            .attr(\"text-anchor\", (d) => (d._children ? \"end\" : \"start\"))\n            .text((d) => {\n              const originalText = d.data.name;\n              return originalText.length > 10\n                ? `${originalText.substring(0, d.data.name.indexOf(\"(\"))}`\n                : originalText;\n            })\n            .clone(true)\n            .lower()\n            .attr(\"stroke-linejoin\", \"round\")\n            .attr(\"stroke-width\", 3)\n            .attr(\"stroke\", \"white\");\n          // Transition nodes to their new position.\n          const nodeUpdate = node\n            .merge(nodeEnter)\n            .transition(transition)\n            .attr(\"transform\", (d) => `translate(${d.y},${d.x})`)\n            .attr(\"fill-opacity\", 1)\n            .attr(\"stroke-opacity\", 1);\n          // Transition exiting nodes to the parent's new position.\n          const nodeExit = node\n            .exit()\n            .transition(transition)\n            .remove()\n            .attr(\"transform\", (d) => `translate(${source.y},${source.x})`)\n            .attr(\"fill-opacity\", 0)\n            .attr(\"stroke-opacity\", 0);\n          // Update the links\u2026\n          const link = gLink.selectAll(\"path\").data(links, (d) => d.target.id);\n          // Enter any new links at the parent's previous position.\n          const linkEnter = link\n            .enter()\n            .append(\"path\")\n            .attr(\"d\", (d) => {\n              const o = { x: source.x0, y: source.y0 };\n              return diagonal({ source: o, target: o });\n            });\n          // Transition links to their new position.\n          link.merge(linkEnter).transition(transition).attr(\"d\", diagonal);\n          // Transition exiting nodes to the parent's new position.\n          link\n            .exit()\n            .transition(transition)\n            .remove()\n            .attr(\"d\", (d) => {\n              const o = { x: source.x, y: source.y };\n              return diagonal({ source: o, target: o });\n            });\n          // Stash the old positions for transition.\n          root.eachBefore((d) => {\n            d.x0 = d.x;\n            d.y0 = d.y;\n          });\n        }\n        // Do the first update to the initial configuration of the tree \u2014 where a number of nodes\n        // are open (arbitrarily selected as the root, plus nodes with 7 letters).\n        root.x0 = dy / 2;\n        root.y0 = 0;\n        root.descendants().forEach((d, i) => {\n          d.id = i;\n          d._children = d.children;\n          if (d.depth && d.data.name.length !== 7) d.children = null;\n        });\n        update(null, root);\n        //Logic for getting root node\n        function valueInsideParentheses(key) {\n          const openingIndex = key.indexOf(\"[\");\n          const closingIndex = key.lastIndexOf(\"]\");\n          const valueInsideParentheses = key.substring(\n            openingIndex + 1,\n            closingIndex\n          );\n          return valueInsideParentheses;\n        }\n        function compareName(parentChainKey, childChainKey) {\n          const parentName = parentChainKey.substring(\n            0,\n            parentChainKey.indexOf(\"(\")\n          );\n          const childName = childChainKey.substring(\n            0,\n            childChainKey.indexOf(\"(\")\n          );\n          if (parentName !== childName) {\n            return false;\n          }\n          return true;\n        }\n        function compareInputs(parentChainKey, childChainKey) {\n          const parentInputs = valueInsideParentheses(parentChainKey);\n          const childInputs = valueInsideParentheses(childChainKey);\n          return matchInputs(parentInputs, childInputs);\n        }\n        function compareNameAndInputs(parentChainKey, childChainKey) {\n          return (\n            compareName(parentChainKey, childChainKey) &&\n            compareInputs(parentChainKey, childChainKey)\n          );\n        }\n        function matchInputs(parentInputs, childInputs) {\n          let completeMatch = true;\n          for (const [parentKey, parentValue] of Object.entries(\n            parentInputs\n          )) {\n            let match = false;\n            for (const [childKey, childValue] of Object.entries(\n              childInputs\n            )) {\n              if (parentKey === childKey && parentValue === childValue) {\n                match = true;\n                break;\n              }\n            }\n            if (match === false) {\n              completeMatch = false;\n              break;\n            }\n          }\n          return completeMatch;\n        }\n        function filterInput(key) {\n          const openingIndex = key.indexOf(\"[\");\n          const closingIndex = key.lastIndexOf(\"]\");\n          const inputValues = key.substring(openingIndex + 1, closingIndex);\n          return inputValues;\n        }\n        function findingRootNode(data) {\n          const mySet = new Set();\n          Object.keys(data.mainLogicExecInfos).forEach((parentChainKey) => {\n            findDependency(parentChainKey, mySet);\n          });\n          for (const parentChainKey of Object.keys(data.mainLogicExecInfos)) {\n            if (!mySet.has(parentChainKey)) {\n              return parentChainKey;\n            }\n          }\n        }\n        function findDependency(parentChainkey, mySet) {\n          Object.keys(data.mainLogicExecInfos).forEach((childChainKey) => {\n            if (!compareNameAndInputs(parentChainkey, childChainKey)) {\n              const mainData = data.mainLogicExecInfos[childChainKey];\n              mainData.dependencyResults &&\n                Object.values(\n                  data.mainLogicExecInfos[childChainKey].dependencyResults[0]\n                ).forEach((dependencyValue) => {\n                  if (\n                    matchInputs(\n                      filterInput(parentChainkey),\n                      Object.keys(dependencyValue)[0]\n                    )\n                  ) {\n                    mySet.add(parentChainkey);\n                  }\n                });\n            }\n          });\n        }\n        function buildTree(data, rootNode, rootNodeName) {\n          if (\n            data.mainLogicExecInfos &&\n            data.mainLogicExecInfos[rootNodeName] &&\n            data.mainLogicExecInfos[rootNodeName].dependencyResults &&\n            data.mainLogicExecInfos[rootNodeName].dependencyResults[0]\n          ) {\n            Object.values(\n              data.mainLogicExecInfos[rootNodeName].dependencyResults[0]\n            ).forEach((dependencyKey) => {\n              if (dependencyKey) {\n                let dependencyKeyName = Object.keys(dependencyKey)[0];\n                if (dependencyKeyName) {\n                  let chainNode;\n                  Object.keys(data.mainLogicExecInfos).forEach((parentKey) => {\n                    if (\n                      matchInputs(filterInput(parentKey), dependencyKeyName) \n                    ) {\n                      chainNode = {\n                        name: parentKey,\n                        children: [],\n                        value: JSON.stringify(data.mainLogicExecInfos[parentKey]),\n                      };\n                      rootNode.children.push(chainNode);\n                      buildTree(data, chainNode, parentKey);\n                    }\n                  });\n                }\n              }\n            });\n          }\n          return rootNode;\n        }\n        // Transform actual data for d3 Logic\n        function transformDataToHierarchy(data) {\n          const rootNodeName = findingRootNode(data);\n          const rootNode = {\n            name: rootNodeName,\n            children: [],\n            value: JSON.stringify(data.mainLogicExecInfos[rootNodeName]),\n          };\n          return buildTree(data, rootNode, rootNodeName);\n        }\n        // Function for rendring Json data in tree format\n        function renderJsonData(data) {\n          return Object.entries(data)\n            .map(([key, value]) => {\n              const isObject = typeof value === \"object\" && value !== null;\n              const isArray = Array.isArray(value);\n              const hasChildren = isObject && Object.keys(value).length > 0;\n              const toggleButton = hasChildren\n                ? `<button class=\"toggle-button\" onclick=\"toggle(this)\">+</button>`\n                : \"\";\n              return `\n              <div class=\"json-node\" style=\"display: flex; gap: 5px\">\n                <div class=\"json-key\">${key}: </div>\n                <div class=\"json-value\">\n                  ${isObject ? toggleButton : \"\"}\n                  ${isObject && !isArray ? \"\" : value}\n                </div>\n                <div class=\"json-children\" style=\"display: \n                  ${hasChildren ? \"none\" : \"block\"\n                }\">\n                  ${hasChildren && !isArray ? renderJsonData(value) : \"\"}\n                </div>\n              </div>\n            `;\n            })\n            .join(\"\");\n        }\n        function toggle(button) {\n          const parent = button.parentElement.nextElementSibling;\n          const isOpen = parent.style.display === \"block\";\n          parent.style.display = isOpen ? \"none\" : \"block\";\n          button.textContent = isOpen ? \"-\" : \"+\";\n        }\n        // Function for rendring details box\n        function updateInputList(data, map) {\n          data.map((item) => {\n            for (const key in item) {\n              if (typeof item[key] == \"object\") {\n                updateInputList([item[key]], map);\n              } else {\n                item[key] = map[item[key]];\n              }\n            }\n          });\n          return data;\n        }\n        function renderDetails(nodeData) {\n          const customBox = document.getElementById(\"details\");\n          const formattedData = Object.entries(JSON.parse(nodeData))\n            .map(([key, value]) => {\n              let reqValue;\n              if (key === \"result\") {\n                reqValue = data.dataMap[value];\n              } else if (key === \"inputsList\") {\n                reqValue = updateInputList(value, data.dataMap);\n              } else if (key === \"dependencyResults\") {\n                reqValue = updateInputList(value, data.dataMap);\n              } else {\n                reqValue = value;\n              }\n              return `\n                  <div style=\"display: flex; margin-bottom: 8px;\">\n                      <div style=\"font-weight: bold; margin-right: 8px;\">${key}:</div>\n                      <div>\n                        ${typeof reqValue == \"object\"\n                          ? renderJsonData(reqValue)\n                          : reqValue}\n                      </div>\n                  </div>\n              `;\n            })\n            .join(\"\");\n          customBox.innerHTML = formattedData;\n          customBox.style.display = \"block\";\n        }\n      </script>\n    </body>\n  </html>\n";
    }
}

