/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.krystex.node;

import com.flipkart.krystal.data.InputValue;
import com.flipkart.krystal.data.Inputs;
import com.flipkart.krystal.data.Results;
import com.flipkart.krystal.data.ValueOrError;
import com.flipkart.krystal.krystex.ComputeLogicDefinition;
import com.flipkart.krystal.krystex.IOLogicDefinition;
import com.flipkart.krystal.krystex.MainLogic;
import com.flipkart.krystal.krystex.MainLogicDefinition;
import com.flipkart.krystal.krystex.commands.BatchCommand;
import com.flipkart.krystal.krystex.commands.DependencyCallbackBatch;
import com.flipkart.krystal.krystex.commands.ExecuteWithDependency;
import com.flipkart.krystal.krystex.commands.ExecuteWithInputs;
import com.flipkart.krystal.krystex.commands.Flush;
import com.flipkart.krystal.krystex.commands.NodeInputBatch;
import com.flipkart.krystal.krystex.commands.NodeInputCommand;
import com.flipkart.krystal.krystex.commands.NodeRequestCommand;
import com.flipkart.krystal.krystex.commands.SkipNode;
import com.flipkart.krystal.krystex.decoration.FlushCommand;
import com.flipkart.krystal.krystex.decoration.LogicDecorationOrdering;
import com.flipkart.krystal.krystex.decoration.LogicExecutionContext;
import com.flipkart.krystal.krystex.decoration.MainLogicDecorator;
import com.flipkart.krystal.krystex.node.DefaultDependantChain;
import com.flipkart.krystal.krystex.node.DependantChain;
import com.flipkart.krystal.krystex.node.DependantChainStart;
import com.flipkart.krystal.krystex.node.DuplicateRequestException;
import com.flipkart.krystal.krystex.node.KrystalNodeExecutor;
import com.flipkart.krystal.krystex.node.NodeBatchResponse;
import com.flipkart.krystal.krystex.node.NodeDefinition;
import com.flipkart.krystal.krystex.node.NodeId;
import com.flipkart.krystal.krystex.node.NodeLogicId;
import com.flipkart.krystal.krystex.node.NodeMetrics;
import com.flipkart.krystal.krystex.node.NodeResponse;
import com.flipkart.krystal.krystex.request.RequestId;
import com.flipkart.krystal.krystex.resolution.DependencyResolutionRequest;
import com.flipkart.krystal.krystex.resolution.MultiResolver;
import com.flipkart.krystal.krystex.resolution.MultiResolverDefinition;
import com.flipkart.krystal.krystex.resolution.ResolverCommand;
import com.flipkart.krystal.krystex.resolution.ResolverDefinition;
import com.flipkart.krystal.utils.Futures;
import com.flipkart.krystal.utils.ImmutableMapView;
import com.flipkart.krystal.utils.SkippedExecutionException;
import com.google.common.base.Functions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.LongAdder;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;

class Node {
    private static final long TIMEOUT_MS = 1000000L;
    private final NodeId nodeId;
    private final NodeDefinition nodeDefinition;
    private final KrystalNodeExecutor krystalNodeExecutor;
    private final Function<LogicExecutionContext, ImmutableMap<String, MainLogicDecorator>> requestScopedDecoratorsSupplier;
    private final ImmutableMapView<Optional<String>, List<ResolverDefinition>> resolverDefinitionsByInput;
    private final ImmutableMapView<String, ImmutableSet<ResolverDefinition>> resolverDefinitionsByDependencies;
    private final KrystalNodeExecutor.ResolverExecStrategy resolverExecStrategy;
    private final LogicDecorationOrdering logicDecorationOrdering;
    private final Map<RequestId, Map<String, DependencyNodeExecutions>> dependencyExecutions = new LinkedHashMap<RequestId, Map<String, DependencyNodeExecutions>>();
    private final Map<RequestId, Map<String, InputValue<Object>>> inputsValueCollector = new LinkedHashMap<RequestId, Map<String, InputValue<Object>>>();
    private final Map<RequestId, Map<String, Results<Object>>> dependencyValuesCollector = new LinkedHashMap<RequestId, Map<String, Results<Object>>>();
    private final Map<DependantChain, Set<String>> collectedInputNames = new LinkedHashMap<DependantChain, Set<String>>();
    private final Map<RequestId, CompletableFuture<NodeResponse>> resultsByRequest = new LinkedHashMap<RequestId, CompletableFuture<NodeResponse>>();
    private final Map<DependantChain, CompletableFuture<NodeBatchResponse>> resultsByBatch = new LinkedHashMap<DependantChain, CompletableFuture<NodeBatchResponse>>();
    private final Map<Inputs, CompletableFuture<Object>> resultsCache = new LinkedHashMap<Inputs, CompletableFuture<Object>>();
    private final Map<RequestId, Boolean> mainLogicExecuted = new LinkedHashMap<RequestId, Boolean>();
    private final Map<RequestId, Optional<SkipNode>> skipLogicRequested = new LinkedHashMap<RequestId, Optional<SkipNode>>();
    private final Map<RequestId, Map<ResolverDefinition, ResolverCommand>> resolverResults = new LinkedHashMap<RequestId, Map<ResolverDefinition, ResolverCommand>>();
    private final Map<DependantChain, Boolean> flushedDependantChain = new LinkedHashMap<DependantChain, Boolean>();
    private final Map<DependantChain, Set<RequestId>> requestsByDependantChain = new LinkedHashMap<DependantChain, Set<RequestId>>();
    private final Map<RequestId, DependantChain> dependantChainByRequest = new LinkedHashMap<RequestId, DependantChain>();
    private final KrystalNodeExecutor.DependencyExecStrategy dependencyExecStrategy;
    private final NodeMetrics nodeMetrics;

    Node(NodeDefinition nodeDefinition, KrystalNodeExecutor krystalNodeExecutor, Function<LogicExecutionContext, ImmutableMap<String, MainLogicDecorator>> requestScopedDecoratorsSupplier, LogicDecorationOrdering logicDecorationOrdering, KrystalNodeExecutor.DependencyExecStrategy dependencyExecStrategy, KrystalNodeExecutor.ResolverExecStrategy resolverExecStrategy, NodeMetrics nodeMetrics) {
        this.dependencyExecStrategy = dependencyExecStrategy;
        this.nodeId = nodeDefinition.nodeId();
        this.nodeDefinition = nodeDefinition;
        this.krystalNodeExecutor = krystalNodeExecutor;
        this.requestScopedDecoratorsSupplier = requestScopedDecoratorsSupplier;
        this.logicDecorationOrdering = logicDecorationOrdering;
        this.resolverDefinitionsByInput = Node.createResolverDefinitionsByInputs(nodeDefinition.resolverDefinitions());
        this.resolverDefinitionsByDependencies = ImmutableMapView.viewOf(nodeDefinition.resolverDefinitions().stream().collect(Collectors.groupingBy(ResolverDefinition::dependencyName, ImmutableSet.toImmutableSet())));
        this.nodeMetrics = nodeMetrics;
        this.resolverExecStrategy = resolverExecStrategy;
    }

    void executeCommand(Flush nodeCommand) {
        this.flushedDependantChain.put(nodeCommand.nodeDependants(), true);
        this.flushAllDependenciesIfNeeded(nodeCommand.nodeDependants());
        this.flushDecoratorsIfNeeded(nodeCommand.nodeDependants());
    }

    CompletableFuture<NodeResponse> executeRequestCommand(NodeRequestCommand nodeCommand) {
        return this.measuringTimeTaken(() -> {
            RequestId requestId = nodeCommand.requestId();
            CompletableFuture resultForRequest = this.resultsByRequest.computeIfAbsent(requestId, r -> new CompletableFuture());
            if (resultForRequest.isDone()) {
                return resultForRequest;
            }
            try {
                if (nodeCommand instanceof SkipNode) {
                    SkipNode skipNode = (SkipNode)nodeCommand;
                    resultForRequest.completeExceptionally((Throwable)Node.skipNodeException(skipNode));
                }
                List<NodeInputCommand> nodeRequestCommands = this.computeNodeCommands(nodeCommand);
                this.propagateCommands(requestId, nodeRequestCommands);
                if (nodeRequestCommands.isEmpty()) {
                    this.executeMainLogicIfPossible(requestId).ifPresent(mainLogicResult -> Futures.linkFutures((CompletableFuture)mainLogicResult, (CompletableFuture)resultForRequest));
                }
            }
            catch (Throwable e) {
                resultForRequest.completeExceptionally(e);
            }
            return resultForRequest;
        }, (Duration timeTaken) -> this.nodeMetrics.totalNodeTimeNs(timeTaken.toNanos()));
    }

    CompletableFuture<NodeBatchResponse> executeBatchCommand(BatchCommand<?> nodeInputBatchCommand) {
        return this.measuringTimeTaken(() -> {
            if (nodeInputBatchCommand instanceof DependencyCallbackBatch) {
                this.nodeMetrics.depCallbackBatchCount();
            } else if (nodeInputBatchCommand instanceof NodeInputBatch) {
                this.nodeMetrics.nodeInputsBatchCount();
            }
            Map subCommands = nodeInputBatchCommand.subCommands();
            CompletableFuture batchFuture = this.resultsByBatch.computeIfAbsent(nodeInputBatchCommand.dependantChain(), requestId -> new CompletableFuture());
            if (batchFuture.isDone()) {
                return batchFuture;
            }
            try {
                Map<String, Map<RequestId, List<NodeInputCommand>>> outgoingCommandsByDep = this.computeNodeCommands(nodeInputBatchCommand);
                this.propagateCommands(nodeInputBatchCommand, outgoingCommandsByDep);
                LinkedHashMap<RequestId, NodeResponse> skipResults = new LinkedHashMap<RequestId, NodeResponse>();
                subCommands.values().stream().map(c -> this.skipLogicRequested.getOrDefault(c.requestId(), Optional.empty()).orElse(null)).filter(Objects::nonNull).forEach(skipNode -> skipResults.put(skipNode.requestId(), new NodeResponse(Inputs.empty(), (ValueOrError<Object>)ValueOrError.withError((Throwable)Node.skipNodeException(skipNode)), skipNode.requestId())));
                Optional<CompletableFuture<Map<RequestId, NodeResponse>>> mainLogicFuture = this.executeMainLogicIfPossible(subCommands.values().stream().map(NodeRequestCommand::requestId).filter(key -> this.skipLogicRequested.getOrDefault(key, Optional.empty()).isEmpty()).toList(), nodeInputBatchCommand.dependantChain());
                if (mainLogicFuture.isPresent()) {
                    Futures.linkFutures((CompletableFuture)((CompletableFuture)mainLogicFuture.get().thenApply(map -> {
                        map.putAll(skipResults);
                        return map;
                    })).thenApply(NodeBatchResponse::new), (CompletableFuture)batchFuture);
                } else if (skipResults.size() == subCommands.size()) {
                    batchFuture.complete(new NodeBatchResponse(skipResults));
                }
            }
            catch (Throwable e) {
                batchFuture.completeExceptionally(e);
            }
            return batchFuture;
        }, (Duration timeTaken) -> this.nodeMetrics.totalNodeTimeNs(timeTaken.toNanos()));
    }

    private void propagateCommands(RequestId requestId, List<NodeInputCommand> nodeRequestCommands) {
        this.measuringTimeTaken(() -> {
            LinkedHashSet<String> dependencies = new LinkedHashSet<String>();
            for (NodeRequestCommand nodeRequestCommand : nodeRequestCommands) {
                RequestId depRequestId = nodeRequestCommand.requestId();
                String dependencyName = Node.getDependencyName(nodeRequestCommand);
                DependencyNodeExecutions dependencyNodeExecutions = this.dependencyExecutions.computeIfAbsent(requestId, _r -> new LinkedHashMap()).computeIfAbsent(dependencyName, _d -> new DependencyNodeExecutions());
                dependencyNodeExecutions.individualCallResponses().putIfAbsent(depRequestId, this.krystalNodeExecutor.executeCommand(nodeRequestCommand));
                dependencies.add(dependencyName);
            }
            for (String dependencyName : dependencies) {
                this.registerDependencyCallbacks(requestId, dependencyName, (NodeId)this.nodeDefinition.dependencyNodes().get((Object)dependencyName), this.dependencyExecutions.computeIfAbsent(requestId, _r -> new LinkedHashMap()).computeIfAbsent(dependencyName, _d -> new DependencyNodeExecutions()));
            }
        }, (Duration timeTaken) -> this.nodeMetrics.propagateNodeCommandsNs(timeTaken.toNanos()));
    }

    private void propagateCommands(BatchCommand<?> incomingBatch, Map<String, Map<RequestId, List<NodeInputCommand>>> outGoingBatchesByDep) {
        this.measuringTimeTaken(() -> {
            for (Map.Entry entry : outGoingBatchesByDep.entrySet()) {
                String dependencyName = (String)entry.getKey();
                Map nodeRequestCommands = (Map)entry.getValue();
                NodeId depNodeId = (NodeId)this.nodeDefinition.dependencyNodes().get((Object)dependencyName);
                CompletableFuture<NodeBatchResponse> batchCompletionFuture = this.krystalNodeExecutor.executeBatchCommand(new NodeInputBatch(depNodeId, nodeRequestCommands.values().stream().flatMap(Collection::stream).collect(Collectors.toMap(NodeRequestCommand::requestId, Functions.identity())), incomingBatch.dependantChain().extend(this.nodeId, dependencyName)));
                nodeRequestCommands.forEach((requestId, nodeRequestCommandList) -> nodeRequestCommandList.forEach(nodeRequestCommand -> {
                    RequestId depRequestId = nodeRequestCommand.requestId();
                    DependencyNodeExecutions dependencyNodeExecutions = this.dependencyExecutions.computeIfAbsent((RequestId)requestId, _r -> new LinkedHashMap()).computeIfAbsent(dependencyName, _d -> new DependencyNodeExecutions());
                    dependencyNodeExecutions.individualCallResponses().putIfAbsent(depRequestId, (CompletableFuture<NodeResponse>)batchCompletionFuture.thenApply(batch -> batch.responses().get(depRequestId)));
                }));
                this.registerBatchDependencyCallbacks(nodeRequestCommands.keySet(), dependencyName, depNodeId, incomingBatch);
            }
        }, (Duration timeTaken) -> this.nodeMetrics.propagateNodeCommandsNs(timeTaken.toNanos()));
    }

    private List<NodeInputCommand> computeNodeCommands(NodeRequestCommand nodeCommand) {
        return this.measuringTimeTaken(() -> {
            List<NodeInputCommand> nodeInputCommands;
            RequestId requestId = nodeCommand.requestId();
            if (nodeCommand instanceof SkipNode) {
                SkipNode skipNode = (SkipNode)nodeCommand;
                this.requestsByDependantChain.computeIfAbsent(skipNode.dependantChain(), k -> new LinkedHashSet()).add(requestId);
                this.dependantChainByRequest.put(requestId, skipNode.dependantChain());
                this.skipLogicRequested.put(requestId, Optional.of(skipNode));
                nodeInputCommands = this.handleSkipDependency(skipNode);
            } else if (nodeCommand instanceof ExecuteWithDependency) {
                ExecuteWithDependency executeWithDependency = (ExecuteWithDependency)nodeCommand;
                nodeInputCommands = this.executeWithDependency(executeWithDependency);
            } else if (nodeCommand instanceof ExecuteWithInputs) {
                ExecuteWithInputs executeWithInputs = (ExecuteWithInputs)nodeCommand;
                this.requestsByDependantChain.computeIfAbsent(executeWithInputs.dependantChain(), k -> new LinkedHashSet()).add(requestId);
                this.dependantChainByRequest.computeIfAbsent(requestId, r -> executeWithInputs.dependantChain());
                nodeInputCommands = this.executeWithInputs(executeWithInputs);
            } else {
                throw new UnsupportedOperationException("Unknown type of nodeCommand: %s".formatted(nodeCommand));
            }
            return nodeInputCommands;
        }, (Duration timeTaken) -> this.nodeMetrics.computeInputsForExecuteTimeNs(timeTaken.toNanos()));
    }

    private Map<String, Map<RequestId, List<NodeInputCommand>>> computeNodeCommands(BatchCommand<?> batchCommand) {
        ArrayList executeWithDependencyList = new ArrayList();
        ArrayList executeWithInputsList = new ArrayList();
        LinkedHashMap skipCommands = new LinkedHashMap();
        Set<RequestId> allRequestIds = batchCommand.subCommands().keySet();
        Set requestsByDepChain = this.requestsByDependantChain.computeIfAbsent(batchCommand.dependantChain(), k -> new LinkedHashSet(allRequestIds.size()));
        this.measuringTimeTaken(() -> batchCommand.subCommands().forEach((requestId, nodeCommand) -> {
            requestsByDepChain.add(requestId);
            this.dependantChainByRequest.put((RequestId)requestId, batchCommand.dependantChain());
            if (nodeCommand instanceof SkipNode) {
                SkipNode skipNode = (SkipNode)nodeCommand;
                this.skipLogicRequested.put((RequestId)requestId, Optional.of(skipNode));
                skipCommands.put(skipNode.requestId(), skipNode);
            } else if (nodeCommand instanceof ExecuteWithDependency) {
                ExecuteWithDependency executeWithDependency = (ExecuteWithDependency)nodeCommand;
                executeWithDependencyList.add(executeWithDependency);
            } else if (nodeCommand instanceof ExecuteWithInputs) {
                ExecuteWithInputs executeWithInputs = (ExecuteWithInputs)nodeCommand;
                executeWithInputsList.add(executeWithInputs);
            } else {
                throw new UnsupportedOperationException("Unknown type of nodeCommand: %s".formatted(nodeCommand));
            }
        }), (Duration timeTaken) -> this.nodeMetrics.computeInputsForExecuteTimeNs(timeTaken.toNanos()));
        LinkedHashMap<String, Map<RequestId, List<NodeInputCommand>>> nodeInputCommands = new LinkedHashMap<String, Map<RequestId, List<NodeInputCommand>>>();
        LinkedHashSet<String> newInputNames = new LinkedHashSet<String>();
        this.measuringTimeTaken(() -> {
            this.collectInputValues(executeWithInputsList, batchCommand.dependantChain());
            this.collectDepValues(executeWithDependencyList, batchCommand.dependantChain());
            executeWithInputsList.forEach(executeWithInputs -> newInputNames.addAll((Collection<String>)executeWithInputs.inputNames()));
            executeWithDependencyList.forEach(executeWithDependency -> newInputNames.add(executeWithDependency.dependencyName()));
            return newInputNames;
        }, (Duration timeTaken) -> this.nodeMetrics.computeInputsForExecuteTimeNs(timeTaken.toNanos()));
        if (skipCommands.size() == batchCommand.subCommands().size()) {
            nodeInputCommands.putAll(this.handleSkipDependencies(skipCommands.values()));
        } else {
            RequestId requestIdWithInputs = batchCommand.subCommands().entrySet().stream().filter(e -> !skipCommands.containsKey(e.getKey())).findAny().map(Map.Entry::getKey).orElseThrow();
            Map allInputs = this.inputsValueCollector.computeIfAbsent(requestIdWithInputs, r -> new LinkedHashMap());
            Map allDependencies = this.dependencyValuesCollector.computeIfAbsent(requestIdWithInputs, k -> new LinkedHashMap());
            Sets.SetView availableInputs = Sets.union(allInputs.keySet(), allDependencies.keySet());
            Set<ResolverDefinition> pendingResolvers = this.getPendingResolvers(requestIdWithInputs, newInputNames, (Set<String>)availableInputs);
            batchCommand.subCommands().keySet().forEach(requestId -> this.executeBatch((RequestId)requestId, pendingResolvers).forEach((depName, outgoingCommands) -> nodeInputCommands.computeIfAbsent((String)depName, _k -> new LinkedHashMap()).computeIfAbsent(requestId, _k -> new ArrayList()).addAll(outgoingCommands)));
        }
        return nodeInputCommands;
    }

    private Map<String, Map<RequestId, List<NodeInputCommand>>> getFilteredInputCommands(Map<String, Map<RequestId, List<NodeInputCommand>>> nodeInputCommands, int subCommandsSize) {
        return nodeInputCommands.entrySet().stream().filter(entry -> ((Map)entry.getValue()).size() == subCommandsSize).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private Optional<CompletableFuture<Map<RequestId, NodeResponse>>> executeMainLogicIfPossible(List<RequestId> requestIds, DependantChain dependantChain) {
        ImmutableSet<String> inputNames = this.nodeDefinition.getMainLogicDefinition().inputNames();
        return this.measuringTimeTaken(() -> {
            if (this.collectedInputNames.getOrDefault(dependantChain, (Set<String>)ImmutableSet.of()).containsAll((Collection<?>)inputNames)) {
                return Optional.of(this.executeMainLogic(requestIds, dependantChain));
            }
            return Optional.empty();
        }, (Duration timeTaken) -> this.nodeMetrics.mainLogicIfPossibleTimeNs(timeTaken.toNanos()));
    }

    private List<NodeInputCommand> handleSkipDependency(SkipNode skipNode) {
        RequestId requestId = skipNode.requestId();
        Set<ResolverDefinition> pendingResolvers = this.resolverDefinitionsByInput.values().stream().flatMap(Collection::stream).filter(resolverDefinition -> !this.resolverResults.computeIfAbsent(requestId, r -> new LinkedHashMap()).containsKey(resolverDefinition)).collect(Collectors.toSet());
        Optional<MultiResolverDefinition> multiResolverOpt = this.nodeDefinition.multiResolverLogicId().map(nodeLogicId -> this.nodeDefinition.nodeDefinitionRegistry().logicDefinitionRegistry().getMultiResolver((NodeLogicId)nodeLogicId));
        return this.executeResolvers(requestId, pendingResolvers).values().stream().flatMap(Collection::stream).toList();
    }

    private Map<String, Map<RequestId, List<NodeInputCommand>>> handleSkipDependencies(Collection<SkipNode> skipCommands) {
        LinkedHashMap<String, Map<RequestId, List<NodeInputCommand>>> outGoingNodeCommands = new LinkedHashMap<String, Map<RequestId, List<NodeInputCommand>>>();
        for (SkipNode skipCommand : skipCommands) {
            RequestId requestId = skipCommand.requestId();
            Set<ResolverDefinition> pendingResolvers = this.resolverDefinitionsByInput.values().stream().flatMap(Collection::stream).filter(resolverDefinition -> !this.resolverResults.computeIfAbsent(requestId, r -> new LinkedHashMap()).containsKey(resolverDefinition)).collect(Collectors.toSet());
            this.executeResolvers(requestId, pendingResolvers).forEach((depName, nodeInputCommands) -> outGoingNodeCommands.computeIfAbsent((String)depName, _k -> new LinkedHashMap()).computeIfAbsent(requestId, _k -> new ArrayList()).addAll(nodeInputCommands));
        }
        return outGoingNodeCommands;
    }

    private Optional<MultiResolverDefinition> getMultiResolverDef() {
        return this.nodeDefinition.multiResolverLogicId().map(nodeLogicId -> this.nodeDefinition.nodeDefinitionRegistry().logicDefinitionRegistry().getMultiResolver((NodeLogicId)nodeLogicId));
    }

    private static SkippedExecutionException skipNodeException(SkipNode skipNode) {
        String reason = skipNode.skipDependencyCommand().reason();
        return Node.skipNodeException(reason);
    }

    private static SkippedExecutionException skipNodeException(String reason) {
        return new SkippedExecutionException(reason);
    }

    private void flushDecoratorsIfNeeded(DependantChain dependantChain) {
        if (!this.flushedDependantChain.getOrDefault(dependantChain, false).booleanValue()) {
            return;
        }
        Set<RequestId> requestIds = this.requestsByDependantChain.get(dependantChain);
        int requestIdExecuted = 0;
        for (RequestId requestId : requestIds) {
            if (!this.mainLogicExecuted.getOrDefault(requestId, false).booleanValue() && !this.skipLogicRequested.getOrDefault(requestId, Optional.empty()).isPresent()) continue;
            ++requestIdExecuted;
        }
        if (requestIdExecuted == requestIds.size()) {
            Iterable reverseSortedDecorators = this.getSortedDecorators(dependantChain)::descendingIterator;
            for (MainLogicDecorator decorator : reverseSortedDecorators) {
                decorator.executeCommand(new FlushCommand(dependantChain));
            }
        }
    }

    private List<NodeInputCommand> executeWithInputs(ExecuteWithInputs executeWithInputs) {
        this.collectInputValues((List<ExecuteWithInputs>)ImmutableList.of((Object)executeWithInputs), executeWithInputs.dependantChain());
        return this.execute(executeWithInputs.requestId(), (Set<String>)executeWithInputs.inputNames()).values().stream().flatMap(Collection::stream).toList();
    }

    private List<NodeInputCommand> executeWithDependency(ExecuteWithDependency executeWithDependency) {
        this.collectDepValues((List<ExecuteWithDependency>)ImmutableList.of((Object)executeWithDependency), this.dependantChainByRequest.get(executeWithDependency.requestId()));
        return this.execute(executeWithDependency.requestId(), (Set<String>)ImmutableSet.of((Object)executeWithDependency.dependencyName())).values().stream().flatMap(Collection::stream).toList();
    }

    private void collectDepValues(List<ExecuteWithDependency> executeWithDependencyBatch, DependantChain dependantChain) {
        Set allInputNames = this.collectedInputNames.computeIfAbsent(dependantChain, _k -> new LinkedHashSet());
        for (ExecuteWithDependency executeWithDependency : executeWithDependencyBatch) {
            RequestId requestId = executeWithDependency.requestId();
            String dependencyName = executeWithDependency.dependencyName();
            allInputNames.add(dependencyName);
            if (this.dependencyValuesCollector.computeIfAbsent(requestId, k -> new LinkedHashMap()).putIfAbsent(dependencyName, executeWithDependency.results()) == null) continue;
            throw new DuplicateRequestException("Duplicate data for dependency %s of node %s in request %s".formatted(dependencyName, this.nodeId, requestId));
        }
    }

    private Map<String, List<NodeInputCommand>> executeBatch(RequestId requestId, Set<ResolverDefinition> resolvers) {
        Map allInputs = this.inputsValueCollector.computeIfAbsent(requestId, r -> new LinkedHashMap());
        Map allDependencies = this.dependencyValuesCollector.computeIfAbsent(requestId, k -> new LinkedHashMap());
        ImmutableSet<String> allInputNames = this.nodeDefinition.getMainLogicDefinition().inputNames();
        Sets.SetView availableInputs = Sets.union(allInputs.keySet(), allDependencies.keySet());
        if (availableInputs.isEmpty() && !allInputNames.isEmpty() && this.nodeDefinition.resolverDefinitions().isEmpty() && !this.nodeDefinition.dependencyNodes().isEmpty()) {
            return this.executeDependenciesWhenNoResolvers(requestId);
        }
        return this.executeResolvers(requestId, resolvers);
    }

    private Map<String, List<NodeInputCommand>> execute(RequestId requestId, Set<String> newInputNames) {
        MainLogicDefinition mainLogicDefinition = this.nodeDefinition.getMainLogicDefinition();
        Map allInputs = this.inputsValueCollector.computeIfAbsent(requestId, r -> new LinkedHashMap());
        Map allDependencies = this.dependencyValuesCollector.computeIfAbsent(requestId, k -> new LinkedHashMap());
        ImmutableSet<String> allInputNames = mainLogicDefinition.inputNames();
        Sets.SetView availableInputs = Sets.union(allInputs.keySet(), allDependencies.keySet());
        if (availableInputs.isEmpty() && !allInputNames.isEmpty() && this.nodeDefinition.resolverDefinitions().isEmpty() && !this.nodeDefinition.dependencyNodes().isEmpty()) {
            return this.executeDependenciesWhenNoResolvers(requestId);
        }
        Set<ResolverDefinition> pendingResolvers = this.getPendingResolvers(requestId, newInputNames, (Set<String>)availableInputs);
        return this.executeResolvers(requestId, pendingResolvers);
    }

    private Set<ResolverDefinition> getPendingResolvers(RequestId requestId, Set<String> newInputNames, Set<String> availableInputs) {
        Map resolverCommands = this.resolverResults.computeIfAbsent(requestId, r -> new LinkedHashMap());
        if (KrystalNodeExecutor.DependencyExecStrategy.INCREMENTAL.equals((Object)this.dependencyExecStrategy)) {
            Set pendingUnboundResolvers = ((List)this.resolverDefinitionsByInput.getOrDefault(Optional.empty(), Collections.emptyList())).stream().filter(resolverDefinition -> !resolverCommands.containsKey(resolverDefinition)).filter(resolverDefinition -> availableInputs.containsAll((Collection<?>)resolverDefinition.boundFrom())).collect(Collectors.toSet());
            Set<ResolverDefinition> pendingResolvers = newInputNames.stream().flatMap(input -> ((List)this.resolverDefinitionsByInput.getOrDefault(Optional.ofNullable(input), (Object)ImmutableList.of())).stream().filter(resolverDefinition -> availableInputs.containsAll((Collection<?>)resolverDefinition.boundFrom())).filter(resolverDefinition -> !resolverCommands.containsKey(resolverDefinition))).collect(Collectors.toSet());
            pendingResolvers.addAll(pendingUnboundResolvers);
            return pendingResolvers;
        }
        return Stream.concat(Stream.of(Optional.empty()), newInputNames.stream().map(Optional::of)).map(arg_0 -> this.resolverDefinitionsByInput.get(arg_0)).filter(Objects::nonNull).flatMap(Collection::stream).map(ResolverDefinition::dependencyName).map(arg_0 -> this.resolverDefinitionsByDependencies.get(arg_0)).filter(resolverDefinitions -> resolverDefinitions.stream().map(ResolverDefinition::boundFrom).flatMap(Collection::stream).allMatch(availableInputs::contains) || this.skipLogicRequested.getOrDefault(requestId, Optional.empty()).isPresent()).flatMap(Collection::stream).filter(key -> !resolverCommands.containsKey(key)).collect(Collectors.toSet());
    }

    private Map<String, List<NodeInputCommand>> executeResolvers(RequestId requestId, Set<ResolverDefinition> pendingResolvers) {
        if (KrystalNodeExecutor.ResolverExecStrategy.SINGLE.equals((Object)this.resolverExecStrategy)) {
            for (ResolverDefinition resolverDefinition : pendingResolvers) {
                this.executeResolver(requestId, resolverDefinition);
            }
            return Collections.emptyMap();
        }
        if (pendingResolvers.isEmpty()) {
            return Collections.emptyMap();
        }
        Optional<MultiResolverDefinition> multiResolver = this.getMultiResolverDef();
        if (multiResolver.isEmpty() || pendingResolvers.isEmpty()) {
            return Collections.emptyMap();
        }
        Map<String, List<ResolverDefinition>> resolversByDependency = pendingResolvers.stream().collect(Collectors.groupingBy(ResolverDefinition::dependencyName));
        Map resolverCommands = this.measuringTimeTaken(() -> {
            Optional skipRequested = this.skipLogicRequested.getOrDefault(requestId, Optional.empty());
            if (skipRequested.isPresent()) {
                ResolverCommand.SkipDependency skip = ResolverCommand.skip(((SkipNode)skipRequested.get()).skipDependencyCommand().reason());
                return resolversByDependency.keySet().stream().collect(Collectors.toMap(Functions.identity(), _k -> skip));
            }
            Inputs inputs = this.getInputsFor(requestId, pendingResolvers.stream().map(ResolverDefinition::boundFrom).flatMap(Collection::stream).collect(Collectors.toSet()));
            return ((MultiResolver)((MultiResolverDefinition)multiResolver.get()).logic()).resolve(resolversByDependency.entrySet().stream().map(e -> new DependencyResolutionRequest((String)e.getKey(), (List)e.getValue())).toList(), inputs);
        }, (Duration timeTaken) -> this.nodeMetrics.executeResolversTimeNs(timeTaken.toNanos()));
        LinkedHashMap<String, List<NodeInputCommand>> nodeRequestCommands = new LinkedHashMap<String, List<NodeInputCommand>>();
        resolverCommands.forEach((depName, resolverCommand) -> nodeRequestCommands.computeIfAbsent((String)depName, _k -> new ArrayList()).addAll(this.handleResolverCommand(requestId, (String)depName, (List)resolversByDependency.get(depName), (ResolverCommand)resolverCommand)));
        return nodeRequestCommands;
    }

    private List<NodeInputCommand> executeResolver(RequestId requestId, ResolverDefinition resolverDefinition) {
        ResolverCommand resolverCommand;
        NodeLogicId nodeLogicId = resolverDefinition.resolverNodeLogicId();
        Optional skipRequested = this.skipLogicRequested.getOrDefault(requestId, Optional.empty());
        if (skipRequested.isPresent()) {
            resolverCommand = ResolverCommand.skip(((SkipNode)skipRequested.get()).skipDependencyCommand().reason());
        } else {
            Inputs inputsForResolver = this.getInputsForResolver(resolverDefinition, requestId);
            resolverCommand = this.nodeDefinition.nodeDefinitionRegistry().logicDefinitionRegistry().getResolver(nodeLogicId).resolve(inputsForResolver);
        }
        String dependencyName = resolverDefinition.dependencyName();
        return this.handleResolverCommand(requestId, dependencyName, List.of(resolverDefinition), resolverCommand);
    }

    private static String getDependencyName(NodeRequestCommand nodeRequestCommand) {
        DependantChain dependantChain;
        if (nodeRequestCommand instanceof ExecuteWithInputs) {
            ExecuteWithInputs executeWithInputs = (ExecuteWithInputs)nodeRequestCommand;
            dependantChain = executeWithInputs.dependantChain();
        } else if (nodeRequestCommand instanceof SkipNode) {
            SkipNode skipNode = (SkipNode)nodeRequestCommand;
            dependantChain = skipNode.dependantChain();
        } else {
            throw new UnsupportedOperationException("Unknown NodeRequestCommand Type: %s".formatted(nodeRequestCommand));
        }
        if (!(dependantChain instanceof DefaultDependantChain)) {
            throw new IllegalStateException("This should never happen");
        }
        DefaultDependantChain defaultDependantChain = (DefaultDependantChain)dependantChain;
        return defaultDependantChain.dependencyName();
    }

    private List<NodeInputCommand> handleResolverCommand(RequestId requestId, String dependencyName, List<ResolverDefinition> resolverDefinitions, ResolverCommand resolverCommand) {
        return this.measuringTimeTaken(() -> this._handleResolverCommand(requestId, dependencyName, resolverDefinitions, resolverCommand), (Duration timeTaken) -> this.nodeMetrics.handleResolverCommandTimeNs(timeTaken.toNanos()));
    }

    private List<NodeInputCommand> _handleResolverCommand(RequestId requestId, String dependencyName, List<ResolverDefinition> resolverDefinitions, ResolverCommand resolverCommand) {
        ArrayList<NodeInputCommand> nodeRequestCommands;
        block6: {
            DependencyNodeExecutions dependencyNodeExecutions;
            NodeId depNodeId;
            block5: {
                nodeRequestCommands = new ArrayList<NodeInputCommand>();
                depNodeId = (NodeId)this.nodeDefinition.dependencyNodes().get((Object)dependencyName);
                Map resolverResults = this.resolverResults.computeIfAbsent(requestId, r -> new LinkedHashMap());
                resolverDefinitions.forEach(resolverDefinition -> resolverResults.put(resolverDefinition, resolverCommand));
                dependencyNodeExecutions = this.dependencyExecutions.computeIfAbsent(requestId, k -> new LinkedHashMap()).computeIfAbsent(dependencyName, k -> new DependencyNodeExecutions());
                dependencyNodeExecutions.executedResolvers().addAll(resolverDefinitions);
                if (!(resolverCommand instanceof ResolverCommand.SkipDependency)) break block5;
                if (this.dependencyValuesCollector.getOrDefault(requestId, (Map<String, Results<Object>>)ImmutableMap.of()).get(dependencyName) != null) break block6;
                HashSet<RequestId> requestIdSet = new HashSet<RequestId>(dependencyNodeExecutions.individualCallResponses().keySet());
                requestIdSet.add(requestId.createNewRequest("%s[%s]".formatted(dependencyName, 0)));
                for (RequestId depRequestId : requestIdSet) {
                    SkipNode skipNode = new SkipNode(depNodeId, depRequestId, this.dependantChainByRequest.getOrDefault(requestId, DependantChainStart.instance()).extend(this.nodeId, dependencyName), (ResolverCommand.SkipDependency)resolverCommand);
                    nodeRequestCommands.add(skipNode);
                }
                break block6;
            }
            ImmutableList<Inputs> inputList = resolverCommand.getInputs();
            long executionsInProgress = dependencyNodeExecutions.executionCounter().longValue();
            LinkedHashMap<RequestId, Inputs> oldInputs = new LinkedHashMap<RequestId, Inputs>();
            int i = 0;
            while ((long)i < executionsInProgress) {
                RequestId rid = requestId.createNewRequest("%s[%s]".formatted(dependencyName, i));
                oldInputs.put(rid, new Inputs(dependencyNodeExecutions.individualCallInputs().getOrDefault(rid, Inputs.empty()).values()));
                ++i;
            }
            long batchSize = Math.max(executionsInProgress, 1L);
            int requestCounter = 0;
            for (int j = 0; j < inputList.size(); ++j) {
                Inputs inputs = (Inputs)inputList.get(j);
                int i2 = 0;
                while ((long)i2 < batchSize) {
                    RequestId dependencyRequestId = requestId.createNewRequest("%s[%s]".formatted(dependencyName, (long)j * batchSize + (long)i2));
                    RequestId inProgressRequestId = executionsInProgress > 0L ? requestId.createNewRequest("%s[%s]".formatted(dependencyName, i2)) : dependencyRequestId;
                    Inputs oldInput = oldInputs.getOrDefault(inProgressRequestId, Inputs.empty());
                    if ((long)requestCounter >= executionsInProgress) {
                        dependencyNodeExecutions.executionCounter().increment();
                    }
                    Inputs newInputs = j == 0 ? inputs : Inputs.union((Map)oldInput.values(), (Map)inputs.values());
                    dependencyNodeExecutions.individualCallInputs().put(dependencyRequestId, newInputs);
                    ExecuteWithInputs nodeCommand = new ExecuteWithInputs(depNodeId, (ImmutableSet<String>)newInputs.values().keySet(), newInputs, this.dependantChainByRequest.getOrDefault(requestId, DependantChainStart.instance()).extend(this.nodeId, dependencyName), dependencyRequestId);
                    nodeRequestCommands.add(nodeCommand);
                    ++i2;
                }
                requestCounter = (int)((long)requestCounter + batchSize);
            }
        }
        return nodeRequestCommands;
    }

    private void registerDependencyCallbacks(RequestId requestId, String dependencyName, NodeId depNodeId, DependencyNodeExecutions dependencyNodeExecutions) {
        ImmutableSet resolverDefinitionsForDependency = (ImmutableSet)this.resolverDefinitionsByDependencies.getOrDefault((Object)dependencyName, (Object)ImmutableSet.of());
        if (resolverDefinitionsForDependency.equals(dependencyNodeExecutions.executedResolvers())) {
            CompletableFuture.allOf((CompletableFuture[])dependencyNodeExecutions.individualCallResponses().values().toArray(CompletableFuture[]::new)).whenComplete((unused, throwable) -> this.enqueueOrExecuteCommand(() -> {
                Results results = throwable != null ? new Results(ImmutableMap.of((Object)Inputs.empty(), (Object)ValueOrError.withError((Throwable)throwable))) : new Results((ImmutableMap)dependencyNodeExecutions.individualCallResponses().values().stream().map(cf -> cf.getNow(new NodeResponse(requestId))).collect(ImmutableMap.toImmutableMap(NodeResponse::inputs, NodeResponse::response)));
                return new ExecuteWithDependency(this.nodeId, dependencyName, (Results<Object>)results, requestId);
            }, depNodeId));
            this.flushDependencyIfNeeded(dependencyName, this.dependantChainByRequest.getOrDefault(requestId, DependantChainStart.instance()));
        }
    }

    private void registerBatchDependencyCallbacks(Collection<RequestId> requestIds, String dependencyName, NodeId depNodeId, BatchCommand<?> batchCommand) {
        ImmutableSet resolverDefinitionsForDependency = (ImmutableSet)this.resolverDefinitionsByDependencies.getOrDefault((Object)dependencyName, (Object)ImmutableSet.of());
        boolean allResolversExecuted = requestIds.stream().map(requestId -> this.dependencyExecutions.getOrDefault(requestId, (Map<String, DependencyNodeExecutions>)ImmutableMap.of()).getOrDefault(dependencyName, new DependencyNodeExecutions())).allMatch(dependencyNodeExecutions -> resolverDefinitionsForDependency.equals(dependencyNodeExecutions.executedResolvers()));
        if (allResolversExecuted) {
            CompletableFuture.allOf((CompletableFuture[])requestIds.stream().map(requestId -> this.dependencyExecutions.getOrDefault(requestId, (Map<String, DependencyNodeExecutions>)ImmutableMap.of()).getOrDefault(dependencyName, new DependencyNodeExecutions())).map(DependencyNodeExecutions::individualCallResponses).map(Map::values).flatMap(Collection::stream).toArray(CompletableFuture[]::new)).orTimeout(1000000L, TimeUnit.MILLISECONDS).whenComplete((unused, throwable) -> this.enqueueOrExecuteBatchCommand(() -> {
                LinkedHashMap<RequestId, ExecuteWithDependency> callbacks = new LinkedHashMap<RequestId, ExecuteWithDependency>();
                for (RequestId requestId : requestIds) {
                    Results results;
                    if (throwable != null) {
                        results = new Results(ImmutableMap.of((Object)Inputs.empty(), (Object)ValueOrError.withError((Throwable)throwable)));
                    } else {
                        DependencyNodeExecutions dependencyNodeExecutions = this.dependencyExecutions.getOrDefault(requestId, (Map<String, DependencyNodeExecutions>)ImmutableMap.of()).getOrDefault(dependencyName, new DependencyNodeExecutions());
                        results = new Results((ImmutableMap)dependencyNodeExecutions.individualCallResponses().values().stream().map(cf -> cf.getNow(new NodeResponse(requestId))).collect(ImmutableMap.toImmutableMap(NodeResponse::inputs, NodeResponse::response)));
                    }
                    callbacks.put(requestId, new ExecuteWithDependency(this.nodeId, dependencyName, (Results<Object>)results, requestId));
                }
                return new DependencyCallbackBatch(this.nodeId, callbacks, batchCommand.dependantChain());
            }, depNodeId));
            this.flushDependencyIfNeeded(dependencyName, batchCommand.dependantChain());
        }
    }

    private void enqueueOrExecuteCommand(Supplier<NodeRequestCommand> commandGenerator, NodeId depNodeId) {
        MainLogicDefinition depMainLogic = this.nodeDefinition.nodeDefinitionRegistry().get(depNodeId).getMainLogicDefinition();
        if (depMainLogic instanceof IOLogicDefinition) {
            this.krystalNodeExecutor.enqueueNodeCommand(commandGenerator);
        } else if (depMainLogic instanceof ComputeLogicDefinition) {
            this.krystalNodeExecutor.executeCommand(commandGenerator.get());
        } else {
            throw new UnsupportedOperationException("Unknown logicDefinition type %s".formatted(depMainLogic.getClass()));
        }
    }

    private void enqueueOrExecuteBatchCommand(Supplier<BatchCommand<?>> commandGenerator, NodeId depNodeId) {
        MainLogicDefinition depMainLogic = this.nodeDefinition.nodeDefinitionRegistry().get(depNodeId).getMainLogicDefinition();
        if (depMainLogic instanceof IOLogicDefinition) {
            this.krystalNodeExecutor.enqueueNodeBatchCommand(commandGenerator);
        } else if (depMainLogic instanceof ComputeLogicDefinition) {
            this.krystalNodeExecutor.executeBatchCommand(commandGenerator.get());
        } else {
            throw new UnsupportedOperationException("Unknown logicDefinition type %s".formatted(depMainLogic.getClass()));
        }
    }

    private void flushAllDependenciesIfNeeded(DependantChain dependantChain) {
        this.nodeDefinition.dependencyNodes().keySet().forEach(dependencyName -> this.flushDependencyIfNeeded((String)dependencyName, dependantChain));
    }

    private void flushDependencyIfNeeded(String dependencyName, DependantChain dependantChain) {
        if (!this.flushedDependantChain.getOrDefault(dependantChain, false).booleanValue()) {
            return;
        }
        Set<RequestId> requestsForDependantChain = this.requestsByDependantChain.getOrDefault(dependantChain, (Set<RequestId>)ImmutableSet.of());
        ImmutableSet resolverDefinitionsForDependency = (ImmutableSet)this.resolverDefinitionsByDependencies.get((Object)dependencyName);
        if (!requestsForDependantChain.isEmpty() && requestsForDependantChain.stream().map(requestId -> this.dependencyExecutions.getOrDefault(requestId, (Map<String, DependencyNodeExecutions>)ImmutableMap.of()).getOrDefault(dependencyName, new DependencyNodeExecutions())).allMatch(dependencyNodeExecutions -> resolverDefinitionsForDependency.equals(dependencyNodeExecutions.executedResolvers()))) {
            this.krystalNodeExecutor.executeCommand(new Flush((NodeId)this.nodeDefinition.dependencyNodes().get((Object)dependencyName), dependantChain.extend(this.nodeId, dependencyName)));
        }
    }

    private Inputs getInputsForResolver(ResolverDefinition resolverDefinition, RequestId requestId) {
        ImmutableSet<String> boundFrom = resolverDefinition.boundFrom();
        return this.getInputsFor(requestId, (Set<String>)boundFrom);
    }

    private Inputs getInputsFor(RequestId requestId, Set<String> boundFrom) {
        Map allInputs = this.inputsValueCollector.computeIfAbsent(requestId, r -> new LinkedHashMap());
        LinkedHashMap<String, InputValue> inputValues = new LinkedHashMap<String, InputValue>();
        for (String boundFromInput : boundFrom) {
            InputValue voe = (InputValue)allInputs.get(boundFromInput);
            if (voe == null) {
                inputValues.put(boundFromInput, (InputValue)this.dependencyValuesCollector.computeIfAbsent(requestId, k -> new LinkedHashMap()).get(boundFromInput));
                continue;
            }
            inputValues.put(boundFromInput, voe);
        }
        return new Inputs(inputValues);
    }

    private Map<String, List<NodeInputCommand>> executeDependenciesWhenNoResolvers(RequestId requestId) {
        LinkedHashMap<String, List<NodeInputCommand>> nodeReqCommands = new LinkedHashMap<String, List<NodeInputCommand>>(this.nodeDefinition.dependencyNodes().size());
        this.nodeDefinition.dependencyNodes().forEach((depName, depNodeId) -> {
            if (!this.dependencyValuesCollector.getOrDefault(requestId, (Map<String, Results<Object>>)ImmutableMap.of()).containsKey(depName)) {
                RequestId dependencyRequestId = requestId.createNewRequest("%s".formatted(depName));
                ExecuteWithInputs nodeCommand = new ExecuteWithInputs((NodeId)depNodeId, (ImmutableSet<String>)ImmutableSet.of(), Inputs.empty(), this.dependantChainByRequest.get(requestId).extend(this.nodeId, (String)depName), dependencyRequestId);
                nodeReqCommands.computeIfAbsent((String)depName, _k -> new ArrayList()).add(nodeCommand);
            }
        });
        return nodeReqCommands;
    }

    private Optional<CompletableFuture<NodeResponse>> executeMainLogicIfPossible(RequestId requestId) {
        return this.measuringTimeTaken(() -> {
            MainLogicDefinition mainLogicDefinition = this.nodeDefinition.getMainLogicDefinition();
            ImmutableSet<String> inputNames = mainLogicDefinition.inputNames();
            LinkedHashSet<String> collect = new LinkedHashSet<String>(this.inputsValueCollector.getOrDefault(requestId, (Map<String, InputValue<Object>>)ImmutableMap.of()).keySet());
            collect.addAll(this.dependencyValuesCollector.getOrDefault(requestId, (Map<String, Results<Object>>)ImmutableMap.of()).keySet());
            if (collect.containsAll((Collection<?>)inputNames)) {
                return Optional.of(this.executeMainLogic(requestId));
            }
            return Optional.empty();
        }, (Duration timeTaken) -> this.nodeMetrics.mainLogicIfPossibleTimeNs(timeTaken.toNanos()));
    }

    private CompletableFuture<Object> executeDecoratedMainLogic(Inputs inputs, MainLogicDefinition<Object> mainLogicDefinition, RequestId requestId) {
        NavigableSet<MainLogicDecorator> sortedDecorators = this.getSortedDecorators(this.dependantChainByRequest.get(requestId));
        MainLogic logic = mainLogicDefinition::execute;
        for (MainLogicDecorator mainLogicDecorator : sortedDecorators) {
            logic = mainLogicDecorator.decorateLogic(logic, mainLogicDefinition);
        }
        MainLogic finalLogic = logic;
        return this.measuringTimeTaken(() -> (CompletableFuture)finalLogic.execute((ImmutableList<Inputs>)ImmutableList.of((Object)inputs)).get((Object)inputs), (Duration timeTaken) -> this.nodeMetrics.executeMainLogicTimeNs(timeTaken.toNanos()));
    }

    private CompletableFuture<NodeResponse> executeMainLogic(RequestId requestId) {
        MainLogicDefinition<Object> mainLogicDefinition = this.nodeDefinition.getMainLogicDefinition();
        MainLogicInputs mainLogicInputs = this.getInputsForMainLogic(requestId);
        CompletableFuture<Object> resultFuture = this.resultsCache.get(mainLogicInputs.nonDependencyInputs());
        if (resultFuture == null) {
            resultFuture = this.executeDecoratedMainLogic(mainLogicInputs.allInputsAndDependencies(), mainLogicDefinition, requestId);
            this.resultsCache.put(mainLogicInputs.nonDependencyInputs(), resultFuture);
        }
        this.mainLogicExecuted.put(requestId, true);
        this.flushDecoratorsIfNeeded(this.dependantChainByRequest.get(requestId));
        return ((CompletableFuture)resultFuture.handle(ValueOrError::valueOrError)).thenApply(voe -> new NodeResponse(mainLogicInputs.nonDependencyInputs(), (ValueOrError<Object>)voe, requestId));
    }

    private CompletableFuture<Map<RequestId, NodeResponse>> executeMainLogic(List<RequestId> requestIds, DependantChain dependantChain) {
        MainLogicDefinition<Object> mainLogicDefinition = this.nodeDefinition.getMainLogicDefinition();
        LinkedHashMap<RequestId, MainLogicInputs> mainLogicInputsByReq = new LinkedHashMap<RequestId, MainLogicInputs>();
        LinkedHashMap<RequestId, CompletableFuture<ValueOrError<Object>>> resultsByRequest = new LinkedHashMap<RequestId, CompletableFuture<ValueOrError<Object>>>();
        for (RequestId requestId2 : requestIds) {
            mainLogicInputsByReq.put(requestId2, this.getInputsForMainLogic(requestId2));
        }
        CompletableFuture<Map<RequestId, NodeResponse>> resultForBatch = new CompletableFuture<Map<RequestId, NodeResponse>>();
        this.executeDecoratedMainLogic(mainLogicDefinition, mainLogicInputsByReq, resultsByRequest, dependantChain);
        CompletableFuture.allOf((CompletableFuture[])resultsByRequest.values().toArray(CompletableFuture[]::new)).whenComplete((unused, throwable) -> {
            LinkedHashMap<RequestId, NodeResponse> batchResponses = new LinkedHashMap<RequestId, NodeResponse>();
            for (Map.Entry entry : mainLogicInputsByReq.entrySet()) {
                RequestId requestId = (RequestId)entry.getKey();
                CompletableFuture requestResult = (CompletableFuture)resultsByRequest.get(requestId);
                batchResponses.put(requestId, new NodeResponse(((MainLogicInputs)entry.getValue()).nonDependencyInputs(), (ValueOrError<Object>)requestResult.getNow(ValueOrError.empty()), requestId));
            }
            resultForBatch.complete(batchResponses);
        });
        requestIds.forEach(requestId -> this.mainLogicExecuted.put((RequestId)requestId, true));
        this.flushDecoratorsIfNeeded(dependantChain);
        return resultForBatch;
    }

    private void executeDecoratedMainLogic(MainLogicDefinition<Object> mainLogicDefinition, Map<RequestId, MainLogicInputs> mainLogicInputsByReq, Map<RequestId, CompletableFuture<ValueOrError<Object>>> resultsByRequest, DependantChain dependantChain) {
        NavigableSet<MainLogicDecorator> sortedDecorators = this.getSortedDecorators(dependantChain);
        MainLogic logic = mainLogicDefinition::execute;
        for (MainLogicDecorator mainLogicDecorator : sortedDecorators) {
            logic = mainLogicDecorator.decorateLogic(logic, mainLogicDefinition);
        }
        MainLogic finalLogic = logic;
        mainLogicInputsByReq.forEach((requestId, mainLogicInputs) -> {
            CompletableFuture cachedResult = this.resultsCache.get(mainLogicInputs.nonDependencyInputs());
            if (cachedResult == null) {
                cachedResult = this.measuringTimeTaken(() -> (CompletableFuture)finalLogic.execute((ImmutableList<Inputs>)ImmutableList.of((Object)mainLogicInputs.allInputsAndDependencies())).values().iterator().next(), (Duration timeTaken) -> this.nodeMetrics.executeMainLogicTimeNs(timeTaken.toNanos()));
                this.resultsCache.put(mainLogicInputs.nonDependencyInputs(), cachedResult);
            }
            resultsByRequest.put((RequestId)requestId, (CompletableFuture<ValueOrError<Object>>)cachedResult.handle(ValueOrError::valueOrError));
        });
        this.nodeMetrics.executeMainLogicCount();
    }

    private MainLogicInputs getInputsForMainLogic(RequestId requestId) {
        Inputs inputValues = new Inputs(this.inputsValueCollector.getOrDefault(requestId, (Map<String, InputValue<Object>>)ImmutableMap.of()));
        Map<String, Results<Object>> dependencyValues = this.dependencyValuesCollector.getOrDefault(requestId, (Map<String, Results<Object>>)ImmutableMap.of());
        Inputs allInputsAndDependencies = Inputs.union(dependencyValues, (Map)inputValues.values());
        return new MainLogicInputs(inputValues, allInputsAndDependencies);
    }

    private void collectInputValues(List<ExecuteWithInputs> executeWithInputsBatch, DependantChain dependantChain) {
        Set allInputNames = this.collectedInputNames.computeIfAbsent(dependantChain, _k -> new LinkedHashSet());
        for (ExecuteWithInputs executeWithInputs : executeWithInputsBatch) {
            RequestId requestId = executeWithInputs.requestId();
            ImmutableSet<String> inputNames = executeWithInputs.inputNames();
            allInputNames.addAll(inputNames);
            Inputs inputs = executeWithInputs.values();
            for (String inputName : inputNames) {
                if (this.inputsValueCollector.computeIfAbsent(requestId, r -> new LinkedHashMap()).putIfAbsent(inputName, inputs.getInputValue(inputName)) == null) continue;
                throw new DuplicateRequestException("Duplicate data for inputs %s of node %s in request %s".formatted(inputNames, this.nodeId, requestId));
            }
        }
    }

    private NavigableSet<MainLogicDecorator> getSortedDecorators(DependantChain dependantChain) {
        MainLogicDefinition mainLogicDefinition = this.nodeDefinition.getMainLogicDefinition();
        LinkedHashMap<String, MainLogicDecorator> decorators = new LinkedHashMap<String, MainLogicDecorator>((Map<String, MainLogicDecorator>)mainLogicDefinition.getSessionScopedLogicDecorators(this.nodeDefinition, dependantChain));
        decorators.putAll((Map)this.requestScopedDecoratorsSupplier.apply(new LogicExecutionContext(this.nodeId, mainLogicDefinition.logicTags(), dependantChain, this.nodeDefinition.nodeDefinitionRegistry())));
        TreeSet sortedDecorators = new TreeSet(this.logicDecorationOrdering.decorationOrder());
        sortedDecorators.addAll(decorators.values());
        return sortedDecorators;
    }

    private static ImmutableMapView<Optional<String>, List<ResolverDefinition>> createResolverDefinitionsByInputs(ImmutableList<ResolverDefinition> resolverDefinitions) {
        LinkedHashMap resolverDefinitionsByInput = new LinkedHashMap();
        resolverDefinitions.forEach(resolverDefinition -> {
            if (!resolverDefinition.boundFrom().isEmpty()) {
                resolverDefinition.boundFrom().forEach(input -> resolverDefinitionsByInput.computeIfAbsent(Optional.of(input), s -> new ArrayList()).add(resolverDefinition));
            } else {
                resolverDefinitionsByInput.computeIfAbsent(Optional.empty(), s -> new ArrayList()).add(resolverDefinition);
            }
        });
        return ImmutableMapView.viewOf(resolverDefinitionsByInput);
    }

    private void measuringTimeTaken(Runnable runnable, Consumer<Duration> totalTimeNs) {
        this.measuringTimeTaken(() -> {
            runnable.run();
            return null;
        }, totalTimeNs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T measuringTimeTaken(Supplier<T> callable, Consumer<Duration> totalTimeNs) {
        long start = System.nanoTime();
        try {
            T t = callable.get();
            return t;
        }
        finally {
            totalTimeNs.accept(Duration.ofNanos(System.nanoTime() - start));
        }
    }

    private record DependencyNodeExecutions(LongAdder executionCounter, Set<ResolverDefinition> executedResolvers, Map<RequestId, Inputs> individualCallInputs, Map<RequestId, CompletableFuture<NodeResponse>> individualCallResponses) {
        private DependencyNodeExecutions() {
            this(new LongAdder(), new LinkedHashSet<ResolverDefinition>(), new LinkedHashMap<RequestId, Inputs>(), new LinkedHashMap<RequestId, CompletableFuture<NodeResponse>>());
        }
    }

    private record MainLogicInputs(Inputs nonDependencyInputs, Inputs allInputsAndDependencies) {
    }
}

