/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.krystex.node;

import java.time.Duration;

public class NodeMetrics {
    private final NodeMetrics delegate;
    private long totalNodeTimeNs;
    private long computeInputsForExecuteTimeNs;
    private long mainLogicIfPossibleTimeNs;
    private long propagateNodeCommandsNs;
    private long executeMainLogicTimeNs;
    private long handleResolverCommandTimeNs;
    private long executeResolversTimeNs;
    private long nodeInputsBatchCount;
    private long depCallbackBatchCount;
    private long executeMainLogicCount;

    public NodeMetrics() {
        this(null);
    }

    public NodeMetrics(NodeMetrics delegate) {
        this.delegate = delegate;
    }

    public void add(NodeMetrics other) {
        this.totalNodeTimeNs += other.totalNodeTimeNs;
        this.computeInputsForExecuteTimeNs += other.computeInputsForExecuteTimeNs;
        this.propagateNodeCommandsNs += other.propagateNodeCommandsNs;
        this.executeMainLogicTimeNs += other.executeMainLogicTimeNs;
        this.mainLogicIfPossibleTimeNs += other.mainLogicIfPossibleTimeNs;
        this.handleResolverCommandTimeNs += other.handleResolverCommandTimeNs;
        this.executeResolversTimeNs += other.executeResolversTimeNs;
        this.nodeInputsBatchCount += other.nodeInputsBatchCount;
        this.depCallbackBatchCount += other.depCallbackBatchCount;
        this.executeMainLogicCount += other.executeMainLogicCount;
    }

    public String toString() {
        return "NodeMetrics {\n  totalNodeTimeNs                   %s\n    computeInputsForExecuteTimeNs     %s\n    executeResolversTime              %s\n    handleResolverCommandTime         %s\n    propagateNodeCommands             %s\n    mainLogicIfPossibleTimeNs         %s\n      executeMainLogicTime              %s\n\n  nodeInputsBatchCount              %,d\n  depCallbackBatchCount             %,d\n  executeMainLogicCount             %,d   }\n".formatted(NodeMetrics.toString(Duration.ofNanos(this.totalNodeTimeNs)), NodeMetrics.toString(Duration.ofNanos(this.computeInputsForExecuteTimeNs)), NodeMetrics.toString(Duration.ofNanos(this.executeResolversTimeNs)), NodeMetrics.toString(Duration.ofNanos(this.handleResolverCommandTimeNs)), NodeMetrics.toString(Duration.ofNanos(this.propagateNodeCommandsNs)), NodeMetrics.toString(Duration.ofNanos(this.mainLogicIfPossibleTimeNs)), NodeMetrics.toString(Duration.ofNanos(this.executeMainLogicTimeNs)), this.nodeInputsBatchCount, this.depCallbackBatchCount, this.executeMainLogicCount);
    }

    private static String toString(Duration duration) {
        return "%dm %ds %dns".formatted(duration.toMinutes(), duration.toSecondsPart(), duration.toNanosPart());
    }

    public void totalNodeTimeNs(long totalNodeTimeNs) {
        this.totalNodeTimeNs += totalNodeTimeNs;
        if (this.delegate != null) {
            this.delegate.totalNodeTimeNs(totalNodeTimeNs);
        }
    }

    public void mainLogicIfPossibleTimeNs(long mainLogicIfPossibleTimeNs) {
        this.mainLogicIfPossibleTimeNs += mainLogicIfPossibleTimeNs;
        if (this.delegate != null) {
            this.delegate.mainLogicIfPossibleTimeNs(mainLogicIfPossibleTimeNs);
        }
    }

    public void computeInputsForExecuteTimeNs(long computeInputsForExecuteTimeNs) {
        this.computeInputsForExecuteTimeNs += computeInputsForExecuteTimeNs;
        if (this.delegate != null) {
            this.delegate.computeInputsForExecuteTimeNs(computeInputsForExecuteTimeNs);
        }
    }

    public void propagateNodeCommandsNs(long propagateNodeCommandsNs) {
        this.propagateNodeCommandsNs += propagateNodeCommandsNs;
        if (this.delegate != null) {
            this.delegate.propagateNodeCommandsNs(propagateNodeCommandsNs);
        }
    }

    public void executeMainLogicTimeNs(long executeMainLogicTimeNs) {
        this.executeMainLogicTimeNs += executeMainLogicTimeNs;
        if (this.delegate != null) {
            this.delegate.executeMainLogicTimeNs(executeMainLogicTimeNs);
        }
    }

    public void handleResolverCommandTimeNs(long handleResolverCommandTimeNs) {
        this.handleResolverCommandTimeNs += handleResolverCommandTimeNs;
        if (this.delegate != null) {
            this.delegate.handleResolverCommandTimeNs(handleResolverCommandTimeNs);
        }
    }

    public void executeResolversTimeNs(long executeResolversTimeNs) {
        this.executeResolversTimeNs += executeResolversTimeNs;
        if (this.delegate != null) {
            this.delegate.executeResolversTimeNs(executeResolversTimeNs);
        }
    }

    public void nodeInputsBatchCount() {
        ++this.nodeInputsBatchCount;
        if (this.delegate != null) {
            this.delegate.nodeInputsBatchCount();
        }
    }

    public void depCallbackBatchCount() {
        ++this.depCallbackBatchCount;
        if (this.delegate != null) {
            this.delegate.depCallbackBatchCount();
        }
    }

    public void executeMainLogicCount() {
        ++this.executeMainLogicCount;
        if (this.delegate != null) {
            this.delegate.executeMainLogicCount();
        }
    }
}

