/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.krystex.node;

import com.flipkart.krystal.data.Inputs;
import com.flipkart.krystal.data.ValueOrError;
import com.flipkart.krystal.krystex.KrystalExecutor;
import com.flipkart.krystal.krystex.MainLogicDefinition;
import com.flipkart.krystal.krystex.commands.BatchNodeCommand;
import com.flipkart.krystal.krystex.commands.Flush;
import com.flipkart.krystal.krystex.commands.ForwardBatchCommand;
import com.flipkart.krystal.krystex.commands.ForwardGranularCommand;
import com.flipkart.krystal.krystex.commands.GranularNodeCommand;
import com.flipkart.krystal.krystex.commands.NodeCommand;
import com.flipkart.krystal.krystex.commands.NodeDataCommand;
import com.flipkart.krystal.krystex.decoration.InitiateActiveDepChains;
import com.flipkart.krystal.krystex.decoration.LogicExecutionContext;
import com.flipkart.krystal.krystex.decoration.MainLogicDecorator;
import com.flipkart.krystal.krystex.decoration.MainLogicDecoratorConfig;
import com.flipkart.krystal.krystex.node.BatchNode;
import com.flipkart.krystal.krystex.node.BatchNodeResponse;
import com.flipkart.krystal.krystex.node.DependantChain;
import com.flipkart.krystal.krystex.node.DisabledDependantChainException;
import com.flipkart.krystal.krystex.node.GranularNode;
import com.flipkart.krystal.krystex.node.GranularNodeResponse;
import com.flipkart.krystal.krystex.node.KrystalNodeExecutorConfig;
import com.flipkart.krystal.krystex.node.KrystalNodeExecutorMetrics;
import com.flipkart.krystal.krystex.node.NodeDefinition;
import com.flipkart.krystal.krystex.node.NodeDefinitionRegistry;
import com.flipkart.krystal.krystex.node.NodeExecutionConfig;
import com.flipkart.krystal.krystex.node.NodeId;
import com.flipkart.krystal.krystex.node.NodeRegistry;
import com.flipkart.krystal.krystex.node.NodeResponse;
import com.flipkart.krystal.krystex.request.IntReqGenerator;
import com.flipkart.krystal.krystex.request.RequestId;
import com.flipkart.krystal.krystex.request.RequestIdGenerator;
import com.flipkart.krystal.krystex.request.StringReqGenerator;
import com.flipkart.krystal.utils.Futures;
import com.flipkart.krystal.utils.MultiLeasePool;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class KrystalNodeExecutor
implements KrystalExecutor {
    private static final Logger log = LoggerFactory.getLogger(KrystalNodeExecutor.class);
    private final NodeDefinitionRegistry nodeDefinitionRegistry;
    private final KrystalNodeExecutorConfig executorConfig;
    private final MultiLeasePool.Lease<? extends ExecutorService> commandQueueLease;
    private final String instanceId;
    private final ImmutableMap<String, List<MainLogicDecoratorConfig>> requestScopedLogicDecoratorConfigs;
    private final Map<String, Map<String, MainLogicDecorator>> requestScopedMainDecorators = new LinkedHashMap<String, Map<String, MainLogicDecorator>>();
    private final NodeRegistry<?> nodeRegistry = new NodeRegistry();
    private final KrystalNodeExecutorMetrics krystalNodeMetrics;
    private volatile boolean closed;
    private final Map<RequestId, NodeResult> allRequests = new LinkedHashMap<RequestId, NodeResult>();
    private final Set<RequestId> unFlushedRequests = new LinkedHashSet<RequestId>();
    private final Map<NodeId, Set<DependantChain>> dependantChainsPerNode = new LinkedHashMap<NodeId, Set<DependantChain>>();
    private final RequestIdGenerator preferredReqGenerator;

    public KrystalNodeExecutor(NodeDefinitionRegistry nodeDefinitionRegistry, MultiLeasePool<? extends ExecutorService> commandQueuePool, KrystalNodeExecutorConfig executorConfig, String instanceId) {
        this.nodeDefinitionRegistry = nodeDefinitionRegistry;
        this.executorConfig = executorConfig;
        this.commandQueueLease = commandQueuePool.lease();
        this.instanceId = instanceId;
        this.requestScopedLogicDecoratorConfigs = ImmutableMap.copyOf(executorConfig.requestScopedLogicDecoratorConfigs());
        this.krystalNodeMetrics = new KrystalNodeExecutorMetrics();
        this.preferredReqGenerator = executorConfig.debug() ? new StringReqGenerator() : new IntReqGenerator();
    }

    private ImmutableMap<String, MainLogicDecorator> getRequestScopedDecorators(LogicExecutionContext logicExecutionContext) {
        NodeId nodeId = logicExecutionContext.nodeId();
        NodeDefinition nodeDefinition = this.nodeDefinitionRegistry.get(nodeId);
        MainLogicDefinition mainLogicDefinition = nodeDefinition.getMainLogicDefinition();
        LinkedHashMap decorators = new LinkedHashMap();
        Stream.concat(mainLogicDefinition.getRequestScopedLogicDecoratorConfigs().entrySet().stream(), this.requestScopedLogicDecoratorConfigs.entrySet().stream()).forEach(entry -> {
            String decoratorType = (String)entry.getKey();
            ArrayList decoratorConfigList = new ArrayList((Collection)entry.getValue());
            decoratorConfigList.forEach(decoratorConfig -> {
                String instanceId = decoratorConfig.instanceIdGenerator().apply(logicExecutionContext);
                if (decoratorConfig.shouldDecorate().test(logicExecutionContext)) {
                    MainLogicDecorator mainLogicDecorator = this.requestScopedMainDecorators.computeIfAbsent(decoratorType, t -> new LinkedHashMap()).computeIfAbsent(instanceId, _i -> decoratorConfig.factory().apply(new MainLogicDecoratorConfig.DecoratorContext(instanceId, logicExecutionContext)));
                    mainLogicDecorator.executeCommand(new InitiateActiveDepChains(nodeId, (ImmutableSet<DependantChain>)ImmutableSet.copyOf((Collection)this.dependantChainsPerNode.get(nodeId))));
                    decorators.putIfAbsent(decoratorType, mainLogicDecorator);
                }
            });
        });
        return ImmutableMap.copyOf(decorators);
    }

    @Override
    public <T> CompletableFuture<T> executeNode(NodeId nodeId, Inputs inputs, NodeExecutionConfig executionConfig) {
        if (this.closed) {
            throw new RejectedExecutionException("KrystalNodeExecutor is already closed");
        }
        Preconditions.checkArgument((executionConfig != null ? 1 : 0) != 0, (Object)"executionConfig can not be null");
        String executionId = executionConfig.executionId();
        Preconditions.checkArgument((executionId != null ? 1 : 0) != 0, (Object)"executionConfig.executionId can not be null");
        RequestId requestId = this.preferredReqGenerator.newRequest("%s:%s".formatted(this.instanceId, executionId));
        return this.enqueueCommand(() -> {
            this.createDependencyNodes(nodeId, this.nodeDefinitionRegistry.getDependantChainsStart(), executionConfig);
            CompletableFuture<Object> future = new CompletableFuture<Object>();
            if (this.allRequests.containsKey(requestId)) {
                future.completeExceptionally(new IllegalArgumentException("Received duplicate requests for same instanceId '%s' and execution Id '%s'".formatted(this.instanceId, executionId)));
            } else {
                this.allRequests.put(requestId, new NodeResult(nodeId, requestId, inputs, executionConfig, future));
                this.unFlushedRequests.add(requestId);
            }
            return future;
        }).thenCompose(Function.identity());
    }

    private void createDependencyNodes(NodeId nodeId, DependantChain dependantChain, NodeExecutionConfig executionConfig) {
        NodeDefinition nodeDefinition = this.nodeDefinitionRegistry.get(nodeId);
        if (!Sets.union(this.executorConfig.disabledDependantChains(), executionConfig.disabledDependantChains()).contains((Object)dependantChain)) {
            this.createNodeIfAbsent(nodeId, nodeDefinition);
            ImmutableMap<String, NodeId> dependencyNodes = nodeDefinition.dependencyNodes();
            dependencyNodes.forEach((dependencyName, depNodeId) -> this.createDependencyNodes((NodeId)depNodeId, dependantChain.extend(nodeId, (String)dependencyName), executionConfig));
            this.dependantChainsPerNode.computeIfAbsent(nodeId, _n -> new LinkedHashSet()).add(dependantChain);
        }
    }

    private void createNodeIfAbsent(NodeId nodeId, NodeDefinition nodeDefinition) {
        if (this.isGranular()) {
            this.nodeRegistry.createIfAbsent(nodeId, _n -> new GranularNode(nodeDefinition, this, this::getRequestScopedDecorators, this.executorConfig.logicDecorationOrdering(), this.executorConfig.resolverExecStrategy()));
        } else {
            NodeRegistry<?> batchNodeRegistry = this.nodeRegistry;
            batchNodeRegistry.createIfAbsent(nodeId, _n -> new BatchNode(nodeDefinition, this, this::getRequestScopedDecorators, this.executorConfig.logicDecorationOrdering(), this.executorConfig.resolverExecStrategy(), this.preferredReqGenerator));
        }
    }

    private boolean isGranular() {
        return NodeExecStrategy.GRANULAR.equals((Object)this.executorConfig.nodeExecStrategy());
    }

    <R extends NodeResponse> CompletableFuture<R> enqueueNodeCommand(Supplier<? extends NodeCommand> nodeCommand) {
        return this.enqueueCommand(() -> this._executeCommand((NodeCommand)nodeCommand.get())).thenCompose(Function.identity());
    }

    <T extends NodeResponse> CompletableFuture<T> executeCommand(NodeCommand nodeCommand) {
        if (GraphTraversalStrategy.BREADTH.equals((Object)this.executorConfig.graphTraversalStrategy())) {
            return this.enqueueNodeCommand(() -> nodeCommand);
        }
        this.krystalNodeMetrics.commandQueueBypassed();
        return this._executeCommand(nodeCommand);
    }

    private <R extends NodeResponse> CompletableFuture<R> _executeCommand(NodeCommand nodeCommand) {
        try {
            this.validate(nodeCommand);
        }
        catch (Throwable e) {
            return CompletableFuture.failedFuture(e);
        }
        if (nodeCommand instanceof NodeDataCommand) {
            NodeDataCommand dataCommand = (NodeDataCommand)nodeCommand;
            Object node = this.nodeRegistry.get(nodeCommand.nodeId());
            return node.executeCommand((NodeDataCommand)dataCommand);
        }
        if (nodeCommand instanceof Flush) {
            Flush flush = (Flush)nodeCommand;
            this.nodeRegistry.get(flush.nodeId()).executeCommand(flush);
            return CompletableFuture.completedFuture(null);
        }
        throw new UnsupportedOperationException("Unknown NodeCommand type %s".formatted(nodeCommand.getClass()));
    }

    private void validate(NodeCommand nodeCommand) {
        if (nodeCommand instanceof NodeDataCommand) {
            RequestId originRequest;
            NodeDataCommand dataCommand = (NodeDataCommand)nodeCommand;
            DependantChain dependantChain = dataCommand.dependantChain();
            if (nodeCommand instanceof GranularNodeCommand) {
                GranularNodeCommand granular = (GranularNodeCommand)nodeCommand;
                originRequest = granular.requestId().originatedFrom();
            } else if (nodeCommand instanceof BatchNodeCommand) {
                BatchNodeCommand batch = (BatchNodeCommand)nodeCommand;
                originRequest = batch.requestIds().stream().map(RequestId::originatedFrom).findAny().orElseThrow(() -> new IllegalStateException("All request should have some origin request"));
            } else {
                throw new UnsupportedOperationException();
            }
            if (Sets.union(this.executorConfig.disabledDependantChains(), this.allRequests.get(originRequest).executionConfig().disabledDependantChains()).contains((Object)dependantChain)) {
                throw new DisabledDependantChainException(dependantChain);
            }
        } else if (nodeCommand instanceof Flush) {
            Flush flush = (Flush)nodeCommand;
            DependantChain dependantChain = flush.nodeDependants();
            if (this.executorConfig.disabledDependantChains().contains((Object)dependantChain)) {
                throw new DisabledDependantChainException(dependantChain);
            }
            if (this.allRequests.values().stream().map(NodeResult::executionConfig).map(NodeExecutionConfig::disabledDependantChains).allMatch(disableDepChains -> disableDepChains.contains((Object)dependantChain))) {
                throw new DisabledDependantChainException(dependantChain);
            }
        }
    }

    @Override
    public void flush() {
        this.enqueueRunnable(() -> {
            if (this.isGranular()) {
                this.unFlushedRequests.forEach(requestId -> {
                    NodeResult nodeResult = this.allRequests.get(requestId);
                    NodeId nodeId = nodeResult.nodeId();
                    if (nodeResult.future().isDone()) {
                        return;
                    }
                    NodeDefinition nodeDefinition = this.nodeDefinitionRegistry.get(nodeId);
                    this.submitGranular((RequestId)requestId, nodeResult, nodeId, nodeDefinition);
                });
            } else {
                this.submitBatch(this.unFlushedRequests);
            }
            this.unFlushedRequests.stream().map(requestId -> this.allRequests.get(requestId).nodeId()).distinct().forEach(nodeId -> this.executeCommand(new Flush((NodeId)nodeId, this.nodeDefinitionRegistry.getDependantChainsStart())));
        });
    }

    private void submitGranular(RequestId requestId, NodeResult nodeResult, NodeId nodeId, NodeDefinition nodeDefinition) {
        CompletionStage submissionResult = ((CompletableFuture)this.executeCommand(new ForwardGranularCommand(nodeId, (ImmutableSet<String>)((ImmutableSet)nodeDefinition.getMainLogicDefinition().inputNames().stream().filter(s -> !nodeDefinition.dependencyNodes().containsKey(s)).collect(ImmutableSet.toImmutableSet())), nodeResult.inputs(), this.nodeDefinitionRegistry.getDependantChainsStart(), requestId)).thenApply(GranularNodeResponse::response)).thenApply(valueOrError -> {
            if (valueOrError.error().isPresent()) {
                throw new RuntimeException((Throwable)valueOrError.error().get());
            }
            return valueOrError.value().orElse(null);
        });
        Futures.linkFutures((CompletableFuture)submissionResult, nodeResult.future());
    }

    private void submitBatch(Set<RequestId> unFlushedRequests) {
        unFlushedRequests.stream().map(this.allRequests::get).collect(Collectors.groupingBy(NodeResult::nodeId)).forEach((nodeId, nodeResults) -> {
            NodeDefinition nodeDefinition = this.nodeDefinitionRegistry.get((NodeId)nodeId);
            CompletableFuture batchResponseFuture = this.executeCommand(new ForwardBatchCommand((NodeId)nodeId, (ImmutableSet<String>)((ImmutableSet)nodeDefinition.getMainLogicDefinition().inputNames().stream().filter(s -> !nodeDefinition.dependencyNodes().containsKey(s)).collect(ImmutableSet.toImmutableSet())), (ImmutableMap<RequestId, Inputs>)((ImmutableMap)nodeResults.stream().collect(ImmutableMap.toImmutableMap(NodeResult::requestId, NodeResult::inputs))), this.nodeDefinitionRegistry.getDependantChainsStart(), (ImmutableMap<RequestId, String>)ImmutableMap.of()));
            ((CompletableFuture)batchResponseFuture.thenApply(BatchNodeResponse::responses)).whenComplete((responses, throwable) -> {
                for (NodeResult nodeResult : nodeResults) {
                    if (throwable != null) {
                        nodeResult.future().completeExceptionally((Throwable)throwable);
                        continue;
                    }
                    ValueOrError result = (ValueOrError)responses.getOrDefault((Object)nodeResult.requestId(), (Object)ValueOrError.empty());
                    nodeResult.future().complete(result.value().orElse(null));
                }
            });
            Futures.propagateCancellation(CompletableFuture.allOf((CompletableFuture[])nodeResults.stream().map(NodeResult::future).toArray(CompletableFuture[]::new)), batchResponseFuture);
        });
    }

    public KrystalNodeExecutorMetrics getKrystalNodeMetrics() {
        return this.krystalNodeMetrics;
    }

    @Override
    public void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        this.flush();
        this.enqueueCommand(() -> CompletableFuture.allOf((CompletableFuture[])this.allRequests.values().stream().map(NodeResult::future).toArray(CompletableFuture[]::new)).whenComplete((unused, throwable) -> this.commandQueueLease.close()));
    }

    private CompletableFuture<Void> enqueueRunnable(Runnable command) {
        return this.enqueueCommand(() -> {
            command.run();
            return null;
        });
    }

    private <T> CompletableFuture<T> enqueueCommand(Supplier<T> command) {
        return CompletableFuture.supplyAsync(() -> {
            this.krystalNodeMetrics.commandQueued();
            return command.get();
        }, (Executor)this.commandQueueLease.get());
    }

    public static enum NodeExecStrategy {
        GRANULAR,
        BATCH;

    }

    public static enum GraphTraversalStrategy {
        DEPTH,
        BREADTH;

    }

    private record NodeResult(NodeId nodeId, RequestId requestId, Inputs inputs, NodeExecutionConfig executionConfig, CompletableFuture<Object> future) {
    }

    public static enum ResolverExecStrategy {
        SINGLE,
        MULTI;

    }
}

